import {
  LayoutGrid,
  MessageSquare,
  FolderClosed,
  FileSignature,
  Users,
  Kanban,
  Megaphone,
  ContactRound,
} from "lucide-react";

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export const iconMap: Record<string, React.ComponentType<any>> = {
  LayoutGrid,
  MessageSquare,
  FolderClosed,
  FileSignature,
  Users,
  Kanban,
  Megaphone,
  ContactRound,
};

export const getIcon = (iconName: string, className?: string) => {
  const IconComponent = iconMap[iconName];
  if (!IconComponent) return null;
  return <IconComponent className={className} />;
};
