/* eslint-disable prefer-const */
import {
  Card,
  CardContent,
  Typography,
  Box,
  Container as MuiContainer,
  useTheme,
} from "@mui/material";
import { useEffect, useRef } from "react";

export const Container = () => {
  const theme = useTheme();
  const isDarkMode = theme.palette.mode === "dark";
  const scrollContainerRef = useRef<HTMLDivElement>(null);

  const companyLogos = [
    {
      name: "Questhire",
      imageUrl: "../../public/images/QuesthireLogo.png",
      baseWidth: 148,
      baseHeight: 68,
    },
    {
      name: "Chatbox",
      imageUrl: "../../public/images/chatboxLogo.png",
      baseWidth: 148,
      baseHeight: 68,
    },
    {
      name: "Hirely",
      imageUrl: "../../public/images/hirelyLogo.png",
      baseWidth: 148,
      baseHeight: 50,
      forceBlackInLightMode: true,
    },
    {
      name: "Wurknest",
      imageUrl: "../../public/images/wurknestLogo.png",
      baseWidth: 148,
      baseHeight: 68,
      forceBlackInLightMode: true,
    },
    {
      name: "Taskly",
      imageUrl: "../../public/images/tasklyLogo.png",
      baseWidth: 148,
      baseHeight: 40,
    },
    {
      name: "Appstir",
      imageUrl: "../../public/images/AppstirLogo.png",
      baseWidth: 148,
      baseHeight: 54.55,
    },
  ];

  const duplicatedLogos = [...companyLogos, ...companyLogos];

  const mediumScale = 0.7;

  useEffect(() => {
    const scrollContainer = scrollContainerRef.current;
    if (!scrollContainer) return;

    let animationFrameId: number;
    let scrollSpeed = 1;
    let scrollPosition = 0;
    const maxScroll = scrollContainer.scrollWidth / 2;

    const animate = () => {
      scrollPosition += scrollSpeed;

      if (scrollPosition >= maxScroll) {
        scrollPosition = 0;
      }

      scrollContainer.scrollLeft = scrollPosition;
      animationFrameId = requestAnimationFrame(animate);
    };

    animationFrameId = requestAnimationFrame(animate);

    const handleMouseEnter = () => {
      cancelAnimationFrame(animationFrameId);
    };

    const handleMouseLeave = () => {
      animationFrameId = requestAnimationFrame(animate);
    };

    scrollContainer.addEventListener("mouseenter", handleMouseEnter);
    scrollContainer.addEventListener("mouseleave", handleMouseLeave);

    return () => {
      cancelAnimationFrame(animationFrameId);
      scrollContainer.removeEventListener("mouseenter", handleMouseEnter);
      scrollContainer.removeEventListener("mouseleave", handleMouseLeave);
    };
  }, []);

  return (
    <MuiContainer
      maxWidth="xl"
      sx={{
        py: { xs: 2, sm: 3, md: 4, lg: 4, xl: 5 },
        px: { xs: 2, sm: 3, md: 4, lg: 4, xl: 4 },
        mt: { lg: 5, xl: 5 },
        backgroundColor: theme.palette.background.default,
        zIndex: 1,
        position: "relative",
      }}
    >
      <Card
        elevation={0}
        sx={{
          backgroundColor: "transparent",
          marginTop: { xs: "-45px", sm: "-55px", md: "-65px" },
        }}
      >
        <CardContent
          sx={{
            display: "flex",
            flexDirection: { xs: "column", sm: "row" },
            alignItems: "center",
            justifyContent: "center",
            gap: { xs: 2, sm: 4, md: 6, lg: 8, xl: 10 },
            px: { xs: 0, sm: 2, md: 3, lg: 4 },
            py: { xs: 2, sm: 3, md: 4, lg: 5 },
            backgroundColor: "transparent",
          }}
        >
          <Box
            sx={{
              display: { xs: "none", md: "block", lg: "block" },
              width: {
                xs: "100%",
                sm: "160px",
                md: "180px",
                lg: "200px",
                xl: "220px",
              },
              textAlign: { xs: "center", sm: "left" },
              mb: { xs: 2, sm: 0 },
              flexShrink: 0,
            }}
          >
            <Typography
              variant="h5"
              sx={{
                fontFamily: "Epilogue",
                fontWeight: 700,
                fontSize: {
                  xs: "18px",
                  sm: "20px",
                  md: "22px",
                  lg: "24px",
                  xl: "25px",
                },
                letterSpacing: "-0.16px",
                lineHeight: {
                  xs: "28px",
                  sm: "30px",
                  md: "32px",
                  lg: "34px",
                  xl: "35px",
                },
                color: theme.palette.text.primary,
              }}
            >
              Trusted By
            </Typography>
          </Box>

          <Box
            ref={scrollContainerRef}
            sx={{
              display: "flex",
              flexDirection: "row",
              flexWrap: "nowrap",
              alignItems: "center",
              gap: {
                xs: "24px",
                sm: "32px",
                md: "40px",
                lg: "48px",
                xl: "56px",
              },
              width: "100%",
              overflow: "hidden",
              py: 2,
              px: 1,
            }}
          >
            {duplicatedLogos.map((logo, index) => (
              <Box
                key={`${logo.name}-${index}`}
                sx={{
                  display: "flex",
                  justifyContent: "center",
                  alignItems: "center",
                  height: {
                    xs: `${logo.baseHeight * mediumScale * 0.6}px`,
                    sm: `${logo.baseHeight * mediumScale * 0.8}px`,
                    md: `${logo.baseHeight * mediumScale}px`,
                    lg: `${logo.baseHeight * mediumScale * 1.1}px`,
                    xl: `${logo.baseHeight * mediumScale * 1.2}px`,
                  },
                  flexShrink: 0,
                  px: { xs: 0.5, sm: 1 },
                  animation: "pulse 2s infinite ",
                  "@keyframes pulse": {
                    "0%, 100%": { transform: "scale(1)" },
                    "50%": { transform: "scale(1.05)" },
                  },
                }}
              >
                <Box
                  component="img"
                  src={logo.imageUrl}
                  alt={logo.name}
                  sx={{
                    width: "auto",
                    height: "100%",
                    maxWidth: {
                      xs: `${logo.baseWidth * mediumScale * 0.6}px`,
                      sm: `${logo.baseWidth * mediumScale * 0.8}px`,
                      md: `${logo.baseWidth * mediumScale}px`,
                      lg: `${logo.baseWidth * mediumScale * 1.1}px`,
                      xl: `${logo.baseWidth * mediumScale * 1.2}px`,
                    },
                    objectFit: "contain",
                    filter: isDarkMode
                      ? "brightness(0) invert(1)"
                      : logo.forceBlackInLightMode
                      ? "brightness(0)"
                      : "none",
                    transition: "all 0.3s ease",
                    "&:hover": {
                      transform: "scale(1.1)",
                      animation: "none",
                    },
                  }}
                />
              </Box>
            ))}
          </Box>
        </CardContent>
      </Card>
    </MuiContainer>
  );
};

export default Container;
