"use client";

import React from "react";
import { FaStar, FaCheckCircle } from "react-icons/fa";
import { HiSparkles } from "react-icons/hi2";

interface User {
  name: string;
  avatarUrl: string;
}

interface TrustedBusinessesProps {
  users?: User[];
  businessCount?: string;
  className?: string;
}

const TrustedBusinessesComponent: React.FC<TrustedBusinessesProps> = ({
  users = [
    {
      name: "Emma Johnson",
      avatarUrl:
        "https://images.pexels.com/photos/733872/pexels-photo-733872.jpeg?auto=compress&cs=tinysrgb&w=150",
    },
    {
      name: "Michael Chen",
      avatarUrl:
        "https://images.pexels.com/photos/2379005/pexels-photo-2379005.jpeg?auto=compress&cs=tinysrgb&w=150",
    },
    {
      name: "Amara Williams",
      avatarUrl:
        "https://images.pexels.com/photos/1239291/pexels-photo-1239291.jpeg?auto=compress&cs=tinysrgb&w=150",
    },
  ],
  businessCount = "30k+",
  className = "",
}) => {
  return (
    <div className={`group ${className}`}>
      {/* Modern glassmorphism card */}
      <div className="relative inline-flex items-center gap-3 md:gap-4 px-4 md:px-6 py-3 md:py-4 bg-white/80 dark:bg-white/10 backdrop-blur-md border border-gray-200 dark:border-white/20 rounded-2xl md:rounded-3xl shadow-lg hover:shadow-xl transition-all duration-500 hover:scale-[1.02] overflow-hidden">
        
        {/* Animated gradient background */}
        <div className="absolute inset-0 bg-gradient-to-r from-blue-500/5 via-purple-500/5 to-pink-500/5 dark:from-blue-500/10 dark:via-purple-500/10 dark:to-pink-500/10 opacity-0 group-hover:opacity-100 transition-opacity duration-500" />
        
        {/* Sparkle effect */}
        <div className="absolute top-2 right-2 text-yellow-400 opacity-0 group-hover:opacity-100 transition-all duration-500 group-hover:rotate-12">
          <HiSparkles className="w-4 h-4 md:w-5 md:h-5" />
        </div>

        {/* Avatar Stack */}
        <div className="relative flex items-center z-10">
          {users.map((user, index) => (
            <div
              key={index}
              className="relative transition-transform duration-300 group-hover:scale-110"
              style={{
                marginLeft: index === 0 ? 0 : "-12px",
                zIndex: users.length - index,
                animationDelay: `${index * 100}ms`,
              }}
            >
              <div className="relative">
                {/* Avatar glow effect */}
                <div className="absolute inset-0 rounded-full bg-gradient-to-r from-blue-500 to-purple-500 opacity-0 group-hover:opacity-20 blur-md transition-opacity duration-500" />
                
                {/* Avatar image */}
                <img
                  src={user.avatarUrl}
                  alt={user.name}
                  className="w-10 h-10 md:w-12 md:h-12 rounded-full border-2 md:border-3 border-white dark:border-gray-900 object-cover shadow-md transition-all duration-300"
                />
                
                {/* Verified badge on first avatar */}
                {index === 0 && (
                  <div className="absolute -bottom-1 -right-1 w-4 h-4 md:w-5 md:h-5 bg-green-500 rounded-full flex items-center justify-center border-2 border-white dark:border-gray-900 animate-pulse">
                    <FaCheckCircle className="w-2.5 h-2.5 md:w-3 md:h-3 text-white" />
                  </div>
                )}
              </div>
            </div>
          ))}
        </div>

        {/* Divider */}
        <div className="hidden md:block w-px h-8 bg-gradient-to-b from-transparent via-gray-300 dark:via-gray-600 to-transparent" />

        {/* Text content */}
        <div className="relative z-10 flex flex-col gap-0.5">
          <div className="flex items-center gap-1.5">
            <span className="text-lg md:text-2xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 dark:from-blue-400 dark:via-purple-400 dark:to-pink-400 bg-clip-text text-transparent">
              {businessCount}
            </span>
            <span className="text-sm md:text-base font-semibold text-gray-700 dark:text-gray-300">
              Businesses
            </span>
          </div>
          
          <div className="flex items-center gap-1 md:gap-1.5">
            {/* Star rating */}
            <div className="flex gap-0.5">
              {[...Array(5)].map((_, i) => (
                <FaStar
                  key={i}
                  className="w-2.5 h-2.5 md:w-3 md:h-3 text-yellow-400 drop-shadow-sm"
                  style={{
                    animation: `twinkle 2s ease-in-out ${i * 0.2}s infinite`,
                  }}
                />
              ))}
            </div>
            <span className="text-xs md:text-sm text-gray-600 dark:text-gray-400 font-medium ml-1">
              Trust Clikkle
            </span>
          </div>
        </div>
      </div>

      {/* CSS animations */}
      <style jsx>{`
        @keyframes twinkle {
          0%, 100% { opacity: 1; transform: scale(1); }
          50% { opacity: 0.7; transform: scale(0.95); }
        }
      `}</style>
    </div>
  );
};

export default TrustedBusinessesComponent;
