import { Button, Typography } from "@mui/material";
import React from "react";
import Link from "next/link";
import Image from "next/image";
import KeyboardArrowDownOutlinedIcon from "@mui/icons-material/KeyboardArrowDownOutlined";
import { useRef } from "react";

export type HrHomeFeatureProps = {
  title: string;
  illistrationUrl: string;
  name: string;
  description: string;
};

export const hrFeatures: HrHomeFeatureProps[] = [
  {
    title:
      "See what you can do with Streamlining the Management of HR Processes",
    name: "Streamlining the management of HR processes",
    description:
      "Clikkle HR simplifies the handling of tasks, reducing complexities in managing diverse HR functions by centralizing and automating HR operations. This helps to enhance productivity.",
    illistrationUrl: "2.png",
  },
  {
    title:
      "See what you can do with Analyzing and Reporting on Human Resources Data",
    name: "Analyzing and reporting on human resources data",
    description:
      "Clikkle HR uses data to help organizations make informed decisions about hiring, training, and retaining employees by drawing insights from data patterns and trends.",
    illistrationUrl: "3.png",
  },
  {
    title:
      "See what you can do with Digitalized Employee Records Eliminating Paper Usage",
    name: "Digitalized employee records eliminating paper usage",
    description:
      "Clikkle HR minimizes clutter, enhances accessibility, and promotes eco-friendly practices within HR operations by transitioning to an electronic format.",
    illistrationUrl: "4.png",
  },
  {
    title:
      "See what you can do with Simplified HR and Personnel Administration",
    name: "Simplified HR and personnel administration",
    description:
      "Clikkle HR is designed to optimize and simplify the handling of HR and personnel tasks, ensuring a more efficient and straight forward administration process.",
    illistrationUrl: "5.png",
  },
  {
    title: "See what you can do with HR Resources to Get You Started",
    name: "Comprehensive Assistance for Seamless HR Management",
    description:
      "Clikkle HR prioritizes providing exceptional support to ensure your HR processes run smoothly. Our support system offers 24/7 assistance whenever needed.",
    illistrationUrl: "6.png",
  },
];

const HrHomeFeature: React.FC<{
  hrFeatures: HrHomeFeatureProps;
  left: boolean;
  theme: string;
}> = ({ hrFeatures, left, theme = "light" }) => {
  const containerRef = useRef<HTMLDivElement | null>(null);



  return (
    <div
      ref={containerRef}
      id={hrFeatures.name.replace(/\s+/g, "-").toLowerCase()}
    >
      <h6 className="lg:text-lg sm:text-xs font-[500] w-full px-10 pt-1 mb-20  sm:m-0 text-center text-gray-800 dark:text-gray-300 sm:pt-2 lg:pt-28">
        {hrFeatures.title}
        <div
          className="flex items-center justify-center mt-1 animate-bounce"
          
        >
          <KeyboardArrowDownOutlinedIcon />
        </div>
      </h6>
      <div
        className={`w-full sm:mt-4 pt-[90px] flex flex-col sm:flex-row items-center justify-between  p-2 ${
          left ? "sm:flex-row" : "sm:flex-row-reverse"
        }`}
      >
        <Image
          src={`.././images/${theme}-${hrFeatures.illistrationUrl}`}
          className="h-80 w-auto lg:h-[calc(105vh-10px)] sm:h-[calc(80vh-300px)] sm:w-auto ml-0 "
          alt={`Illustration of ${hrFeatures.name}`}
          width={600}
          height={400}
        />
        <div className="max-w-[600px] w-[80%] flex-grow sm:py-16  sm:my-8  sm:ml-6">
          <div className="flex items-center justify-center gap-4 sm:justify-start">
            <Typography
              className="hidden font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300"
              style={{ fontSize: "1.8rem" }}
            >
              {hrFeatures.name}
            </Typography>
            <Typography
              className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0"
              style={{ fontSize: "1.2rem" }}
            >
              {hrFeatures.name}
            </Typography>
          </div>

          <br className="hidden sm:block" />
          <Typography
            className="hidden font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300"
            style={{ fontSize: "0.8rem" }}
          >
            {hrFeatures.description}
          </Typography>

          <Typography
            className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0"
            style={{ fontSize: "0.6rem" }}
          >
            {hrFeatures.description}
          </Typography>

          <br className="hidden sm:block" />

          <div className="flex items-center justify-center gap-4 sm:justify-start sm:mb-0">
            <Button size="small" variant="contained">
              <Link
                 href={`https://hr.clikkle.com/signup?referrer=https://www.clikkle.com/hr&&redirectto=https://hr.clikkle.com?theme=${theme}`}
              >
                Get Started
              </Link>
            </Button>
            <Button size="small" variant="outlined">
              <Link
                 href={`https://hr.clikkle.com/signup?referrer=https://www.clikkle.com/hr&&redirectto=https://hr.clikkle.com?theme=${theme}`}
              >
                Learn More
              </Link>
            </Button>
          </div>
        </div>
      </div>
    </div>
  );
};

export default HrHomeFeature;
