import { useTheme } from "../atoms/theme";
import Link from "next/link";
import Image from "next/image";

import { usePathname } from "next/navigation";

const Brand = () => {
  const pathname = usePathname();
  const { theme } = useTheme();
  const isDarkMode = theme === "dark";

  const getBrandInfo = () => {
    const path = pathname;
    switch (path) {
      case "/campaigns":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/campaigns/logo/2025/Clikkle%20Campaigns%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/campaigns/logo/2025/Clikkle%20Campaigns%20Blue%20(%20White%20Text).png",
        };
      case "/host":
        return {
          logoLight: "https://cdn.clikkle.com/images/host/logo/2023/host.png",
          logoDark:
            "https://cdn.clikkle.com/images/host/logo/2023/host-dark.png",
        };
      case "/creator":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/creator/logo/2025/Clikkle%20Creator%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/creator/logo/2025/Clikkle%20Creator%20Blue%20(%20White%20Text).png",
        };
      case "/files":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/files/logo/2025/Clikkle%20Files%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/files/logo/2025/Clikkle%20Files%20Blue%20(%20White%20Text).png",
        };
      case "/esign":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/e-sign/logo/2025/Clikkle%20esign%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/e-sign/logo/2025/Clikkle%20esign%20Blue%20(%20White%20Text).png",
        };
      case "/ads":
        return {
          logoLight: "https://cdn.clikkle.com/images/ads/logo/2023/ads.png",
          logoDark: "https://cdn.clikkle.com/images/ads/logo/2023/ads-dark.png",
        };
      case "/pitch":
        return {
          logoLight: "https://cdn.clikkle.com/images/pitch/logo/2023/pitch.png",
          logoDark:
            "https://cdn.clikkle.com/images/pitch/logo/2023/pitch-dark.png",
        };
      case "/mail":
        return {
          logoLight: "https://cdn.clikkle.com/images/cmail/logo/2023/cmail.png",
          logoDark:
            "https://cdn.clikkle.com/images/cmail/logo/2023/cmail-dark.png",
        };
      case "/projects":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/projects/logo/2025/Clikkle%20Project%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/projects/logo/2025/Clikkle%20Projects%20Blue%20(%20White%20Text).png",
        };
      case "/launch":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/launch/logo/2023/launch.png",
          logoDark:
            "https://cdn.clikkle.com/images/launch/logo/2023/launch-dark.png",
        };
      case "/hr":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/hr/logo/2025/Clikkle%20HR%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/hr/logo/2025/Clikkle%20HR%20Blue%20(%20White%20Text).png",
        };
      case "/tax":
        return {
          logoLight: "https://cdn.clikkle.com/images/tax/logo/2023/tax.png",
          logoDark: "https://cdn.clikkle.com/images/tax/logo/2023/tax-dark.png",
        };
      case "/chat":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/chat/logo/2025/Clikkle%20Chat%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/chat/logo/2025/Clikkle%20Chat%20Blue%20(%20White%20Text).png",
        };
      case "/social":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/social/logo/2023/social.png",
          logoDark:
            "https://cdn.clikkle.com/images/social/logo/2023/social-dark.png",
        };
      case "/watsup":
        return {
          logoLight: "https://cdn.clikkle.com/images/sms/logo/2023/sms.png",
          logoDark: "https://cdn.clikkle.com/images/sms/logo/2023/sms-dark.png",
        };
      case "/crew":
        return {
          logoLight: "https://cdn.clikkle.com/images/crew/logo/2023/crew.png",
          logoDark:
            "https://cdn.clikkle.com/images/crew/logo/2023/crew-dark.png",
        };
      case "/swiprr":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/swiprr/logo/2023/swiprr.png",
          logoDark:
            "https://cdn.clikkle.com/images/swiprr/logo/2023/swiprr-dark.png",
        };
      case "/crm":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/crm/2025/Clikkle%20crm%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/crm/2025/Clikkle%20crm%20Blue%20(%20White%20Text).png",
        };
      case "/keptup":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/kept-up/logo/2023/kept-up.png",
          logoDark:
            "https://cdn.clikkle.com/images/kept-up/logo/2023/kept-up-dark.png",
        };
      case "/hub":
        return {
          logoLight:
            "https://cdn.clikkle.com/images/hub/2025/Clikkle%20Worksuite%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/hub/2025/Clikkle%20Worksuite%20Blue%20(%20White%20Text).png",
        };
      default:
        return {
          logoLight:
            "https://cdn.clikkle.com/images/clikkle/logo/2025/Clikkle%20Blue%20(%20Black%20Text).png",
          logoDark:
            "https://cdn.clikkle.com/images/clikkle/logo/2025/Clikkle%20Blue%20(%20White%20Text).png",
          isHome: true,
        };
    }
  };

  const { logoLight, logoDark } = getBrandInfo();

  return (
    <div className="flex items-center flex-grow gap-2">
      <Link href="https://clikkle.com">
        <Image
          alt="Clikkle Logo"
          src={isDarkMode ? logoDark : logoLight}
          width={114}
          height={40}
          className="h-auto w-[90px] md:w-[114px]"
        />
      </Link>
    </div>
  );
};

export default Brand;
