"use client";

import Image, { StaticImageData } from "next/image";
import React from "react";
import { LucideIcon } from "lucide-react";
import { CheckCircle2 } from "lucide-react";

interface MiniFeature {
  title: string;
  description: string;
}

interface MainFeature {
  badge: string;
  icon: LucideIcon;
  title: string;
  description: string;
  image: string | StaticImageData;
  miniFeatures: MiniFeature[];
}

interface FeatureCard {
  icon: LucideIcon;
  title: string;
  description: string;
}

interface WhyProductSectionProps {
  badge: string;
  heading: string;
  subheading: string;
  mainFeature: MainFeature;
  featureCards: FeatureCard[];
}

const WhyProductSection: React.FC<WhyProductSectionProps> = ({
  badge,
  heading,
  subheading,
  mainFeature,
  featureCards,
}) => {
  const MainIcon = mainFeature.icon;

  return (
    <section className="w-full max-w-[1233px] py-16 mx-auto px-6 md:px-0">
      <div className="mx-auto">
        <div className="max-w-[1233px] mx-auto">
          <div className="flex flex-col items-center justify-center">
            {/* Header Section */}
            <div className="w-full mb-8 sm:mb-12 md:mb-16 text-center">
              <div className="flex items-center justify-center gap-3 mb-6">
                <span className="text-[#253237] dark:text-white font-semibold tracking-wider uppercase text-sm bg-[#090241]/10 dark:bg-[#16171B] px-4 py-2 rounded-full">
                  {badge}
                </span>
              </div>
              <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl xl:text-6xl font-bold text-[#253237] dark:text-white mb-4 md:mb-6 leading-tight">
                {heading}
              </h2>
              <p className="text-[#3D3D3D] dark:text-[#94A3B8] text-sm sm:text-base md:text-lg lg:text-xl max-w-3xl mx-auto leading-relaxed">
                {subheading}
              </p>
            </div>

            {/* Main Feature Card */}
            <div className="bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-6 sm:p-6 md:p-8 lg:p-12 max-w-[1233px] w-full shadow-lg mb-8 md:mb-12">
              <div className="flex flex-col lg:flex-row gap-6 md:gap-8 lg:gap-12 items-center">
                {/* Image Side */}
                <div className="w-full lg:w-1/2">
                  <div className="relative rounded-xl overflow-hidden shadow-xl">
                    {typeof mainFeature.image === 'string' ? (
                      <img
                        src={mainFeature.image}
                        alt={mainFeature.title}
                        className="w-full h-full object-cover"
                      />
                    ) : (
                      <Image
                        src={mainFeature.image}
                        alt={mainFeature.title}
                        className="w-full h-full object-cover"
                        width={800}
                        height={600}
                      />
                    )}
                  </div>
                </div>

                {/* Content Side */}
                <div className="w-full lg:w-1/2 space-y-4 md:space-y-6 lg:space-y-8">
                  <div>
                    <div className="inline-flex items-center gap-2 bg-[#253237] dark:bg-white text-white dark:text-black px-3 py-1.5 md:px-4 md:py-2 rounded-full text-xs md:text-sm font-semibold mb-3 md:mb-4">
                      <MainIcon className="w-4 h-4" />
                      {mainFeature.badge}
                    </div>
                    <h3 className="text-xl sm:text-2xl md:text-3xl lg:text-4xl font-bold text-[#253237] dark:text-white mb-3 md:mb-4">
                      {mainFeature.title}
                    </h3>
                    <p className="text-[#3D3D3D] dark:text-[#94A3B8] text-sm sm:text-base md:text-lg leading-relaxed">
                      {mainFeature.description}
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-2 sm:gap-3 md:gap-4">
                    {mainFeature.miniFeatures.map((feature, index) => (
                      <div key={index} className="flex items-start gap-2 md:gap-3">
                        <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                          <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                        </div>
                        <div>
                          <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">
                            {feature.title}
                          </p>
                          <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">
                            {feature.description}
                          </p>
                        </div>
                      </div>
                    ))}
                  </div>
                </div>
              </div>
            </div>

            {/* Feature Grid */}
            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-3 sm:gap-4 md:gap-6 max-w-7xl w-full mb-8 md:mb-12">
              {featureCards.map((feature, index) => {
                const FeatureIcon = feature.icon;
                return (
                  <div
                    key={index}
                    className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300"
                  >
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <FeatureIcon className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">
                        {feature.title}
                      </h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        {feature.description}
                      </p>
                    </div>
                  </div>
                );
              })}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default WhyProductSection;
