"use client";

import React from "react";
import { Shield, Lock, History, Award } from "lucide-react";

interface SecurityFeature {
  icon: React.ReactNode;
  title: string;
  description: string;
}

const SecuritySection: React.FC = () => {
  const securityFeatures: SecurityFeature[] = [
    {
      icon: <Lock className="w-6 h-6" />,
      title: "End-to-End Encryption",
      description: "Military-grade AES-256 encryption protects your data from device to destination.",
    },
    {
      icon: <Shield className="w-6 h-6" />,
      title: "Access Control",
      description: "Granular permissions let you control exactly who can view, edit, and share your files.",
    },
    {
      icon: <History className="w-6 h-6" />,
      title: "Auto Backup & Recovery",
      description: "Automatic backups with complete version history ensure your data is never lost.",
    },
    {
      icon: <Award className="w-6 h-6" />,
      title: "GDPR & SOC2 Compliant",
      description: "Certified and audited to meet the highest international data protection standards.",
    },
  ];

  return (
    <section className="w-full flex justify-center items-center bg-white dark:bg-[#0B0C0E]">
      <div className="relative my-24 mx-[1.2rem] md:mx-[50px] w-full max-w-[1233px]">
        {/* Glassmorphic Container */}
        <div className="bg-white/30 dark:bg-black/30 backdrop-blur-xl border border-gray-900/10 dark:border-white/10 rounded-3xl md:rounded-[40px] shadow-2xl transition-all duration-500 p-8 md:p-12 relative overflow-hidden">
          {/* Decorative background elements */}
          <div className="absolute top-0 right-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -mr-32 -mt-32 blur-3xl" />
          <div className="absolute bottom-0 left-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -ml-32 -mb-32 blur-3xl" />

          <div className="relative z-10">
            {/* Header */}
            <div className="text-center mb-12 md:mb-16">
              <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 mb-6">
                <Shield className="w-4 h-4 text-gray-900 dark:text-white" />
                <span className="text-xs md:text-sm font-semibold text-gray-900 dark:text-white tracking-wider uppercase">
                  Enterprise-Grade Security
                </span>
              </div>
              
              <h2 className="text-[32px] md:text-[48px] lg:text-[55px] font-bold text-gray-900 dark:text-white mb-4 leading-tight">
                Your Data.<br className="hidden md:block" />
                <span className="md:inline"> </span>Always Secure.
              </h2>
              
              <p className="text-base md:text-lg text-gray-700 dark:text-gray-300 max-w-3xl mx-auto leading-relaxed">
                Built with security at its core, our platform ensures your business data remains protected with industry-leading encryption and compliance standards.
              </p>
            </div>

            {/* Security Content Grid: Image + Features */}
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 md:gap-12 mb-12">
              {/* Left: Security Image */}
              <div className="relative rounded-2xl overflow-hidden min-h-[400px]">
                <img 
                  src="https://img.freepik.com/free-photo/online-security-dark-background-3d-illustration_1419-2804.jpg?semt=ais_hybrid&w=740&q=80"
                  alt="Enterprise Security Illustration"
                  className="absolute inset-0 w-full h-full object-cover object-right"
                />
                <div className="absolute inset-0 bg-gradient-to-br from-gray-900/20 to-gray-900/40 dark:from-black/30 dark:to-black/50" />
              </div>

              {/* Right: Security Features - Compact Cards */}
              <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                {securityFeatures.map((feature, index) => (
                  <div
                    key={index}
                    className="group relative bg-white/50 dark:bg-black/20 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 rounded-xl p-4 hover:bg-white/70 dark:hover:bg-black/30 transition-all duration-300 hover:shadow-lg"
                  >
                    <div className="flex flex-col items-center text-center gap-3">
                      {/* Icon */}
                      <div className="flex items-center justify-center w-12 h-12 rounded-lg bg-gray-900 dark:bg-white text-white dark:text-gray-900 group-hover:scale-110 transition-transform duration-300">
                        {feature.icon}
                      </div>

                      <div className="flex-1">
                        {/* Title */}
                        <h3 className="text-sm md:text-base font-bold text-gray-900 dark:text-white mb-2">
                          {feature.title}
                        </h3>

                        {/* Description */}
                        <p className="text-xs text-gray-700 dark:text-gray-300 leading-relaxed">
                          {feature.description}
                        </p>
                      </div>
                    </div>
                  </div>
                ))}
              </div>
            </div>

            {/* Trust Badge Row */}
            <div className="pt-8 md:pt-12 border-t border-gray-900/10 dark:border-white/10">
              <div className="flex flex-wrap items-center justify-center gap-8 md:gap-12">
                <div className="flex items-center gap-3">
                  <div className="flex items-center justify-center w-12 h-12 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm">
                    <Award className="w-6 h-6 text-gray-900 dark:text-white" />
                  </div>
                  <div className="text-left">
                    <div className="text-sm font-bold text-gray-900 dark:text-white">SOC 2 Type II</div>
                    <div className="text-xs text-gray-700 dark:text-gray-400">Certified</div>
                  </div>
                </div>

                <div className="flex items-center gap-3">
                  <div className="flex items-center justify-center w-12 h-12 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm">
                    <Shield className="w-6 h-6 text-gray-900 dark:text-white" />
                  </div>
                  <div className="text-left">
                    <div className="text-sm font-bold text-gray-900 dark:text-white">GDPR</div>
                    <div className="text-xs text-gray-700 dark:text-gray-400">Compliant</div>
                  </div>
                </div>

                <div className="flex items-center gap-3">
                  <div className="flex items-center justify-center w-12 h-12 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm">
                    <Lock className="w-6 h-6 text-gray-900 dark:text-white" />
                  </div>
                  <div className="text-left">
                    <div className="text-sm font-bold text-gray-900 dark:text-white">AES-256</div>
                    <div className="text-xs text-gray-700 dark:text-gray-400">Encryption</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default SecuritySection;
