"use client";

import React from "react";
import Image, { StaticImageData } from "next/image";

interface PreFooterCTAProps {
  badge?: string;
  mobileHeadline: string;
  desktopHeadline: string;
  description: string;
  buttonText: string;
  buttonUrl: string;
  userImages?: (string | StaticImageData)[];
  userCount?: string;
  rating?: string;
  theme?: string;
}

const PreFooterCTA: React.FC<PreFooterCTAProps> = ({
  badge,
  mobileHeadline,
  desktopHeadline,
  description,
  buttonText,
  buttonUrl,
  userImages,
  userCount,
  rating,
  theme,
}) => {
  return (
    <section className="w-full flex justify-center items-center bg-transparent">
      <div className="relative my-24 mx-[1.2rem] md:mx-[50px] w-full max-w-[1233px]">
        {/* Glassmorphic Container */}
        <div className="bg-white/30 dark:bg-black/30 backdrop-blur-xl border border-gray-900/10 dark:border-white/10 rounded-3xl md:rounded-[40px] shadow-2xl transition-all duration-500 p-8 md:p-12 relative overflow-hidden">
          {/* Decorative background elements */}
          <div className="absolute top-0 right-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -mr-32 -mt-32 blur-3xl" />
          <div className="absolute bottom-0 left-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -ml-32 -mb-32 blur-3xl" />

          <div className="flex flex-col items-center justify-center h-full relative z-10">
            <div className="w-full text-center flex flex-col items-center gap-6 max-w-3xl mx-auto">
              {/* Heading */}
              <div>
                {/* Desktop badge */}
                {badge && (
                  <div className="hidden md:inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 mb-6">
                    <span className="text-xs md:text-sm font-semibold text-gray-900 dark:text-white tracking-wider uppercase">
                      {badge}
                    </span>
                  </div>
                )}

                {/* Mobile simplified headline */}
                <h2 className="md:hidden !text-[28px] font-bold text-gray-900 dark:text-white mb-3 leading-tight">
                  {mobileHeadline}
                </h2>

                {/* Desktop full headline */}
                <h2
                  className="hidden md:block !text-[40px] lg:!text-[55px] font-bold text-gray-900 dark:text-white mb-4 leading-tight"
                  dangerouslySetInnerHTML={{ __html: desktopHeadline }}
                />
              </div>

              {/* Description */}
              <p
                className="text-base md:text-lg text-gray-700 dark:text-gray-300 max-w-2xl leading-relaxed"
                dangerouslySetInnerHTML={{ __html: description }}
              />

              {/* CTA Button */}
              <div className="flex flex-col sm:flex-row items-center gap-4 mt-4 w-full sm:w-auto">
                <button
                  onClick={() => {
                    window.location.replace(buttonUrl);
                  }}
                  className="group relative px-8 md:px-10 py-4 md:py-5 bg-gray-900 dark:bg-white text-white dark:text-black rounded-2xl font-semibold text-base md:text-lg transition-all duration-300 hover:scale-105 hover:shadow-2xl w-full sm:w-auto overflow-hidden"
                >
                  <span className="relative z-10 flex items-center justify-center gap-2">
                    {buttonText}
                    <svg
                      className="w-5 h-5 group-hover:translate-x-1 transition-transform"
                      fill="none"
                      stroke="currentColor"
                      viewBox="0 0 24 24"
                    >
                      <path
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth={2}
                        d="M17 8l4 4m0 0l-4 4m4-4H3"
                      />
                    </svg>
                  </span>
                  <div className="absolute inset-0 bg-gradient-to-r from-gray-800 to-gray-900 dark:from-gray-100 dark:to-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                </button>
              </div>

              {/* Social Proof */}
              {(userImages || rating) && (
                <div className="mt-6 md:mt-8 pt-6 md:pt-8 border-t border-gray-900/10 dark:border-white/10 w-full">
                  <div className="flex flex-col sm:flex-row items-center justify-center gap-4 md:gap-8">
                    {userImages && userCount && (
                      <div className="flex items-center gap-2">
                        <div className="flex -space-x-2">
                          {userImages.map((img, i) => (
                            <Image
                              key={i}
                              src={img}
                              alt="User"
                              className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover"
                              width={32}
                              height={32}
                            />
                          ))}
                        </div>
                        <span className="text-xs font-semibold text-gray-900 dark:text-white">
                          {userCount}
                        </span>
                      </div>
                    )}
                    {rating && (
                      <div className="flex items-center gap-1">
                        {[...Array(5)].map((_, i) => (
                          <svg
                            key={i}
                            className="w-4 h-4 text-gray-900 dark:text-white"
                            fill="currentColor"
                            viewBox="0 0 20 20"
                          >
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                          </svg>
                        ))}
                        <span className="text-xs font-semibold text-gray-900 dark:text-white ml-1">
                          {rating}
                        </span>
                      </div>
                    )}
                  </div>
                </div>
              )}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default PreFooterCTA;
