import { footerColumns } from "@/constants/footerText";
import Image from "next/image";
import Link from "next/link";
import React from "react";
import { FaArrowRight } from "react-icons/fa";
import { useTheme } from "../atoms/theme";
import ClikkleLogo from "./ClikkleLogo";

type FooterType = {
  footerText?: string;
  isWorksuite?: boolean;
  darkLogo?: string;
  lightLogo?: string;
  footerName?: string;
  isClikkle?: boolean;
};

function Footer({
  footerText = "Streamline your Business with our Apps. Effortlessly for every team.",
  isWorksuite = true,
  isClikkle = true,
  darkLogo = "https://cdn.clikkle.com/images/clikkle/logo/2025/Clikkle%20Blue%20(%20White%20Text).png",
  lightLogo = "https://cdn.clikkle.com/images/clikkle/logo/2025/Clikkle%20Blue%20(%20Black%20Text).png",
  footerName = "Technology",
}: FooterType) {
  const { theme } = useTheme();
  const isDarkMode = theme === "dark";

  return (
    <>
      <footer className="w-full">
        <footer className="w-full bg-white dark:bg-transparent border-t border-gray-200 dark:border-[#26282E] pt-6 md:pt-16">
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-4">
            <div className="flex flex-col md:flex-row justify-between gap-12">
              <div className="space-y-12">
                <ClikkleLogo />

                <div className="max-w-[285px] space-y-1 md:space-y-2 mt-[48px] ">
                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] tracking-[0em] font-headline-small text-gray-900 dark:text-[#eeeef0]">
                    Get Started For Free
                  </h3>
                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)]">
                    {footerText}
                  </p>
                </div>
              </div>

              <div className="flex flex-nowrap justify-between gap-y-8 space-x-2 min-[340px]:space-x-5 md:space-x-14 mt-4 text-[10px] min-[360px]:text-xs sm:text-sm overflow-hidden">
                {footerColumns.map((column, index) => (
                  <div key={`column-${index}`} className="flex flex-col gap-5">
                    <h4 className="font-label-medium text-gray-900 dark:text-white text-[length:var(--label-medium-font-size)] tracking-[var(--label-medium-letter-spacing)] leading-[var(--label-medium-line-height)]">
                      {column.title}
                    </h4>
                    <ul className="flex flex-col gap-4">
                      {column.links.map((link, linkIndex) => (
                        <li key={`link-${index}-${linkIndex}`}>
                          <div className="flex items-start gap-3">
                            <Link
                              href={link.url}
                              target={
                                link.url.startsWith("http") ? "_blank" : "_self"
                              }
                              rel={
                                link.url.startsWith("http")
                                  ? "noopener noreferrer"
                                  : undefined
                              }
                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap hover:text-gray-900 dark:hover:text-white transition-colors"
                            >
                              <span className="flex justify-center items-center gap-2">
                                {link.text}{" "}
                                {column.title === "Social" && (
                                  <FaArrowRight className="w-2 h-2 text-[#51515E] dark:text-[#d7d7de]" />
                                )}
                              </span>
                            </Link>
                            {link.isNew && (
                              <div className="hidden md:flex items-center gap-2 ">
                                <div className="relative w-4 h-4">
                                  <div className="relative w-[13px] h-[13px] top-px left-px bg-gray-500 rounded-[6.67px]">
                                    <div className="relative w-1 h-1 top-[5px] left-[5px] bg-white rounded-sm" />
                                  </div>
                                </div>
                                <span className="font-body-medium text-gray-900 dark:text-white text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap">
                                  New
                                </span>
                              </div>
                            )}
                          </div>
                        </li>
                      ))}
                    </ul>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </footer>

        <div className="w-full h-10 bg-gray-100 dark:bg-[#16171B] mt-12 flex items-center justify-center">
          <p className="font-body-small text-gray-900 dark:text-white text-[length:var(--body-small-font-size)] tracking-[var(--body-small-letter-spacing)] leading-[var(--body-small-line-height)]">
            ©{new Date().getFullYear()} Wurknest All Rights Reserved.
          </p>
        </div>
      </footer>
    </>
  );
}

export default Footer;
