"use client";
import { Cookie } from "lucide-react";
import React from "react";
import Link from "next/link";
import { setCookie } from "@/utils/cookies";

interface CookiesBarProps {
  setAcceptedCookies: React.Dispatch<React.SetStateAction<boolean>>;
}

const CookiesBar: React.FC<CookiesBarProps> = ({ setAcceptedCookies }) => {
  const handleAcceptedCookies = () => {
    setAcceptedCookies(true);
    // Set cookie for 1 year (365 days * 24 hours)
    setCookie("accepted-cookies", "true", 365 * 24);
  };

  return (
    <div
      className="
        fixed bottom-6 
        left-1/2 -translate-x-1/2   
        sm:left-6 sm:translate-x-0  
        w-[95%] sm:max-w-md
        rounded-xl
        bg-white dark:bg-[#111111] 
        border border-gray-200 dark:border-[#ffffff1a]
        p-4 sm:p-5
        z-[1000]
        font-inter"
      style={{
        boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
      }}
    >
      <div className="flex items-start gap-3">
        <div className="flex-shrink-0 mt-0.5">
          <Cookie 
            className="w-5 h-5 text-[#253237] dark:text-white" 
            strokeWidth={2}
          />
        </div>
        <div className="flex-1 space-y-3">
          <div className="space-y-1">
            <h3 className="text-sm font-semibold text-[#253237] dark:text-white">
              We use cookies
            </h3>
            <p className="text-sm text-[#51515E] dark:text-[#eeeef0] leading-relaxed">
              We use cookies to personalise and enhance your experience.
            </p>
          </div>
          <div className="flex flex-col sm:flex-row gap-2 sm:gap-3">
            <button
              onClick={handleAcceptedCookies}
              className="
                px-4 py-2 
                bg-[#253237] hover:bg-[#1a2428] 
                dark:bg-white dark:hover:bg-gray-100
                text-white dark:text-[#253237]
                text-sm font-medium 
                rounded-lg 
                transition-colors duration-200
                focus:outline-none focus:ring-2 focus:ring-[#253237] focus:ring-offset-2
                dark:focus:ring-white dark:focus:ring-offset-[#1a1925]"
              style={{
                boxShadow: `
                  0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
                  0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
                  0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
                  0px 2px 4px -1px rgba(0,0,0,0.12)
                `,
              }}
            >
              Accept Cookies
            </button>
            <Link
              href="/privacy-policy"
              className="
                px-4 py-2 
                text-sm font-medium 
                text-[#51515E] dark:text-[#eeeef0]
                hover:text-[#253237] dark:hover:text-white
                transition-colors duration-200
                text-center
                focus:outline-none focus:ring-2 focus:ring-[#253237] focus:ring-offset-2
                dark:focus:ring-white dark:focus:ring-offset-[#1a1925]
                rounded-lg"
            >
              Learn More
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
};

export default CookiesBar;
