"use client";
import Image from "next/image";
import Link from "next/link";
import { useTheme } from "../atoms/theme";

function ClikkleLogo() {
  return (
    <div className="flex items-center gap-0">
      <Link href="/">
        <div className="flex items-center gap-3">
          <div className="flex items-center h-[40px] md:h-[50px] overflow-hidden">
            <img 
              src='/images/wurknest/black-logo.png'
              alt="Wurknest Logo" 
              className="h-full w-auto object-cover object-center block dark:hidden"
              style={{ objectPosition: 'center 33%' }}
            />
            <img 
              src='/images/wurknest/white-logo.png'
              alt="Wurknest Logo" 
              className="h-full w-auto object-cover object-center hidden dark:block"
              style={{ objectPosition: 'center 33%' }}
            />
          </div>
          <p className="flex items-center text-gray-900 dark:text-white border-l-[1px] border-gray-300 dark:border-[ffffff3a] pl-[10px] text-[9px] md:text-[10px] font-[450] leading-3">
            The smarter <br /> way to work.
          </p>
        </div>
      </Link>
    </div>
  );
}

export default ClikkleLogo;

