"use client";
import { useEffect } from "react";

export default function ClikkleChat() {
  useEffect(() => {
    // Prevent duplicate script injection
    if (document.getElementById("clikkle-chat-script")) {
      return;
    }

    // Add custom CSS for chat button styling
    const styleId = "chat-button-custom-style";
    if (!document.getElementById(styleId)) {
      const style = document.createElement("style");
      style.id = styleId;
      style.textContent = `
        /* Target the MUI Fab button - the actual chat button */
        #my-chat-widget-container .MuiFab-root,
        #my-chat-widget-container button[aria-label="Open chat"] {
          background-color: #253237 !important;
          border-radius: 50% !important;
          box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15) !important;
          border: 2px solid rgba(255, 255, 255, 0.2) !important;
          width: 60px !important;
          height: 60px !important;
        }
        
        #my-chat-widget-container .MuiFab-root:hover,
        #my-chat-widget-container button[aria-label="Open chat"]:hover {
          background-color: #1a2529 !important;
          box-shadow: 0 6px 16px rgba(0, 0, 0, 0.2) !important;
          border: 2px solid rgba(255, 255, 255, 0.3) !important;
        }
        
        /* Target the MUI Avatar that wraps the icon */
        #my-chat-widget-container .MuiAvatar-root {
          background-color: transparent !important;
        }
        
        /* Ensure the SVG icon inside is visible */
        #my-chat-widget-container .MuiAvatar-img,
        #my-chat-widget-container img[alt="Chat Logo"] {
          max-width: 28px !important;
          max-height: 28px !important;
          filter: none !important;
        }
      `;
      document.head.appendChild(style);
    }

    // 1. Set configuration
    window.$mychat = window.$mychat || {};
    window.$mychat.config = {
      organizationId: "68759a3aafaea16453c5de48",
      widgetId: "660150a45e31ef6b174750e8",
      socketUrl: "https://chat.clikkle.com:9100",
      apiUrl: "https://chat.clikkle.com:9100",
      name: "Wurknest Support",
      position: "bottom-right",
      greetingMessage: "Hello! How can we help you?",
      headerColor: "#007bff",
      userMessageColor: "#007bff",
      userMessageTextColor: "#000000",
      agentMessageColor: "#eee",
      agentMessageTextColor: "#222",
      widgetBackgroundColor: "#fff",
      fontFamily: "sans-serif",
      requirePreChatForm: false,
      isOffline: false,
      autoRespondOffline: true,
      offlineAutoResponseMessage: "Thanks for your message! We'll get back to you soon.",
      chatIconUrl: "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none' stroke='white' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z'%3E%3C/path%3E%3C/svg%3E",
      startConversationButtonText: "Start a Conversation",
      organizationLogo: "https://cdn.wurknest.com/images/worknest%20app%20icon%20Transprant-01.png"
    };

    // 2. Load script
    const script = document.createElement("script");
    script.id = "clikkle-chat-script";
    script.src = "https://chat.clikkle.com/chat-widget.iife.js";
    script.async = true; // Use async to not block main thread, config is already set

    script.onload = () => {
      console.log("Wurknest Chat: Widget script loaded.");
    };

    script.onerror = (e) => {
      console.error("Wurknest Chat: Widget script failed to load.", e);
    };

    document.body.appendChild(script);

    // Cleanup not strictly necessary for singleton widget, but good practice if it were removable
    return () => {
      // document.body.removeChild(script); 
    };
  }, []);

  return null;
}
