"use client";
import React, { useEffect, useState } from "react";
import { useTheme } from "../atoms/theme";
import SidebarDrawer from "../components/sidebarDrawer";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import Footer from "@/components/Footer";
import MainHeader from "@/components/MainHeader";

const TermOfService: React.FC = () => {
  const { theme } = useTheme();

  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);

  return (
    <>
      <div className="min-h-screen bg-white dark:bg-[#0A0A0A]">
        {/* Fixed Header */}
        <section className="w-full">
          <section className="relative w-full h-28 overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 transition-all duration-300 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#0A0A0A]/90 border-b border-gray-200 dark:border-[#1F1F1F]"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;
                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader />
            </div>
          </section>
        </section>

        {/* Hero Section */}
        <section
          className={`w-full ${
            announcementOpen ? "pt-[10rem]" : "pt-24"
          } pb-16 px-4 sm:px-6 lg:px-8`}
        >
          <div className="max-w-5xl mx-auto">
            {/* Badge */}
            <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-gray-100 dark:bg-[#1F1F1F] border border-gray-200 dark:border-[#2A2A2A] mb-6">
              <span className="text-xs font-semibold text-gray-700 dark:text-gray-300 tracking-wider uppercase">
                Legal
              </span>
            </div>

            {/* Main Title */}
            <h1 className="font-eina text-5xl sm:text-6xl lg:text-7xl font-bold text-gray-900 dark:text-white mb-6 leading-tight">
              Terms of Service
            </h1>

            {/* Subtitle */}
            <p className="text-lg sm:text-xl text-gray-600 dark:text-gray-400 max-w-3xl leading-relaxed">
              By creating an account, you agree to our Terms of Service.
            </p>

            {/* Divider */}
            <div className="mt-12 h-px bg-gradient-to-r from-transparent via-gray-300 dark:via-gray-700 to-transparent"></div>
          </div>
        </section>

        {/* Content Section */}
        <section className="w-full pb-24 px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto">
            {/* Introduction */}
            <div className="space-y-6 mb-16">
              <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                These terms and conditions (&quot;Terms&quot;,
                &quot;Agreement&quot;) are an agreement between Wurknest Inc., a
                Canadian company (&quot;Wurknest&quot;, &quot;us&quot;,
                &quot;we&quot; or &quot;our&quot;) and you (&quot;User&quot;,
                &quot;you&quot; or &quot;your&quot;). This Agreement sets forth
                the general terms and conditions of your use of the Wurknest
                website, web app, desktop app, mobile apps, browser extensions,
                and any of its products or services (collectively, &quot;App&quot;
                or &quot;Services&quot;), including Wurknest eSign, Wurknest
                Projects, Wurknest HR, Wurknest Chat, and Wurknest Campaigns.
              </p>
              <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                When you sign up for an account and agree to these Terms, the
                Agreement between you and Wurknest is formed, and the term of the
                Agreement (the &quot;Term&quot;) will begin. The Term will continue for as
                long as you have a Wurknest account or until you or we terminate
                the Agreement in accordance with these Terms, whichever happens
                first. If you sign up for an account on behalf of a company or
                other entity, you represent and warrant that you have the
                authority to accept these Terms and enter into the Agreement on
                its behalf.
              </p>
            </div>

            {/* Terms Sections */}
            <div className="space-y-16">
              {/* Section 1 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Accounts and Membership
                </h2>
                <div className="space-y-4">
                  <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                    You must be at least 18 years of age to use this App. By using
                    this App and by agreeing to this Agreement you warrant and
                    represent that you are at least 18 years of age. If you create
                    an account in the App, you are responsible for maintaining the
                    security of your account and you are fully responsible for all
                    activities that occur under the account and any other actions
                    taken in connection with it. We may, but have no obligation to,
                    monitor and review new accounts before you may sign in and use
                    our Services. Providing false contact information of any kind
                    may result in the termination of your account. You must
                    immediately notify us of any unauthorized uses of your account
                    or any other breaches of security.
                  </p>
                  <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                    We will not be liable for any acts or omissions by you,
                    including any damages of any kind incurred as a result of such
                    acts or omissions. We may suspend, disable, or delete your
                    account (or any part thereof) if we determine that you have
                    violated any provision of this Agreement or that your conduct or
                    content would tend to damage our reputation and goodwill or you
                    were rude or abusive to any of our team members. If we delete
                    your account for the foregoing reasons, you may not re-register
                    for our Services.
                  </p>
                </div>
              </div>

              {/* Section 2 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Terminating your account
                </h2>
                <div className="space-y-4">
                  <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                    You or Wurknest may terminate the Agreement at any time and for
                    any reason by terminating your Wurknest account or giving notice
                    to the other party. We may suspend the Service to you at any
                    time, with or without cause. If we terminate your account
                    without cause, and your account is a paid account, we&apos;ll refund
                    a prorated portion of any prepaid amounts for the Service.
                  </p>
                  <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                    We won&apos;t refund or reimburse you in any other situation,
                    including if your account is suspended or terminated for cause,
                    such as for a breach or violation of the Agreement.
                  </p>
                </div>
              </div>

              {/* Section 3 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Terminating inactive accounts
                </h2>
                <div className="space-y-4">
                  <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                    If your account is inactive for 12 months (roughly 365 days) or
                    more, we may terminate your account and you won&apos;t be entitled to
                    a refund for any prepaid amounts or reimbursement for unused
                    credit. Once your account is terminated, you acknowledge and
                    agree that we may permanently delete your account and all the
                    data associated with it, including your workspaces.
                  </p>
                  <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                    We&apos;re deleting accounts that are no longer active and deleting
                    the user data for those accounts in order to ensure compliance
                    with current and future data protection and privacy regulations.
                    Deleting old data is a best practice that helps us protect user
                    data and our systems. We notify affected account holders by
                    sending notice(s) to the email addresses associated with the
                    account&apos;s primary contact and owner profile.
                  </p>
                </div>
              </div>

              {/* Section 4 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  User content
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  We do not own any data, information or material
                  (&quot;Content&quot;) that you submit in the App in the course
                  of using the Service. You shall have sole responsibility for the
                  accuracy, quality, integrity, legality, reliability,
                  appropriateness, and intellectual property ownership or right to
                  use of all submitted Content. We may, but have no obligation to,
                  monitor and review Content in the App submitted or created using
                  our Services by you. Unless specifically permitted by you, your
                  use of the App does not grant us the license to use, reproduce,
                  adapt, modify, publish or distribute the Content created by you
                  or stored in your user account for commercial, marketing or any
                  similar purpose. But you grant us permission to access, copy,
                  distribute, store, transmit, reformat, display and perform the
                  Content of your user account solely as required for the purpose
                  of providing the Services to you. Without limiting any of those
                  representations or warranties, we have the right, though not the
                  obligation, to, in our own sole discretion, refuse or remove any
                  Content that, in our reasonable opinion, violates any of our
                  policies or is in any way harmful or objectionable.
                </p>
              </div>

              {/* Section 5 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Billing and payments
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  You shall pay all fees or charges to your account in accordance
                  with the fees, charges, and billing terms in effect at the time
                  a fee or charge is due and payable. Where Services are offered
                  on a free trial basis, payment may be required after the free
                  trial period ends, and not when you enter your billing details
                  (which may be required prior to the commencement of the free
                  trial period). If auto-renewal is enabled for the Services you
                  have subscribed for, you will be charged automatically in
                  accordance with the term you selected. If, in our judgment, your
                  purchase constitutes a high-risk transaction, we will require
                  you to provide us with a copy of your valid government-issued
                  photo identification, and possibly a copy of a recent bank
                  statement for the credit or debit card used for the purchase. We
                  reserve the right to change products and product pricing at any
                  time.
                </p>
              </div>

              {/* Section 6 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Charges for add-ons
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  If you use an add-on that has a charge, then you&apos;ll be billed
                  that additional amount with each billing cycle for as long as
                  the add-on is active. The billing cycle for an add-on differ
                  from the billing cycle of your base plan or other features of
                  the Service, and certain add-ons may require upfront payment for
                  their entire billing cycle.
                </p>
              </div>

              {/* Section 7 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Refunds
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  You won&apos;t be entitled to a refund or credit from us under any
                  other circumstances. We may, at our sole discretion, offer a
                  refund, discount or credit.
                </p>
              </div>

              {/* Section 8 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Billing changes
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  We may change any of our pricing plans and fees at any time by
                  posting a new pricing structure to our website or in your
                  account and/or sending you a notification by email.
                </p>
              </div>

              {/* Section 9 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Accuracy of information
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  Occasionally there may be information in the App that contains
                  typographical errors, inaccuracies or omissions that may relate
                  to promotions and offers. We reserve the right to correct any
                  errors, inaccuracies or omissions, and to change or update
                  information or cancel orders if any information in the App or on
                  any related Service is inaccurate at any time without prior
                  notice (including after you have submitted your order). We
                  undertake no obligation to update, amend or clarify information
                  in the App including, without limitation, pricing information,
                  except as required by law. No specified update or refresh date
                  applied in the App should be taken to indicate that all
                  information in the App or on any related Service has been
                  modified or updated.
                </p>
              </div>

              {/* Section 10 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Uptime guarantee
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  We offer a Service uptime guarantee of 99% of available time per
                  month. The service uptime guarantee does not apply to service
                  interruptions caused by: (1) periodic scheduled maintenance or
                  repairs we may undertake from time to time; (2) interruptions
                  caused by you or your activities; (3) outages that do not affect
                  core Service functionality; (4) causes beyond our control or
                  that are not reasonably foreseeable; and (5) outages related to
                  the reliability of certain programming environments.
                </p>
              </div>

              {/* Section 11 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Backups
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  We perform regular backups of the Content and will do our best
                  to ensure completeness and accuracy of these backups. In the
                  event of the hardware failure or data loss we will restore
                  backups automatically to minimize the impact and downtime.
                </p>
              </div>

              {/* Section 12 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Links to other websites
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  Although this App may link to other websites, we are not,
                  directly or indirectly, implying any approval, association,
                  sponsorship, endorsement, or affiliation with any linked
                  website, web app or mobile apps, unless specifically stated
                  herein. Some of the links in the App may be &quot;affiliate
                  links&quot;. This means if you click on the link and purchase an
                  item, Wurknest Inc. will receive an affiliate commission. We are
                  not responsible for examining or evaluating, and we do not
                  warrant the offerings of, any businesses or individuals or the
                  content of their websites. We do not assume any responsibility
                  or liability for the actions, products, services, and content of
                  any other third-parties. You should carefully review the legal
                  statements and other conditions of use of any website, web app
                  or mobile apps which you access through a link from this App.
                  Your linking to any other off-site websites is at your own risk.
                </p>
              </div>

              {/* Section 13 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Limitation of liability
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  To the fullest extent permitted by applicable law, in no event
                  will Wurknest Inc., its affiliates, officers, directors,
                  employees, agents, suppliers or licensors be liable to any
                  person for (a): any indirect, incidental, special, punitive,
                  cover or consequential damages (including, without limitation,
                  damages for lost profits, revenue, sales, goodwill, use of
                  content, impact on business, business interruption, loss of
                  anticipated savings, loss of business opportunity) however
                  caused, under any theory of liability, including, without
                  limitation, contract, tort, warranty, breach of statutory duty,
                  negligence or otherwise, even if Wurknest Inc. has been advised
                  as to the possibility of such damages or could have foreseen
                  such damages. To the maximum extent permitted by applicable law,
                  the aggregate liability of Wurknest Inc. and its affiliates,
                  officers, employees, agents, suppliers and licensors, relating
                  to the services will be limited to an amount greater of one
                  Canadian dollar or any amounts actually paid in cash by you to
                  Wurknest Inc. for the prior one month period prior to the first
                  event or occurrence giving rise to such liability. The
                  limitations and exclusions also apply if this remedy does not
                  fully compensate you for any losses or fails of its essential
                  purpose.
                </p>
              </div>

              {/* Section 14 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Changes and amendments
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  We reserve the right to modify this Agreement or its policies
                  relating to the App or Services at any time, effective upon
                  posting of an updated version of this Agreement in the App. When
                  we do, we will revise the updated date at the bottom of this
                  page. Continued use of the App after any such changes shall
                  constitute your consent to such changes.
                </p>
              </div>

              {/* Section 15 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Beta services
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  From time to time, we may invite you to try products or features
                  related to our Service that are not generally available to all
                  of our Members or the public or we may release products or
                  features related to our Service that are identified in the App
                  as beta, preview, pilot, limited release, or by a similar
                  designation (collectively, &quot;Beta&quot;). Beta may be provided for
                  evaluation or testing purposes only, and, therefore, may contain
                  bugs or errors, and may not be as reliable as other features of
                  the Service. We may discontinue Beta services at any time in our
                  sole discretion, and we may decide not to make Beta services
                  generally available. For the avoidance of doubt, Beta services
                  are a part of the Service, and, therefore, are subject to the
                  terms of this Agreement.
                </p>
              </div>

              {/* Section 16 */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Acceptance of these terms
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  You acknowledge that you have read this Agreement and agree to
                  all its terms and conditions. By using the App or its Services
                  you agree to be bound by this Agreement. If you do not agree to
                  abide by the terms of this Agreement, you are not authorized to
                  use or access the App and its Services.
                </p>
              </div>

              {/* Section 17 - Contact */}
              <div className="group">
                <h2 className="font-eina text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-6 pb-4 border-b border-gray-200 dark:border-[#2A2A2A]">
                  Contacting us
                </h2>
                <p className="text-base sm:text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
                  If you would like to contact us to understand more about this
                  Agreement or wish to contact us concerning any matter relating
                  to it, you may send an email to{" "}
                  <a
                    href="mailto:legal@wurknest.com"
                    className="text-blue-600 dark:text-blue-400 hover:underline font-semibold transition-colors"
                  >
                    legal@wurknest.com
                  </a>
                </p>
              </div>
            </div>

            {/* Last Updated */}
            <div className="mt-16 pt-12 border-t border-gray-200 dark:border-[#2A2A2A]">
              <p className="text-sm text-gray-600 dark:text-gray-400 text-center">
                This document was last updated on September 11, 2025.
              </p>
            </div>
          </div>
        </section>
      

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
      </div>
    </>
  );
};

export default TermOfService;
