"use client";
import Link from "next/link";
import Image from "next/image";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import {
  AlertTriangleIcon,
  BarChart2Icon,
  Bell,
  BookTemplateIcon,
  BrainIcon,
  BugIcon,
  CalendarDays,
  Ellipsis,
  ClipboardCheckIcon,
  ClockIcon,
  DatabaseIcon,
  FileBarChartIcon,
  FileTextIcon,
  GlobeIcon,
  KanbanIcon,
  KeyIcon,
  LayersIcon,
  LayoutDashboardIcon,
  LayoutIcon,
  ProjectorIcon,
  SearchIcon,
  SendIcon,
  Settings2Icon,
  ShieldCheckIcon,
  SparklesIcon,
  TimerIcon,
  UserCogIcon,
  UserIcon,
  Users,
  Workflow,
  WorkflowIcon,
  ArrowDown,
} from "lucide-react";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import { BarChart3Icon, UsersIcon } from "lucide-react";
import custom1 from "../../public/images/new8.png";
import custom3 from "../../public/images/new4.png";
import custom4 from "../../public/images/new7.png";
import { useTheme } from "../atoms/theme";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/new5.png";
import SidebarDrawer from "../components/sidebarDrawer";
import { IoMdChatboxes } from "react-icons/io";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import testimonials1 from "../../public/images/testimonials1.jpeg";
import testimonials2 from "../../public/images/testimonials2.jpeg";
import testimonials3 from "../../public/images/testimonials3.jpeg";
import testimonials4 from "../../public/images/testimonials4.jpeg";
import testimonials5 from "../../public/images/testimonials5.jpeg";
import sect4 from "../../public/images/sect4.jpeg";
import someee from "../../public/images/someee.jpeg";
import sect3 from "../../public/images/sect3.jpeg";
import sect1 from "../../public/images/sect1.jpeg";

import projectslight from "../../public/images/projectslight.png";
import projectsdark from "../../public/images/projectsdark.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import rightArrow from "../../public/images/right-arrow.png";
import TabbedFeature from "../components/TabbedFeature";
import { MdHome, MdAssignment, MdAccountTree, MdWorkOutline, MdEdit } from "react-icons/md";
import HeroSection from "@/components/HeroSection";

import projDashboardDay from "../../public/images/projects/projects-dashboard-daymode.png";
import TaskCollaborationAnimationPanel from "@/components/TaskCollaborationAnimationPanel";
import BugTrackingAnimationPanel from "@/components/BugTrackingAnimationPanel";
import projDashboardDark from "../../public/images/projects/projects-dashboard-darkmode.png";
import projTileDay from "../../public/images/projects/projects app-projects tile view-daymode.png";
import projTileDark from "../../public/images/projects/projects app-projects tile view-darkmode.png";
import projKanbanDay from "../../public/images/projects/projects app-project board kanban view-daymode.png";
import projKanbanDark from "../../public/images/projects/projects app-project board kanban view-darkmode.png";
import projWorkDay from "../../public/images/projects/projects app-your work view-daymode.png";
import projWorkDark from "../../public/images/projects/projects app-your work view-darkmode.png";
import projEditDay from "../../public/images/projects/projects app-edit project view-daymode.png";
import projEditDark from "../../public/images/projects/projects app-edit project view-darkmode.png";
import { IoHeartCircle } from "react-icons/io5";
import MainHeader from "@/components/MainHeader";
import WhyProductSection from "@/components/WhyProductSection";
import FeatureSection from "@/components/FeatureSection";
import PricingSection from "@/components/PricingSection";
import { Target, Zap, Shield } from "lucide-react";
import Footer from "@/components/Footer";
import PreFooterCTA from "@/components/PreFooterCTA";
import SecuritySection from "@/components/SecuritySection";
import FAQSection from "@/components/FAQSection";

const ProjectsHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const tabFeatures = [
    {
      id: "dashboard",
      label: "Dashboard",
      icon: <MdHome className="w-4 h-4" />,
      lightImage: projDashboardDay,
      darkImage: projDashboardDark,
    },
    {
      id: "projects",
      label: "Projects",
      icon: <MdAssignment className="w-4 h-4" />,
      lightImage: projTileDay,
      darkImage: projTileDark,
    },
    {
      id: "project-board",
      label: "Project Board",
      icon: <MdAccountTree className="w-4 h-4" />,
      lightImage: projKanbanDay,
      darkImage: projKanbanDark,
    },
    {
      id: "your-work",
      label: "Your Work",
      icon: <MdWorkOutline className="w-4 h-4" />,
      lightImage: projWorkDay,
      darkImage: projWorkDark,
    },
    {
      id: "edit-project",
      label: "Edit Project",
      icon: <MdEdit className="w-4 h-4" />,
      lightImage: projEditDay,
      darkImage: projEditDark,
    },
  ];

  const features1 = [
    {
      icon: (
        <ClipboardCheckIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Task Management",
      description: "Organize, prioritize, and track work with AI.",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Collaboration",
      description: "Enable real-time teamwork and clear communication.",
    },
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "File Sharing",
      description: "Share and manage documents easily.",
    },
    {
      icon: (
        <SparklesIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "AI Assistance",
      description: "Get intelligent suggestions to boost productivity.",
    },
  ];
  const features2 = [
    {
      icon: (
        <LayoutDashboardIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Agile Boards",
      description: "AI-enabled boards and automated workflows.",
    },
    {
      icon: <BrainIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "AI-Driven Optimization",
      description: "Optimize teams with AI insights and recommendations.",
    },
    {
      icon: (
        <BarChart2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Progress Tracking",
      description: "Monitor project status with interactive Gantt charts.",
    },
    {
      icon: (
        <KanbanIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Kanban Boards",
      description: "Visual task organization with dynamic Kanban boards.",
    },
  ];

  const features3 = [
    {
      icon: <BugIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Bug Tracking",
      description: "Capture, prioritize, and track bugs to resolution.",
    },
    {
      icon: (
        <AlertTriangleIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Issue Management",
      description: "Manage issues and incidents with structured workflows.",
    },
    {
      icon: (
        <SearchIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Intelligent Search",
      description: "Find issues fast with AI-powered search.",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Automated Workflows",
      description: "Automate routing and fixes for faster resolution.",
    },
  ];

  const features4 = [
    {
      icon: (
        <Settings2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Customizable Workflows",
      description: "Customize workflows and automate routine tasks.",
    },
    {
      icon: (
        <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "AI-Driven Reports",
      description: "AI-generated analytics for data-driven decisions.",
    },
    {
      icon: <ClockIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Time Tracking",
      description: "Log and monitor time with AI-enabled tracking.",
    },
    {
      icon: (
        <FileBarChartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Data-Driven Insights",
      description: "Create reports to track productivity and performance.",
    },
  ];
  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "This platform has completely changed how we manage projects. The clean interface and smart features save us hours each week. Team productivity is up 40% since we started using it. I can’t imagine running projects without it now.",
      name: "Olivia Bennett",
      title: "CEO at VisionTrack Solutions",
      date: "Jul 5, 2025",
      logo: testimonials1,
      recommendNote: "Clikkle Projects is highly recommended",
    },
    {
      text: "We’ve cut project delivery times by 50% with Clikkle’s streamlined workflows. Task tracking and real-time updates keep everyone aligned, while mobile access lets us manage work anywhere. It’s become essential for our operations.",
      name: "Ethan Roberts",
      title: "COO at ApexFlow Inc.",
      date: "Jun 20, 2025",
      logo: testimonials2,
      recommendNote: "Highly recommended for agile teams",
    },
    {
      text: "Clikkle makes project coordination effortless. Our team spends less time chasing updates and more time delivering results. The platform’s reliability, simple design, and built-in reporting make it an invaluable asset.",
      name: "Maya Chen",
      title: "Head of Operations at NextWave Corp",
      date: "May 30, 2025",
      logo: testimonials3,
      recommendNote: "A game-changer for operations teams",
    },
    {
      text: "Thanks to Clikkle, onboarding new team members is smooth and quick. Automated task assignments and progress tracking ensure nothing is missed. Our team is more confident and efficient from day one.",
      name: "Lucas Grant",
      title: "HR Manager at GrowthEdge",
      date: "Apr 18, 2025",
      logo: testimonials4,
      recommendNote: "Perfect for scaling teams",
    },
    {
      text: "We’re completing projects twice as fast since adopting Clikkle. The intuitive UI, clear timelines, and progress tracking build trust in every client interaction. It’s transformed our delivery process entirely.",
      name: "Sofia Ramirez",
      title: "Project Director at BuildSphere",
      date: "Mar 8, 2025",
      logo: testimonials5,
      recommendNote: "Best tool for project delivery",
    },
  ];

  const [idx, setIdx] = useState(0);
  const { text, name, title, date, logo, recommendNote } = testimonials[idx];

  const prev = () =>
    setIdx((idx - 1 + testimonials.length) % testimonials.length);
  const next = () => setIdx((idx + 1) % testimonials.length);

  const [isAnnual, setIsAnnual] = useState(true);
  const monthlyPlans = [
    {
      name: "Standard",
      description: "Project Management\nPerfect For Individuals & Small Teams",
      price: "$7.99",
      pricePeriod: "per month",
      buttonText: "Start With Standard",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        {
          icon: LayoutIcon,
          text: "",
          subtext: "Private boards, views & spaces",
        },
        { icon: BarChart3Icon, text: "", subtext: "Gantt view" },
        { icon: FileTextIcon, text: "12", subtext: "Fields per board" },
        { icon: ShieldCheckIcon, text: "", subtext: "Viewer role" },
        { icon: LayersIcon, text: "", subtext: "Conditional coloring" },
        { icon: SendIcon, text: "", subtext: "Bulk actions" },
        { icon: UsersIcon, text: "", subtext: "Invite / team permissions" },
        { icon: DatabaseIcon, text: "5GB", subtext: "Storage" },
        { icon: ClockIcon, text: "6 mo", subtext: "Activity log" },
        { icon: BookTemplateIcon, text: "", subtext: "Board & task templates" },
      ],
      highlighted: false,
    },
    {
      name: "Team",
      description: "Privacy & Security\nBest For Growing Teams",
      price: "$10.99",
      pricePeriod: "per month",
      buttonText: "Start With Team",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: LayersIcon, text: "", subtext: "All features included" },
        { icon: LayoutIcon, text: "", subtext: "Board permissions" },
        { icon: UserCogIcon, text: "", subtext: "Board ownership management" },
        { icon: FileTextIcon, text: "Unlimited", subtext: "Fields per board" },
        { icon: DatabaseIcon, text: "250GB", subtext: "Storage" },
        { icon: ClockIcon, text: "Unlimited", subtext: "Activity log" },
        { icon: UserIcon, text: "", subtext: "Customized user profiles" },
        { icon: GlobeIcon, text: "", subtext: "Custom subdomain" },
        { icon: KeyIcon, text: "", subtext: "Custom SSO" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Platinum",
      description: "Productivity Suite\nAll-in-one for Teams",
      price: "$12.99",
      pricePeriod: "per month",
      buttonText: "Start With Platinum",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: LayersIcon, text: "", subtext: "All features included" },
        { icon: IoMdChatboxes, text: "", subtext: "Team communication" },
        { icon: TimerIcon, text: "", subtext: "Time tracking" },
        { icon: ProjectorIcon, text: "", subtext: "Project management" },
      ],
      highlighted: false,
    },
  ];

  const annualPlans = [
    {
      name: "Standard",
      description: "Project Management\nPerfect For Individuals & Small Teams",
      price: "$3.99",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Standard",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        {
          icon: LayoutIcon,
          text: "",
          subtext: "Private boards, views & spaces",
        },
        { icon: BarChart3Icon, text: "", subtext: "Gantt view" },
        { icon: FileTextIcon, text: "12", subtext: "Fields per board" },
        { icon: ShieldCheckIcon, text: "", subtext: "Viewer role" },
        { icon: LayersIcon, text: "", subtext: "Conditional coloring" },
        { icon: SendIcon, text: "", subtext: "Bulk actions" },
        { icon: UsersIcon, text: "", subtext: "Invite / team permissions" },
        { icon: DatabaseIcon, text: "5GB", subtext: "Storage" },
        { icon: ClockIcon, text: "6 mo", subtext: "Activity log" },
        { icon: BookTemplateIcon, text: "", subtext: "Board & task templates" },
      ],
      highlighted: false,
    },
    {
      name: "Team",
      description: "Privacy & Security\nBest For Growing Teams",
      price: "$5.99",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Team",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: LayersIcon, text: "", subtext: "All features included" },

        { icon: LayoutIcon, text: "", subtext: "Board permissions" },
        { icon: UserCogIcon, text: "", subtext: "Board ownership management" },
        { icon: FileTextIcon, text: "Unlimited", subtext: "Fields per board" },
        { icon: DatabaseIcon, text: "250GB", subtext: "Storage" },
        { icon: ClockIcon, text: "Unlimited", subtext: "Activity log" },
        { icon: UserIcon, text: "", subtext: "Customized user profiles" },
        { icon: GlobeIcon, text: "", subtext: "Custom subdomain" },
        { icon: KeyIcon, text: "", subtext: "Custom SSO" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Platinum",
      description: "Productivity Suite\nAll-in-one for Teams",
      price: "$6.49",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Platinum",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: LayersIcon, text: "", subtext: "All features included" },
        { icon: IoMdChatboxes, text: "", subtext: "Team communication" },
        { icon: TimerIcon, text: "", subtext: "Time tracking" },
        { icon: ProjectorIcon, text: "", subtext: "Project management" },
      ],
      highlighted: false,
    },
  ];

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);

  const faqs = [
    {
      question: "How do I get started?",
      answer: `Quick start: create a workspace, invite teammates, then create your first project or use a template (Kanban, Scrum, Gantt). Add tasks, assign owners, set due dates and priorities, and invite collaborators. You can import existing issues/tasks via CSV or from tools like Jira/GitHub. We provide an onboarding guide, short walkthrough videos, and in-app tips — plus chat/email support if you want hands-on help setting up workflows or templates.`,
    },
    {
      question: "What payment methods do you accept?",
      answer:
        "We accept major credit and debit cards (Visa, Mastercard, American Express) and PayPal for standard subscriptions. For teams and enterprise customers we support invoiced billing and bank transfers — contact sales to arrange invoicing, purchase orders, or custom payment terms. Annual plans also include discounted pricing.",
    },
    {
      question: "Can I change or cancel my plan anytime?",
      answer:
        "Yes — you can upgrade, add/remove seats, or cancel from the billing page at any time. Changes are applied immediately or prorated depending on the change and billing cycle. Enterprise agreements follow the terms of the contract; contact support for refunds, proration details, or to switch between monthly and annual billing.",
    },
    {
      question: "Is my data secure and backed up?",
      answer:
        "Security is a priority. Data is encrypted in transit (TLS) and at rest, we maintain regular backups, and access is controlled with role-based permissions. Audit logs record key actions (task changes, file uploads, sign-ins). We support SSO (SAML/SCIM) and can assist with enterprise compliance needs — contact us to discuss contracts or specific standards (GDPR, HIPAA, SOC2, etc.).",
    },
    {
      question: "Can I integrate with other tools?",
      answer:
        "Yes — we provide REST APIs and webhooks for automation and custom integrations. Out-of-the-box integrations include Slack/Microsoft Teams, GitHub/GitLab, Google Calendar/Drive, Dropbox, and Zapier. Need a custom connector or SSO setup? Our developer and sales teams can help design and implement it.",
    },
  ];

  const isDarkMode = theme === "dark";

  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://projects.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#0b0c0e] flex flex-col items-center w-full min-h-screen">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader/>
            </div>

            <HeroSection
              announcementOpen={announcementOpen}
              badge={{
                text: "Built by & for Freelancers",
                showPulse: true,
              }}
              title={{
                beforeHighlight: "Plan, track, and deliver",
                highlight: "projects on time",
                afterHighlight: "",
              }}
              description={{
                desktop: (
                  <>
                    Efficiently optimize workflows and enhance <span className="font-semibold text-gray-900 dark:text-white">collaborative team performance</span>. Everything you need to <span className="font-semibold text-gray-900 dark:text-white">manage projects</span> from start to finish.
                  </>
                ),
                mobile: (
                  <>
                    Optimize workflows with <span className="font-semibold text-gray-900 dark:text-white">collaborative tools</span> for project success.
                  </>
                ),
              }}
              cta={{
                primary: {
                  text: "Start Free →",
                  onClick: () => {
                    window.location.replace(
                      "https://projects.clikkle.com/signup?theme=" + theme
                    );
                  },
                },
                secondary: {
                  text: "View Features",
                  href: "#moreInfo",
                },
              }}
              trustIndicators={[
                { text: "Free forever" },
                { text: "15k+ users" },
                { text: "No credit card" },
              ]}
            />

            <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full md:w-auto">
              <TabbedFeature
                tabs={tabFeatures}
                decorator={
                  <Image
                    src={popImg}
                    alt="popImg"
                    className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px]"
                  />
                }
              />
            </div>
          </section>
        </section>

        <WhyProductSection
          badge="Why Clikkle Projects?"
          heading="Built for teams who ship fast"
          subheading="From planning to delivery, manage every aspect of your projects with powerful tools designed for modern teams."
          mainFeature={{
            badge: "Visual Project Management",
            icon: KanbanIcon,
            title: "Organize work your way with flexible boards",
            description: "Visualize your entire project pipeline with customizable Kanban boards. Drag and drop tasks between stages, assign team members, set priorities, and track progress in real-time. Perfect for agile teams and complex workflows.",
            image: theme === "dark" ? projKanbanDark : projKanbanDay,
            miniFeatures: [
              {
                title: "Custom Workflows",
                description: "Design boards that match your process"
              },
              {
                title: "Real-time Updates",
                description: "See changes instantly across your team"
              },
              {
                title: "Smart Automation",
                description: "Automate repetitive tasks and transitions"
              },
              {
                title: "Priority Management",
                description: "Keep critical work front and center"
              }
            ]
          }}
          featureCards={[
            {
              icon: CalendarDays,
              title: "Strategic Planning",
              description: "Set clear milestones, create visual timelines, and map out project roadmaps that keep everyone aligned on goals and deadlines."
            },
            {
              icon: Users,
              title: "Team Collaboration",
              description: "Centralize all project communication, share files instantly, and keep your entire team synchronized on progress and updates."
            },
            {
              icon: Target,
              title: "Goal Tracking",
              description: "Monitor project objectives, track key metrics, and ensure every task contributes to your overall business goals."
            },
            {
              icon: Zap,
              title: "Workflow Automation",
              description: "Eliminate manual work with smart automation for task assignments, status updates, notifications, and recurring workflows."
            }
          ]}
        />

        <section className="w-full">
        <section
          className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
          id="features3-3"
        >
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
              <FeatureSection
                title="Task Management & Collaboration"
                showIcon={true}
                description="Empower your team with intelligent task management, seamless collaboration, and effortless file sharing."
                features={features1}
                cta1={{
                  label: "Learn More",
                  onClick: () => {
                    document.getElementById('features2-2')?.scrollIntoView({ behavior: 'smooth' });
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                }}
                cta2={{
                  label: "Start Managing Tasks",
                  mobileLabel: "Get Started",
                  onClick: () => {
                    window.location.replace(
                      "https://projects.clikkle.com/signup?theme=" + theme
                    );
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                }}
                quote={{
                  text: "Task management is incredibly intuitive now, saving me hours weekly!",
                  userImg: sect1,
                  userName: "Sofia R.",
                  userRole: "Project Manager",
                }}
                theme={theme}
              />
              <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none gap-[8rem] justify-self-end">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <TaskCollaborationAnimationPanel />
              </div>
            </div>
          </div>
        </section>
      </section>

      <section className="w-full">
        <section
          className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
          id="features2-2"
        >
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
              {/* Left Column: Image/Animation Panel */}
              <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none justify-self-start">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <Image
                  src={theme === "dark" ? projDashboardDark : projDashboardDay}
                  alt="Project Dashboard - Planning and Management"
                  className="w-auto h-full relative md:h-[520px] max-h-[350px] rounded-xl shadow-2xl"
                  width={520}
                  height={520}
                />
              </div>

              {/* Right Column: Feature Text */}
              <FeatureSection
                title="Agile Project Planning & Management"
                showIcon={true}
                description="Accelerate delivery with AI-powered planning, interactive Gantt charts, and dynamic Kanban boards."
                features={features2}
                cta1={{
                  label: "Explore Features",
                  onClick: () => {
                    document.getElementById("features3-3")?.scrollIntoView({ behavior: "smooth" });
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                }}
                cta2={{
                  label: "Start Planning Projects",
                  mobileLabel: "Get Started",
                  onClick: () => {
                    window.location.replace(
                      "https://projects.clikkle.com/signup?theme=" + theme
                    );
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                }}
                quote={{
                  text: "Perfectly organized and effortless — exactly what my team needed!",
                  userImg: sect3,
                  userName: "Lily M.",
                  userRole: "Team Lead",
                }}
                theme={theme}
              />
            </div>
          </div>
        </section>
      </section>

        <section className="w-full">
        <section
          className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
          id="features3-3"
        >
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
              {/* Left Column: Feature Text */}
              <FeatureSection
                title="Track Issues & Squash Bugs Faster"
                showIcon={true}
                description="Identify and eliminate bugs swiftly with intelligent workflows and powerful search capabilities."
                features={features3}
                cta1={{
                  label: "Learn More",
                  onClick: () => {
                    window.location.href = "#features";
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                }}
                cta2={{
                  label: "Get Started Free",
                  mobileLabel: "Start Free",
                  onClick: () => {
                    window.location.replace(
                      "https://projects.clikkle.com/signup?theme=" + theme
                    );
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                }}
                quote={{
                  text: "Best project management platform I've used to date!",
                  userImg: someee,
                  userName: "Liam S.",
                  userRole: "Freelancer",
                }}
                theme={theme}
              />

              {/* Right Column: Animation Panel */}
              <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none gap-[8rem] justify-self-end">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <BugTrackingAnimationPanel />
              </div>
            </div>
          </div>
        </section>
      </section>

        <section className="w-full">
        <section
          className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
          id="features4-4"
        >
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
              {/* Left Column: Image Panel (Inverted) */}
              <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none justify-self-start">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <Image
                  src={custom4}
                  alt="Workflows and Time Tracking"
                  className="w-auto h-full relative md:h-[520px] max-h-[350px] rounded-xl shadow-2xl"
                  width={520}
                  height={520}
                />
              </div>

              {/* Right Column: Feature Text */}
              <FeatureSection
                title="Automate Workflows & Monitor Time"
                showIcon={true}
                description="Streamline processes, track time intelligently, and produce insights for strategic planning."
                features={features4}
                cta1={{
                  label: "Learn More",
                  onClick: () => {
                    window.location.href = "#features";
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                }}
                cta2={{
                  label: "Get Started Free",
                  mobileLabel: "Start Free",
                  onClick: () => {
                    window.location.replace(
                      "https://projects.clikkle.com/signup?theme=" + theme
                    );
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                }}
                quote={{
                  text: "Fast setup that keeps all my projects right on track!",
                  userImg: sect4,
                  userName: "David R.",
                  userRole: "Project Manager",
                }}
                theme={theme}
              />
            </div>
          </div>
        </section>
      </section>

        <section className="w-full">
          <AppsSection headingPrefix="Profit from efficient project management"/>
        </section>

        <FAQSection
        faqs={faqs}
        title="Frequently Asked Questions"
        subtitle="Our friendly team would love to answer your questions."
        />

        <PricingSection
          title="Plans and Pricing"
          subtitle='Get <span class="font-semibold">unlimited storage</span> when you subscribe annually, and save big on your plan.'
          monthlyPlans={monthlyPlans}
          annualPlans={annualPlans}
          onPlanSelect={(planName, cycle) => {
            window.location.replace(
              `https://projects.clikkle.com/signup?plan=${planName.toLowerCase()}&cycle=${cycle}&theme=${theme}`
            );
          }}
          contactSalesUrl="/contact"
        />
        <section className="w-full flex justify-center items-center">
          <SecuritySection />
          <PreFooterCTA
            badge="Ready to Transform?"
            mobileHeadline="Streamline Your Projects"
            desktopHeadline={`<span class="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">Streamline Your Projects</span> Today.`}
            description='Plan, track, and deliver projects efficiently with smart tools and real-time updates.<span class="hidden md:inline"> No credit card required.</span>'
            buttonText="Get Started for Free"
            buttonUrl={`https://projects.clikkle.com/signup?theme=${theme}`}
            userImages={[testimonials1, testimonials2, testimonials3, testimonials4, testimonials5]}
            userCount="10,000+ users"
            rating="4.9/5"
            theme={theme}
          />
        </section>
      </div>

      <Footer/>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default ProjectsHome;
