"use client";
import React, { useEffect, useRef, useState } from "react";
import { ArrowRightIcon, Ellipsis, Logs } from "lucide-react";
import ThemeSwitch from "../components/themeSwitch";
import { Button } from "../components/button";
import { useTheme } from "../atoms/theme";
import dashboard from "../../public/images/dashboard.webp";
import hub from "../../public/images/HRMS/dashboard-light.png"
import bondsmiller from "../../public/images/bonsmiller.jpg";
import chat from "../../public/images/chat.png";
import esign from "../../public/images/esign.png";
import files from "../../public/images/files.png";
import projects from "../../public/images/projects.png";
import SidebarDrawer from "../components/sidebarDrawer";
import { FaArrowRight, FaStar } from "react-icons/fa";
import { Box } from "@mui/material";
import hrimage from "../../public/images/hr.png";
import illustration from "../../public/images/banner.png";
import { apps } from "../constants/products";
import Link from "next/link";
import Image from "next/image";
import { footerColumns } from "../constants/footerText";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import ClikkleLogo from "@/components/ClikkleLogo";
import Footer from "@/components/Footer";
import QuesthireLogo from "../../public/images/QuesthireLogo.png";
import ChatBox from "../../public/images/chatboxLogo.png";
import Hirely from "../../public/images/hirelyLogo.png";
import Wurknest from "../../public/images/wurknestLogo.png";
import Taskly from "../../public/images/tasklyLogo.png";
import Appstir from "../../public/images/AppstirLogo.png";
import MainHeader from "@/components/MainHeader";

function PartnersPage() {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);
  const [productsOpen, setProductsOpen] = useState(false);

  const companyLogos = [
    {
      name: "Questhire",
      imageUrl: QuesthireLogo,
      baseWidth: 148,
      baseHeight: 68,
    },
    {
      name: "Chatbox",
      imageUrl: ChatBox,
      baseWidth: 148,
      baseHeight: 68,
    },
    {
      name: "Hirely",
      imageUrl: Hirely,
      baseWidth: 148,
      baseHeight: 50,
      forceBlackInLightMode: true,
    },
    {
      name: "clikkle",
      imageUrl:
        theme === "dark"
          ? "https://cdn.clikkle.com/images/clikkle/logo/2025/Clikkle%20Blue%20(%20White%20Text).png"
          : "https://cdn.clikkle.com/images/clikkle/logo/2025/Clikkle%20Blue%20(%20Black%20Text).png",
      baseWidth: 148,
      baseHeight: 68,
      forceBlackInLightMode: false,
      noFilterInDarkMode: false,
    },
    {
      name: "Taskly",
      imageUrl: Taskly,
      baseWidth: 148,
      baseHeight: 40,
    },
    {
      name: "Appstir",
      imageUrl: Appstir,
      baseWidth: 148,
      baseHeight: 54.55,
    },
  ];

  const [dotsOpen, setDotsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#0B0C0E] ">
      <section className="w-full">
        <section className="relative w-full overflow-hidden">
          {" "}
          <div
            className={`fixed top-0 inset-x-0 z-50 ${
              scrolled
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                : productsOpen || dotsOpen
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                : ""
            }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <MainHeader/>
          </div>
        </section>
      </section>

      <section
        className={`relative py-20 md:py-32 overflow-hidden ${
          announcementOpen ? "pt-32 md:pt-40" : "pt-24 md:pt-32"
        }`}
       >
        <div className="max-w-7xl mx-auto px-6">
          {/* Hero Content */}
          <div className="relative mx-auto max-w-4xl text-center">
            {/* Badge */}
            <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 mb-8 shadow-sm">
              <span className="text-sm font-semibold text-gray-900 dark:text-white">
                Partners
              </span>
            </div>

            {/* Heading */}
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-gray-900 dark:text-white mb-6 leading-tight">
              Become a{" "}
              <span className="relative inline-block">
                <span className="relative z-10 text-gray-900 dark:text-white">
                  Wurknest Partner
                </span>
                <span className="absolute bottom-2 left-0 right-0 h-3 bg-gray-200 dark:bg-gray-700/50 -z-0 rounded-sm"></span>
              </span>
              !
            </h1>

            {/* Description */}
            <p className="text-lg md:text-xl text-gray-600 dark:text-gray-400 mb-10 max-w-2xl mx-auto leading-relaxed">
              We build powerful solutions for modern Organizations. You have the
              audience, we have the tools. Let&apos;s help more companies scale
              smarter.
            </p>

            {/* CTA Form */}
            <div className="flex flex-col md:flex-row gap-4 max-w-xl mx-auto mb-12">
              <div className="flex-1">
                <div className="relative flex items-center bg-white dark:bg-[#1a1925]/50 border border-gray-300 dark:border-white/20 rounded-xl px-4 py-3 shadow-sm focus-within:ring-2 focus-within:ring-gray-400 dark:focus-within:ring-white/20 transition-all">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="20"
                    height="20"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    className="flex-shrink-0 text-gray-400 dark:text-gray-500"
                  >
                    <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                    <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                  </svg>
                  <input
                    className="flex-1 ml-3 bg-transparent border-none outline-none text-gray-900 dark:text-white placeholder:text-gray-400 dark:placeholder:text-gray-500"
                    placeholder="Enter your email"
                    type="email"
                    name="email_address"
                  />
                </div>
              </div>
              <Link href="/affiliate-program/join">
                <button className="w-full md:w-auto px-8 py-3 bg-gray-900 dark:bg-white hover:bg-gray-800 dark:hover:bg-gray-100 text-white dark:text-gray-900 font-semibold rounded-xl shadow-md hover:shadow-xl transition-all duration-300 hover:-translate-y-0.5">
                  Join Partner Program
                </button>
              </Link>
            </div>

            {/* Stats */}
            <div className="flex flex-col md:flex-row items-center justify-center gap-8 md:gap-16 text-center">
              <div>
                <p className="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white mb-1">
                  51,000+
                </p>
                <p className="text-sm md:text-base text-gray-600 dark:text-gray-400">
                  companies powered by our tools
                </p>
              </div>
              <div className="hidden md:block w-px h-12 bg-gray-300 dark:bg-gray-700"></div>
              <div>
                <p className="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white mb-1">
                  500+
                </p>
                <p className="text-sm md:text-base text-gray-600 dark:text-gray-400">
                  active advocates and partners
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="py-16 md:py-24 relative overflow-hidden">
        <div className="max-w-7xl mx-auto px-6">
          {/* Section Header */}
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-4">
              From signup to{" "}
              <span className="relative inline-block">
                <span className="relative z-10">first commission</span>
                <span className="absolute bottom-1 left-0 right-0 h-3 bg-gray-200 dark:bg-gray-700/50 -z-0 rounded-sm"></span>
              </span>
            </h2>
            <p className="text-lg text-gray-600 dark:text-gray-400 max-w-2xl mx-auto mt-4">
              Partner with us and start earning recurring revenue
            </p>
          </div>

          {/* Main Content - Split Layout */}
          <div className="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center max-w-6xl mx-auto">
            {/* Left: Big Visual */}
            <div className="relative">
              <div className="bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl p-8 md:p-12">
                {/* Process Steps */}
                <div className="space-y-8">
                  {/* Step 1 */}
                  <div className="flex items-start gap-4">
                    <div className="flex-shrink-0 w-16 h-16 bg-gray-900 dark:bg-white rounded-2xl flex items-center justify-center">
                      <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-white dark:text-gray-900">
                        <circle cx="8" cy="21" r="1"></circle>
                        <circle cx="19" cy="21" r="1"></circle>
                        <path d="M2.05 2.05h2l2.66 12.42a2 2 0 0 0 2 1.58h9.78a2 2 0 0 0 1.95-1.57l1.65-7.43H5.12"></path>
                      </svg>
                    </div>
                    <div className="flex-1 pt-1">
                      <h3 className="text-lg font-bold text-gray-900 dark:text-white mb-2">Choose Product</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">
                        Select from Helply, InstantDocs, or Groove
                      </p>
                    </div>
                  </div>

                  {/* Connector */}
                  <div className="flex items-center">
                    <div className="w-16 flex justify-center">
                      <div className="w-0.5 h-8 bg-gray-300 dark:bg-gray-700"></div>
                    </div>
                  </div>

                  {/* Step 2 */}
                  <div className="flex items-start gap-4">
                    <div className="flex-shrink-0 w-16 h-16 bg-gray-900 dark:bg-white rounded-2xl flex items-center justify-center">
                      <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-white dark:text-gray-900">
                        <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path>
                        <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path>
                      </svg>
                    </div>
                    <div className="flex-1 pt-1">
                      <h3 className="text-lg font-bold text-gray-900 dark:text-white mb-2">Get Your Link</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">
                        Receive unique tracking link instantly
                      </p>
                    </div>
                  </div>

                  {/* Connector */}
                  <div className="flex items-center">
                    <div className="w-16 flex justify-center">
                      <div className="w-0.5 h-8 bg-gray-300 dark:bg-gray-700"></div>
                    </div>
                  </div>

                  {/* Step 3 */}
                  <div className="flex items-start gap-4">
                    <div className="flex-shrink-0 w-16 h-16 bg-gray-900 dark:bg-white rounded-2xl flex items-center justify-center">
                      <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-white dark:text-gray-900">
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                      </svg>
                    </div>
                    <div className="flex-1 pt-1">
                      <h3 className="text-lg font-bold text-gray-900 dark:text-white mb-2">Share with Audience</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">
                        Promote through your channels and content
                      </p>
                    </div>
                  </div>

                  {/* Connector */}
                  <div className="flex items-center">
                    <div className="w-16 flex justify-center">
                      <div className="w-0.5 h-8 bg-gray-300 dark:bg-gray-700"></div>
                    </div>
                  </div>

                  {/* Step 4 */}
                  <div className="flex items-start gap-4">
                    <div className="flex-shrink-0 w-16 h-16 bg-gray-900 dark:bg-white rounded-2xl flex items-center justify-center">
                      <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-white dark:text-gray-900">
                        <line x1="12" x2="12" y1="2" y2="22"></line>
                        <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                      </svg>
                    </div>
                    <div className="flex-1 pt-1">
                      <h3 className="text-lg font-bold text-gray-900 dark:text-white mb-2">Earn Commission</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">
                        Get paid monthly for every active referral
                      </p>
                    </div>
                  </div>
                </div>

                {/* Big Stat */}
                <div className="mt-10 pt-8 border-t border-gray-300 dark:border-gray-700">
                  <div className="text-center">
                    <div className="text-5xl md:text-6xl font-bold text-gray-900 dark:text-white mb-2">30%</div>
                    <p className="text-gray-600 dark:text-gray-400">lifetime recurring commission</p>
                  </div>
                </div>
              </div>
            </div>

            {/* Right: Text Content */}
            <div className="space-y-8">
              <div>
                <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">
                  Pick from our converting products
                </h3>
                <p className="text-gray-600 dark:text-gray-400 leading-relaxed">
                  Choose from Helply&apos;s AI agent (handles 70% of support tickets), InstantDocs AI recorder (turns recordings into docs), or Groove (AI-powered inbox for lean teams).
                </p>
              </div>

              <div>
                <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">
                  Simple setup, zero hassle
                </h3>
                <p className="text-gray-600 dark:text-gray-400 leading-relaxed">
                  Get your unique tracking link instantly. No complicated forms, no approval delays. Copy, paste, and start promoting within minutes.
                </p>
              </div>

              <div>
                <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">
                  Recurring revenue for life
                </h3>
                <p className="text-gray-600 dark:text-gray-400 leading-relaxed">
                  Earn 30% monthly commission for every customer you refer. As long as they stay subscribed, you keep earning. No caps, no limits.
                </p>
              </div>

              <div className="pt-4">
                <Link href="/affiliate-program/join">
                  <button className="w-full md:w-auto px-8 py-4 bg-gray-900 dark:bg-white hover:bg-gray-800 dark:hover:bg-gray-100 text-white dark:text-gray-900 font-semibold rounded-xl shadow-md hover:shadow-xl transition-all duration-300">
                    Join Partner Program
                  </button>
                </Link>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="relative py-16 md:py-24 overflow-hidden">
        <div className="max-w-7xl mx-auto px-6">
          {/* Main Content */}
          <div className="relative">
            {/* Large Feature Card */}
            <div className="bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden">
              <div className="grid lg:grid-cols-5 gap-0">
                {/* Left: Image */}
                <div className="lg:col-span-2 relative h-64 lg:h-auto">
                  <Image
                    alt="Partner dashboard showing earnings"
                    loading="lazy"
                    width="500"
                    height="500"
                    decoding="async"
                    className="absolute inset-0 w-full h-full object-cover"
                    style={{ color: "transparent" }}
                    src={dashboard}
                  />
                  {/* Overlay Badge on Image */}
                  <div className="absolute top-6 left-6">
                    <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/90 dark:bg-gray-900/90 backdrop-blur-sm border border-gray-300 dark:border-gray-700 shadow-lg">
                      <div className="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                      <span className="text-sm font-bold text-gray-900 dark:text-white">
                        $20,000+ paid out
                      </span>
                    </div>
                  </div>
                </div>

                {/* Right: Content */}
                <div className="lg:col-span-3 p-8 md:p-12 flex flex-col justify-center">
                  <div className="space-y-6">
                    <div>
                      <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-4 leading-tight">
                        Real partners,{" "}
                        <span className="relative inline-block">
                          <span className="relative z-10">real earnings</span>
                          <span className="absolute bottom-1 left-0 right-0 h-3 bg-gray-200 dark:bg-gray-700/50 -z-0 rounded-sm"></span>
                        </span>
                      </h2>
                      <p className="text-lg text-gray-600 dark:text-gray-400 leading-relaxed max-w-xl">
                        Join hundreds of creators, consultants, and agencies earning recurring revenue by sharing tools they actually use and recommend.
                      </p>
                    </div>

                    {/* Stats Grid */}
                    <div className="grid grid-cols-2 gap-6 pt-4">
                      <div>
                        <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-1">
                          30%
                        </div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">
                          Commission rate
                        </p>
                      </div>
                      <div>
                        <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-1">
                          Lifetime
                        </div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">
                          Recurring payouts
                        </p>
                      </div>
                      <div>
                        <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-1">
                          500+
                        </div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">
                          Active partners
                        </p>
                      </div>
                      <div>
                        <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-1">
                          $0
                        </div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">
                          Signup cost
                        </p>
                      </div>
                    </div>

                    {/* CTA */}
                    <div className="pt-4">
                      <Link href="/affiliate-program/join">
                        <button className="px-8 py-4 bg-gray-900 dark:bg-white hover:bg-gray-800 dark:hover:bg-gray-100 text-white dark:text-gray-900 font-semibold rounded-xl shadow-md hover:shadow-xl transition-all duration-300">
                          Start Earning Today
                        </button>
                      </Link>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="py-16 md:py-24 relative overflow-hidden">
        <div className="max-w-7xl mx-auto px-6">
          {/* Section Header */}
          <div className="text-center mb-12 md:mb-16">
            <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-4">
              Products worth{" "}
              <span className="relative inline-block">
                <span className="relative z-10">promoting</span>
                <span className="absolute bottom-1 left-0 right-0 h-3 bg-gray-200 dark:bg-gray-700/50 -z-0 rounded-sm"></span>
              </span>
            </h2>
            <p className="text-lg text-gray-600 dark:text-gray-400 max-w-2xl mx-auto mt-4">
              A complete work suite that your audience will actually use and love
            </p>
          </div>

          {/* Bento Grid */}
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {/* Large Card 1 - HR (spans 2 columns on lg) */}
            <Link href="/hr" className="group lg:col-span-2">
              <div className="relative h-full bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden hover:shadow-xl transition-all duration-300">
                <div className="grid lg:grid-cols-2 gap-0 h-full">
                  <div className="p-8 flex flex-col justify-between">
                    <div>
                      <div className="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg bg-gray-200 dark:bg-gray-800 mb-4">
                        <span className="text-sm font-bold text-gray-900 dark:text-white">HR</span>
                      </div>
                      <h3 className="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white mb-3">
                        HR Management
                      </h3>
                      <p className="text-gray-600 dark:text-gray-400">
                        Complete HR system for hiring, payroll, and team management
                      </p>
                    </div>
                    <div className="mt-6">
                      <span className="inline-flex items-center text-gray-900 dark:text-white font-semibold group-hover:gap-2 transition-all">
                        Explore
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="ml-1 group-hover:translate-x-1 transition-transform">
                          <path d="M5 12h14"></path>
                          <path d="m12 5 7 7-7 7"></path>
                        </svg>
                      </span>
                    </div>
                  </div>
                  <div className="relative h-64 lg:h-auto">
                    <Image
                      alt="HR Management"
                      loading="lazy"
                      width="518"
                      height="324"
                      decoding="async"
                      className="absolute inset-0 w-full h-full object-cover"
                      style={{ color: "transparent" }}
                      src={hrimage}
                    />
                  </div>
                </div>
              </div>
            </Link>

            {/* Card 2 - Files */}
            <Link href="/files" className="group">
              <div className="relative h-full bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden hover:shadow-xl transition-all duration-300 p-8 flex flex-col">
                <div className="flex-1">
                  <div className="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg bg-gray-200 dark:bg-gray-800 mb-4">
                    <span className="text-sm font-bold text-gray-900 dark:text-white">Files</span>
                  </div>
                  <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-3">
                    File Storage
                  </h3>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    Secure cloud storage and file sharing
                  </p>
                </div>
                <div className="relative h-48 -mx-8 -mb-8">
                  <Image
                    alt="File Storage"
                    loading="lazy"
                    width="518"
                    height="324"
                    decoding="async"
                    className="absolute inset-0 w-full h-full object-cover rounded-b-3xl"
                    style={{ color: "transparent" }}
                    src={files}
                  />
                </div>
              </div>
            </Link>

            {/* Card 3 - eSign */}
            <Link href="/esign" className="group">
              <div className="relative h-full bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden hover:shadow-xl transition-all duration-300 p-8 flex flex-col">
                <div className="flex-1">
                  <div className="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg bg-gray-200 dark:bg-gray-800 mb-4">
                    <span className="text-sm font-bold text-gray-900 dark:text-white">eSign</span>
                  </div>
                  <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-3">
                    E-Signatures
                  </h3>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    Digital signatures made simple and secure
                  </p>
                </div>
                <div className="relative h-48 -mx-8 -mb-8">
                  <Image
                    alt="E-Signatures"
                    loading="lazy"
                    width="518"
                    height="302"
                    decoding="async"
                    className="absolute inset-0 w-full h-full object-cover rounded-b-3xl"
                    style={{ color: "transparent" }}
                    src={esign}
                  />
                </div>
              </div>
            </Link>

            {/* Card 4 - Projects (spans 2 columns on lg) */}
            <Link href="/projects" className="group lg:col-span-2">
              <div className="relative h-full bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden hover:shadow-xl transition-all duration-300">
                <div className="grid lg:grid-cols-2 gap-0 h-full">
                  <div className="relative h-64 lg:h-auto lg:order-last">
                    <Image
                      alt="Project Management"
                      loading="lazy"
                      width="518"
                      height="302"
                      decoding="async"
                      className="absolute inset-0 w-full h-full object-cover"
                      style={{ color: "transparent" }}
                      src={projects}
                    />
                  </div>
                  <div className="p-8 flex flex-col justify-between">
                    <div>
                      <div className="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg bg-gray-200 dark:bg-gray-800 mb-4">
                        <span className="text-sm font-bold text-gray-900 dark:text-white">Projects</span>
                      </div>
                      <h3 className="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white mb-3">
                        Project Management
                      </h3>
                      <p className="text-gray-600 dark:text-gray-400">
                        Plan, track, and deliver projects with your team
                      </p>
                    </div>
                    <div className="mt-6">
                      <span className="inline-flex items-center text-gray-900 dark:text-white font-semibold group-hover:gap-2 transition-all">
                        Explore
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="ml-1 group-hover:translate-x-1 transition-transform">
                          <path d="M5 12h14"></path>
                          <path d="m12 5 7 7-7 7"></path>
                        </svg>
                      </span>
                    </div>
                  </div>
                </div>
              </div>
            </Link>

            {/* Card 5 - Chat (spans 2 columns on lg) */}
            <Link href="/chat" className="group lg:col-span-2">
              <div className="relative h-full bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden hover:shadow-xl transition-all duration-300">
                <div className="grid lg:grid-cols-2 gap-0 h-full">
                  <div className="p-8 flex flex-col justify-between">
                    <div>
                      <div className="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg bg-gray-200 dark:bg-gray-800 mb-4">
                        <span className="text-sm font-bold text-gray-900 dark:text-white">Chat</span>
                      </div>
                      <h3 className="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white mb-3">
                        Team Chat
                      </h3>
                      <p className="text-gray-600 dark:text-gray-400">
                        Real-time messaging and collaboration for your entire team
                      </p>
                    </div>
                    <div className="mt-6">
                      <span className="inline-flex items-center text-gray-900 dark:text-white font-semibold group-hover:gap-2 transition-all">
                        Explore
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="ml-1 group-hover:translate-x-1 transition-transform">
                          <path d="M5 12h14"></path>
                          <path d="m12 5 7 7-7 7"></path>
                        </svg>
                      </span>
                    </div>
                  </div>
                  <div className="relative h-64 lg:h-auto">
                    <Image
                      alt="Team Chat"
                      loading="lazy"
                      width="518"
                      height="292"
                      decoding="async"
                      className="absolute inset-0 w-full h-full object-cover"
                      style={{ color: "transparent" }}
                      src={chat}
                    />
                  </div>
                </div>
              </div>
            </Link>

            {/* Card 6 - Hub */}
            <Link href="/hub" className="group">
              <div className="relative h-full bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden hover:shadow-xl transition-all duration-300 p-8 flex flex-col">
                <div className="flex-1">
                  <div className="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg bg-gray-200 dark:bg-gray-800 mb-4">
                    <span className="text-sm font-bold text-gray-900 dark:text-white">Hub</span>
                  </div>
                  <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-3">
                    Wurknest Hub
                  </h3>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    All-in-one workspace bringing everything together
                  </p>
                </div>
                <div className="relative h-48 -mx-8 -mb-8">
                  <Image
                    alt="Wurknest Hub"
                    loading="lazy"
                    width="518"
                    height="324"
                    decoding="async"
                    className="absolute inset-0 w-full h-full object-cover rounded-b-3xl"
                    style={{ color: "transparent" }}
                    src={hub}
                  />
                </div>
              </div>
            </Link>

            {/* Card 7 - Reliability Banner (spans full width on lg) */}
            <div className="lg:col-span-3">
              <div className="relative bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden p-8 md:p-12">
                <div className="max-w-4xl mx-auto text-center">
                  <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-gray-200 dark:bg-gray-800 mb-6">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-gray-900 dark:text-white">
                      <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                    </svg>
                    <span className="text-sm font-bold text-gray-900 dark:text-white">Enterprise-Grade Reliability</span>
                  </div>
                  
                  <h3 className="text-2xl md:text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                    Built for businesses that{" "}
                    <span className="relative inline-block">
                      <span className="relative z-10">can&apos;t afford downtime</span>
                      <span className="absolute bottom-1 left-0 right-0 h-3 bg-gray-200 dark:bg-gray-700/50 -z-0 rounded-sm"></span>
                    </span>
                  </h3>
                  
                  <p className="text-lg text-gray-600 dark:text-gray-400 mb-8 max-w-3xl mx-auto">
                    Every product in Wurknest Hub is backed by 99.9% uptime SLA, enterprise-grade security, and 24/7 support. Your referrals get tools they can actually depend on.
                  </p>

                  <div className="grid grid-cols-2 md:grid-cols-4 gap-6 md:gap-8">
                    <div>
                      <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-2">99.9%</div>
                      <p className="text-sm text-gray-600 dark:text-gray-400">Uptime SLA</p>
                    </div>
                    <div>
                      <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-2">24/7</div>
                      <p className="text-sm text-gray-600 dark:text-gray-400">Support</p>
                    </div>
                    <div>
                      <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-2">SOC 2</div>
                      <p className="text-sm text-gray-600 dark:text-gray-400">Compliant</p>
                    </div>
                    <div>
                      <div className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-2">256-bit</div>
                      <p className="text-sm text-gray-600 dark:text-gray-400">Encryption</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="py-16 md:py-24 relative overflow-hidden">
        <div className="max-w-7xl mx-auto px-6">
          <div className="text-center">
                {/* Heading */}
                <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-4">
                  Trusted by modern teams in{" "}
                  <span className="relative inline-block">
                    <span className="relative z-10">80+ countries</span>
                    <span className="absolute bottom-1 left-0 right-0 h-3 bg-gray-200 dark:bg-gray-700/50 -z-0 rounded-sm"></span>
                  </span>
                </h2>
                <p className="text-lg text-gray-600 dark:text-gray-400 mb-12 max-w-2xl mx-auto">
                  Join the companies already succeeding with our tools
                </p>

                {/* Logo Grid */}
                <div className="flex flex-wrap gap-8 md:gap-12 justify-center items-center mx-auto max-w-4xl mb-12">
                  {companyLogos.map((logo) => (
                    <div
                      key={logo.name}
                      className="flex items-center justify-center grayscale hover:grayscale-0 opacity-70 hover:opacity-100 transition-all duration-300"
                    >
                      <Box
                        component="img"
                        src={
                          typeof logo.imageUrl === "string"
                            ? logo.imageUrl
                            : logo.imageUrl.src
                        }
                        alt={logo.name}
                        sx={{
                          width: "120px",
                          height: "auto",
                          maxHeight: "32px",
                          objectFit: "contain",
                          filter:
                            theme === "dark"
                              ? logo.noFilterInDarkMode
                                ? "none"
                                : "brightness(0) invert(1)"
                              : logo.forceBlackInLightMode
                              ? "brightness(0)"
                              : "none",
                          transition: "all 0.3s ease",
                        }}
                      />
                    </div>
                  ))}
                </div>

                {/* CTA Button */}
                <Link href="/affiliate-program/join">
                  <button className="px-8 py-4 bg-gray-900 dark:bg-white hover:bg-gray-800 dark:hover:bg-gray-100 text-white dark:text-gray-900 font-semibold rounded-xl shadow-md hover:shadow-xl transition-all duration-300">
                    Join Partner Program
                  </button>
                </Link>
          </div>
        </div>
      </section>

      <section className="py-16 md:py-24 relative overflow-hidden">
        <div className="max-w-7xl mx-auto px-6">
          {/* Main Content - Two Column Layout */}
          <div className="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
            {/* Left: Content */}
            <div>
              <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-6 leading-tight">
                More than just{" "}
                <span className="relative inline-block">
                  <span className="relative z-10">commission</span>
                  <span className="absolute bottom-1 left-0 right-0 h-3 bg-gray-200 dark:bg-gray-700/50 -z-0 rounded-sm"></span>
                </span>
              </h2>
              <p className="text-lg text-gray-600 dark:text-gray-400 mb-10 leading-relaxed">
                Partner with Wurknest and unlock opportunities that go beyond just earning. We&apos;re invested in your growth.
              </p>

              {/* Benefit List - Stacked */}
              <div className="space-y-6">
                <div className="flex gap-4">
                  <div className="flex-shrink-0 w-12 h-12 bg-gray-900 dark:bg-white rounded-xl flex items-center justify-center">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="text-white dark:text-gray-900"
                    >
                      <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                    </svg>
                  </div>
                  <div className="flex-1">
                    <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-2">
                      Build Brand Authority
                    </h3>
                    <p className="text-gray-600 dark:text-gray-400 leading-relaxed">
                      Work with tools your clients will thank you for. Add credibility and trust by aligning with proven tech.
                    </p>
                  </div>
                </div>

                <div className="flex gap-4">
                  <div className="flex-shrink-0 w-12 h-12 bg-gray-900 dark:bg-white rounded-xl flex items-center justify-center">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="text-white dark:text-gray-900"
                    >
                      <path d="M3 3v16a2 2 0 0 0 2 2h16"></path>
                      <path d="m19 9-5 5-4-4-3 3"></path>
                    </svg>
                  </div>
                  <div className="flex-1">
                    <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-2">
                      New Revenue Streams
                    </h3>
                    <p className="text-gray-600 dark:text-gray-400 leading-relaxed">
                      Resell, consult, train, or build. Our stack opens the door to scalable services and products.
                    </p>
                  </div>
                </div>

                <div className="flex gap-4">
                  <div className="flex-shrink-0 w-12 h-12 bg-gray-900 dark:bg-white rounded-xl flex items-center justify-center">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="text-white dark:text-gray-900"
                    >
                      <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                      <circle cx="9" cy="7" r="4"></circle>
                      <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                      <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                    </svg>
                  </div>
                  <div className="flex-1">
                    <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-2">
                      Expand Your Reach
                    </h3>
                    <p className="text-gray-600 dark:text-gray-400 leading-relaxed">
                      We promote top partners, showcase case studies, and co-market to a growing audience of SaaS and organizations.
                    </p>
                  </div>
                </div>
              </div>
            </div>

            {/* Right: Visual Stats Card */}
            <div className="relative">
              <div className="bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl p-8 md:p-12">
                <div className="space-y-8">
                  <div>
                    <div className="text-sm font-semibold text-gray-600 dark:text-gray-400 mb-2">Average Partner Growth</div>
                    <div className="text-5xl md:text-6xl font-bold text-gray-900 dark:text-white mb-2">
                      3.2x
                    </div>
                    <p className="text-gray-600 dark:text-gray-400">revenue increase in first year</p>
                  </div>

                  <div className="pt-8 border-t border-gray-300 dark:border-gray-700">
                    <div className="grid grid-cols-2 gap-6">
                      <div>
                        <div className="text-3xl font-bold text-gray-900 dark:text-white mb-1">95%</div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">Partner retention</p>
                      </div>
                      <div>
                        <div className="text-3xl font-bold text-gray-900 dark:text-white mb-1">24h</div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">Avg support response</p>
                      </div>
                      <div>
                        <div className="text-3xl font-bold text-gray-900 dark:text-white mb-1">500+</div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">Active partners</p>
                      </div>
                      <div>
                        <div className="text-3xl font-bold text-gray-900 dark:text-white mb-1">80+</div>
                        <p className="text-sm text-gray-600 dark:text-gray-400">Countries served</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="my-10 md:my-20">
        <div className="relative py-16 md:py-24 px-4 lg:px-8 bg-transparent">
          <div className="container mx-auto max-w-7xl">
            {/* Section Header */}
            <div className="text-center mb-12 md:mb-16">
              <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-4">
                What Partners <span className="text-gray-900 dark:text-white">Are Saying</span>
              </h2>
              <p className="text-base md:text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Hear from partners who have transformed their business by joining our affiliate program
              </p>
            </div>

            {/* Testimonial Card */}
            <div className="max-w-6xl mx-auto">
              <div className="bg-white/30 dark:bg-black/30 backdrop-blur-xl border border-gray-900/10 dark:border-white/10 rounded-3xl md:rounded-[40px] shadow-2xl transition-all duration-500 p-0 relative overflow-hidden">
                {/* Decorative background elements */}
                <div className="absolute top-0 right-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -mr-32 -mt-32 blur-3xl" />
                <div className="absolute bottom-0 left-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -ml-32 -mb-32 blur-3xl" />
                
                <div className="grid grid-cols-1 lg:grid-cols-2 gap-0 relative z-10">
                  {/* Image Side */}
                  <div className="relative h-64 lg:h-auto overflow-hidden lg:rounded-l-[40px]">
                    <div className="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent z-10"></div>
                    <Image
                      alt="Bonds Miller - Founder at HowWorks"
                      loading="lazy"
                      width="600"
                      height="600"
                      decoding="async"
                      className="w-full h-full object-cover"
                      src="https://images.pexels.com/photos/20097456/pexels-photo-20097456/free-photo-of-portrait-of-man-in-black-suit.png?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1"
                    />
                  </div>

                  {/* Content Side */}
                  <div className="p-8 md:p-12 flex flex-col justify-center">
                    {/* Quote Icon */}
                    <div className="mb-6">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="48"
                        height="36"
                        fill="none"
                        viewBox="0 0 46 26"
                        className="text-gray-900 dark:text-white"
                      >
                        <g clipPath="url(#a)">
                          <path
                            fill="currentColor"
                            d="M18.712.001c0 .601.047 1.105-.022 1.591-.03.207-.27.43-.469.554-.961.61-2.004 1.097-2.9 1.797-2.9 2.267-4.617 5.25-4.711 9.126-.026 1.1.379 1.376 1.302.946 2.668-1.237 5.538-.511 7.068 1.787 1.67 2.51 1.435 5.85-.566 8.041-2.555 2.797-6.76 2.882-9.66.208-1.737-1.601-2.562-3.668-2.768-6.02-.69-7.877 3.26-14.37 10.453-17.223.712-.282 1.44-.513 2.273-.807Z"
                          ></path>
                        </g>
                        <g clipPath="url(#b)">
                          <path
                            fill="currentColor"
                            d="M38.212.001c0 .601.047 1.105-.022 1.591-.03.207-.27.43-.469.554-.961.61-2.004 1.097-2.9 1.797-2.9 2.267-4.617 5.25-4.711 9.126-.026 1.1.379 1.376 1.302.946 2.668-1.237 5.538-.511 7.068 1.787 1.67 2.51 1.435 5.85-.566 8.041-2.555 2.797-6.76 2.882-9.66.208-1.737-1.601-2.562-3.668-2.768-6.02-.69-7.877 3.26-14.37 10.453-17.223.712-.282 1.44-.513 2.273-.807Z"
                          ></path>
                        </g>
                        <defs>
                          <clipPath id="a">
                            <path fill="#fff" d="M26 26H0V0h26z"></path>
                          </clipPath>
                          <clipPath id="b">
                            <path fill="#fff" d="M45.5 26h-26V0h26z"></path>
                          </clipPath>
                        </defs>
                      </svg>
                    </div>

                    {/* Testimonial Text */}
                    <blockquote className="mb-8">
                      <p className="text-lg md:text-xl lg:text-2xl text-gray-900 dark:text-gray-100 leading-relaxed font-medium">
                        I came in looking for affiliate commissions. I stayed
                        because of the co-marketing, the inbound leads, and the
                        support. Total game-changer. Easy to demo. Easy to
                        deploy. And they sell themselves. It&apos;s a no-brainer
                        if you work with SaaS.
                      </p>
                    </blockquote>

                    {/* Author Info */}
                    <div className="flex items-center gap-4 mb-6">
                      <div className="w-1 h-16 rounded-full bg-gray-900 dark:bg-white"></div>
                      <div>
                        <div className="font-semibold text-xl text-gray-900 dark:text-white">
                          Bonds Miller
                        </div>
                        <p className="text-gray-600 dark:text-gray-400 text-base">
                          Founder at HowWorks
                        </p>
                      </div>
                    </div>

                    {/* Rating Stars */}
                    <div className="flex gap-1">
                      {Array(5)
                        .fill(0)
                        .map((_, i) => (
                          <FaStar key={i} className="text-gray-900 dark:text-white text-xl" />
                        ))}
                    </div>
                  </div>
                </div>
              </div>

              {/* Trust Badge */}
              <div className="text-center mt-8">
                <p className="text-sm text-gray-600 dark:text-gray-400">
                  <span className="font-semibold text-gray-900 dark:text-white">Trusted by 1000+</span> partners worldwide
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="w-full flex justify-center items-center bg-transparent">
        <div className="relative my-24 mx-[1.2rem] md:mx-[50px] w-full max-w-[1062px]">
          {/* Glassmorphic Container */}
          <div className="bg-white/30 dark:bg-black/30 backdrop-blur-xl border border-gray-900/10 dark:border-white/10 rounded-3xl md:rounded-[40px] shadow-2xl transition-all duration-500 p-8 md:p-12 relative overflow-hidden">
            {/* Decorative background elements */}
            <div className="absolute top-0 right-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -mr-32 -mt-32 blur-3xl" />
            <div className="absolute bottom-0 left-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -ml-32 -mb-32 blur-3xl" />

            <div className="flex flex-col items-center justify-center h-full relative z-10">
              <div className="w-full text-center flex flex-col items-center gap-6 max-w-3xl mx-auto">
                {/* Badge */}
                <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 mb-2">
                  <span className="text-xs md:text-sm font-semibold text-gray-900 dark:text-white tracking-wider uppercase">
                    Start Earning Today
                  </span>
                </div>

                {/* Heading */}
                <div>
                  {/* Mobile headline */}
                  <h2 className="md:hidden !text-[28px] font-bold text-gray-900 dark:text-white mb-3 leading-tight">
                    Earn Cash by Sharing Great Products
                  </h2>

                  {/* Desktop headline */}
                  <h2 className="hidden md:block !text-[40px] lg:!text-[55px] font-bold text-gray-900 dark:text-white mb-4 leading-tight">
                    <span className="text-gray-900 dark:text-white">Earn Cash</span> by Sharing<br />
                    Great Products Today
                  </h2>
                </div>

                {/* Description */}
                <p className="text-base md:text-lg text-gray-700 dark:text-gray-300 max-w-2xl leading-relaxed">
                  Join our affiliate program and start earning commissions with unlimited potential. 
                  Free to join, fast payouts, and full support included.
                </p>

                {/* CTA Button */}
                <div className="flex flex-col sm:flex-row items-center gap-4 mt-4 w-full sm:w-auto">
                  <Link href="/affiliate-program/join" className="w-full sm:w-auto">
                    <button className="group relative px-8 md:px-10 py-4 md:py-5 bg-gray-900 dark:bg-white text-white dark:text-black rounded-2xl font-semibold text-base md:text-lg transition-all duration-300 hover:scale-105 hover:shadow-2xl w-full sm:w-auto overflow-hidden">
                      <span className="relative z-10 flex items-center justify-center gap-2">
                        Join the Team
                        <svg
                          className="w-5 h-5 group-hover:translate-x-1 transition-transform"
                          fill="none"
                          stroke="currentColor"
                          viewBox="0 0 24 24"
                        >
                          <path
                            strokeLinecap="round"
                            strokeLinejoin="round"
                            strokeWidth={2}
                            d="M17 8l4 4m0 0l-4 4m4-4H3"
                          />
                        </svg>
                      </span>
                      <div className="absolute inset-0 bg-gradient-to-r from-gray-800 to-gray-900 dark:from-gray-100 dark:to-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                    </button>
                  </Link>
                </div>

                {/* Benefits List */}
                <div className="mt-6 md:mt-8 pt-6 md:pt-8 border-t border-gray-900/10 dark:border-white/10 w-full">
                  <div className="flex flex-col sm:flex-row items-center justify-center gap-4 md:gap-8 flex-wrap">
                    <div className="flex items-center gap-2">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-gray-900 dark:text-white"
                      >
                        <path d="M20 6 9 17l-5-5"></path>
                      </svg>
                      <span className="text-sm md:text-base font-medium text-gray-900 dark:text-white">
                        Free to join
                      </span>
                    </div>
                    <div className="flex items-center gap-2">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-gray-900 dark:text-white"
                      >
                        <path d="M20 6 9 17l-5-5"></path>
                      </svg>
                      <span className="text-sm md:text-base font-medium text-gray-900 dark:text-white">
                        Fast payouts
                      </span>
                    </div>
                    <div className="flex items-center gap-2">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-gray-900 dark:text-white"
                      >
                        <path d="M20 6 9 17l-5-5"></path>
                      </svg>
                      <span className="text-sm md:text-base font-medium text-gray-900 dark:text-white">
                        Full support
                      </span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
}

export default PartnersPage;
