import Link from "next/link";

const NotFound = () => {
  return (
    <div className="flex flex-col items-center justify-center h-screen bg-white dark:bg-[#1a1925] text-center px-6">
      <h1 className="text-8xl font-extrabold  text-[#286efb] drop-shadow-lg">
        404
      </h1>
      <p className="mt-4 text-2xl font-semibold text-gray-900 dark:text-white">
        Page Not Found
      </p>
      <p className="mt-2 text-gray-900 dark:text-white">
        Sorry, the page you’re looking for doesn’t exist or has been moved.
      </p>
      <Link
        href="/"
        className="mt-6 px-6 py-1 bg-[#286efb] text-white text-lg rounded-2xl shadow transition-all"
      >
        Go Back Home
      </Link>
    </div>
  );
};

export default NotFound;
