"use client";
import Link from "next/link";
import Image from "next/image";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import { motion, AnimatePresence } from "framer-motion";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import {
  AlertTriangleIcon,
  BarChart2Icon,
  Bell,
  BrainIcon,
  BugIcon,
  CalendarDays,
  CalendarRangeIcon,
  Ellipsis,
  ClipboardCheckIcon,
  ClockIcon,
  DatabaseIcon,
  FileBarChartIcon,
  FileTextIcon,
  GlobeIcon,
  HandshakeIcon,
  HeadphonesIcon,
  KanbanIcon,
  LayersIcon,
  LayoutDashboardIcon,
  LayoutIcon,
  PaletteIcon,
  ProjectorIcon,
  SearchIcon,
  SendIcon,
  Settings2Icon,
  ShieldCheckIcon,
  SparklesIcon,
  TimerIcon,
  UserCogIcon,
  UserIcon,
  Users,
  Workflow,
  WorkflowIcon,
  ArrowDown,
} from "lucide-react";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import WhyProductSection from "../components/WhyProductSection";
import FeatureSection from "../components/FeatureSection";
import HRAnimationPanel from "../components/HRAnimationPanel";
import DigitalHRAnimationPanel from "../components/DigitalHRAnimationPanel";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import { BarChart3Icon, UsersIcon } from "lucide-react";
import { useTheme } from "../atoms/theme";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/project-manager-4439353-3726924.webp";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/user4.jpeg";
import hrdark from "../../public/images/hrdark.png";
import hrlight from "../../public/images/hrlight.png";
import wsj from "../../public/images/she.avif";
import hr1 from "../../public/images/hr1.png";
import hr3 from "../../public/images/hr3.png";
import hr4 from "../../public/images/hr4.png";
import hr5 from "../../public/images/hr5.png";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import Footer from "@/components/Footer";
import rightArrow from "../../public/images/right-arrow.png";
import user5 from "../../public/images/user5.jpeg";
import user6 from "../../public/images/user6.jpeg";
import user9 from "../../public/images/user9.jpeg";
import user7 from "../../public/images/user7.jpeg";
import user8 from "../../public/images/user8.jpeg";
import user1 from "../../public/images/user1.jpeg";
import user3 from "../../public/images/user3.jpeg";
import user4 from "../../public/images/user4.jpeg";
import someee from "../../public/images/someee.jpeg";
import TabbedFeature from "../components/TabbedFeature";
import TestimonialSection from "../components/TestimonialSection";
import PricingSection from "../components/PricingSection";
import FAQSection from "../components/FAQSection";
import PreFooterCTA from "../components/PreFooterCTA";
import HeroSection from "@/components/HeroSection";
import SecuritySection from "@/components/SecuritySection";
import { BsGridFill } from "react-icons/bs";
import { PiHandshakeFill, PiFiles } from "react-icons/pi";
import { IoBriefcaseOutline, IoCalendarOutline, IoHeartCircle } from "react-icons/io5";
import { FaUmbrellaBeach, FaIdCard } from "react-icons/fa";
import { IoMdAlarm } from "react-icons/io";
import { HiOutlineSpeakerWave, HiOutlineDocumentText } from "react-icons/hi2";
import { TbCreditCard } from "react-icons/tb";
import { MdDataSaverOff, MdOutlineBarChart, MdOutlineFlightTakeoff, MdOutlineTask } from "react-icons/md";

import hrDashboardDay from "../../public/images/HRMS/hrms app-dashboard-daymode.png";
import hrDashboardDark from "../../public/images/HRMS/hrms app-dashboard-darkmode.png";
import hrRecruitDocsDay from "../../public/images/HRMS/hrms app-recruit-recruitment docs-daymode.png";
import hrRecruitDocsDark from "../../public/images/HRMS/hrms app-recruit-recruitment docs-darkmode.png";
import hrJobListingsDay from "../../public/images/HRMS/hrms app-recruit-job listings-daymode.png";
import hrJobListingsDark from "../../public/images/HRMS/hrms app-recruit-job listings-darkmode.png";
import hrLeaveDay from "../../public/images/HRMS/hrms app-leave tracker-leave request-daymode.png";
import hrLeaveDark from "../../public/images/HRMS/hrms app-leave tracker-leave request-darkmode.png";
import hrShiftsDay from "../../public/images/HRMS/hrms app-schedule-employee shifts-daymode.png";
import hrShiftsDark from "../../public/images/HRMS/hrms app-schedule-employee shifts-darkmode.png";
import hrNotifyDay from "../../public/images/HRMS/hrms app-settings-notifications-daymode.png";
import hrNotifyDark from "../../public/images/HRMS/hrms app-settings-notifications-darkmode.png";
import hrOrgListDay from "../../public/images/HRMS/dashboard-light.png";
import hrOrgListDark from "../../public/images/HRMS/dashboard-dark.png";
import hrOperationsDay from "../../public/images/HRMS/hrms app-operations-daymode.png";
import hrOperationsDark from "../../public/images/HRMS/hrms app-operations-darkmode.png";
import MainHeader from "@/components/MainHeader";

const HrHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  // Animated HR headings
  const hrHeadings = [
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Smarter
          </span>{" "}
          HR for
        </>
      ),
      line2: "Modern Teams" 
    },
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Hire
          </span>
          ,{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Manage
          </span>
          ,
        </>
      ),
      line2: "Grow Effortlessly" 
    },
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            People-First
          </span>
        </>
      ),
      line2: "HR Platform" 
    },
  ];

  const [currentHRTextIndex, setCurrentHRTextIndex] = useState(0);

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentHRTextIndex((prev) => (prev + 1) % hrHeadings.length);
    }, 3000);
    return () => clearInterval(interval);
  }, [hrHeadings.length]);

  const tabFeatures = [
    {
      id: "home",
      label: "Home",
      icon: <BsGridFill className="w-4 h-4" />,
      lightImage: hrDashboardDay,
      darkImage: hrDashboardDark,
    },
    {
      id: "onboarding",
      label: "Onboarding",
      icon: <PiHandshakeFill className="w-4 h-4" />,
      lightImage: hrRecruitDocsDay,
      darkImage: hrRecruitDocsDark,
    },
    {
      id: "recruiter",
      label: "Recruiter",
      icon: <IoBriefcaseOutline className="w-4 h-4" />,
      lightImage: hrJobListingsDay,
      darkImage: hrJobListingsDark,
    },
    {
      id: "leave-tracker",
      label: "Leave Tracker",
      icon: <FaUmbrellaBeach className="w-4 h-4" />,
      lightImage: hrLeaveDay,
      darkImage: hrLeaveDark,
    },
    {
      id: "time-tracker",
      label: "Time Tracker",
      icon: <IoMdAlarm className="w-4 h-4" />,
      lightImage: hrShiftsDay,
      darkImage: hrShiftsDark,
    },
    {
      id: "announcement",
      label: "Announcement",
      icon: <HiOutlineSpeakerWave className="w-4 h-4" />,
      lightImage: hrNotifyDay,
      darkImage: hrNotifyDark,
    },
    {
      id: "staff",
      label: "Staff",
      icon: <Users className="w-4 h-4" />,
      lightImage: hrOrgListDay,
      darkImage: hrOrgListDark,
    },
    {
      id: "attendance",
      label: "Attendance",
      icon: <FaIdCard className="w-4 h-4" />,
      lightImage: hrShiftsDay,
      darkImage: hrShiftsDark,
    },
    {
      id: "schedule",
      label: "Schedule",
      icon: <IoCalendarOutline className="w-4 h-4" />,
      lightImage: hrShiftsDay,
      darkImage: hrShiftsDark,
    },
    {
      id: "payroll",
      label: "Payroll",
      icon: <TbCreditCard className="w-4 h-4" />,
      lightImage: hrOperationsDay,
      darkImage: hrOperationsDark,
    },
    {
      id: "operations",
      label: "Operations",
      icon: <MdDataSaverOff className="w-4 h-4" />,
      lightImage: hrOperationsDay,
      darkImage: hrOperationsDark,
    },
    {
      id: "performance",
      label: "Performance",
      icon: <MdOutlineBarChart className="w-4 h-4" />,
      lightImage: hrDashboardDay,
      darkImage: hrDashboardDark,
    },
    {
      id: "files",
      label: "Files",
      icon: <PiFiles className="w-4 h-4" />,
      lightImage: hrRecruitDocsDay,
      darkImage: hrRecruitDocsDark,
    },
    {
      id: "hr-letters",
      label: "HR Letters",
      icon: <HiOutlineDocumentText className="w-4 h-4" />,
      lightImage: hrRecruitDocsDay,
      darkImage: hrRecruitDocsDark,
    },
    {
      id: "travel",
      label: "Travel",
      icon: <MdOutlineFlightTakeoff className="w-4 h-4" />,
      lightImage: hrOperationsDay,
      darkImage: hrOperationsDark,
    },
    {
      id: "tasks",
      label: "Tasks",
      icon: <MdOutlineTask className="w-4 h-4" />,
      lightImage: hrDashboardDay,
      darkImage: hrDashboardDark,
    },
  ];

  const features1 = [
    {
      icon: (
        <ClipboardCheckIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Employee Records",
      description: "Centralize personnel data securely in one place.",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Recruitment",
      description: "Streamline hiring with applicant tracking.",
    },
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Onboarding",
      description: "Automate new hire processes efficiently.",
    },
    {
      icon: (
        <SparklesIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "AI Assistance",
      description: "Smart recommendations for HR decisions.",
    },
  ];
  const features2 = [
    {
      icon: (
        <LayoutDashboardIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Performance Reviews",
      description: "Conduct structured employee evaluations.",
    },
    {
      icon: <BrainIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "HR Analytics",
      description: "Data-driven insights for workforce optimization.",
    },
    {
      icon: (
        <BarChart2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Compliance",
      description: "Track regulatory requirements effortlessly.",
    },
    {
      icon: (
        <KanbanIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Workflows",
      description: "Automate approvals and HR processes.",
    },
  ];

  const features3 = [
    {
      icon: <BugIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Time Tracking",
      description: "Monitor attendance and working hours.",
    },
    {
      icon: (
        <AlertTriangleIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Leave Management",
      description: "Handle PTO requests and approvals.",
    },
    {
      icon: (
        <SearchIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Candidate Search",
      description: "Find talent with AI-powered matching.",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Payroll Integration",
      description: "Sync with payroll systems seamlessly.",
    },
  ];

  const features4 = [
    {
      icon: (
        <Settings2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Custom Workflows",
      description: "Tailor HR processes to your needs.",
    },
    {
      icon: (
        <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Reporting",
      description: "Generate custom HR analytics reports.",
    },
    {
      icon: <ClockIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Scheduling",
      description: "Manage employee shifts and rotations.",
    },
    {
      icon: (
        <FileBarChartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Employee Engagement",
      description: "Measure and improve satisfaction.",
    },
  ];
  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "Wurknest has completely transformed how we manage our workforce. The seamless interface and robust capabilities save us countless hours each week. Our HR productivity has jumped 45% since going live. A must-have for today's HR professionals.",
      name: "Olivia Bennett",
      title: "HR Director at VisionTrack",
      date: "Jul 5, 2025",
      logo: user5,
    },
    {
      text: "Our onboarding cycle is now 60% shorter thanks to Wurknest's intelligent automation. Candidate tracking and file organization keep us on point. Remote workforce management has never been easier for our team.",
      name: "Ethan Roberts",
      title: "Talent Manager at ApexFlow",
      date: "Jun 20, 2025",
      logo: user6,
    },
    {
      text: "Wurknest simplifies HR tasks remarkably. We now dedicate less energy to admin work and more to people strategy. The compliance monitoring and analytics deliver critical insights we can truly count on.",
      name: "Maya Chen",
      title: "Head of People at NextWave",
      date: "May 30, 2025",
      logo: user7,
    },
    {
      text: "With Wurknest, our new hire integration is smooth and standardized. Smart automation guarantees regulatory adherence and task completion. Fresh talent joins feeling supported and equipped right from the start.",
      name: "Lucas Grant",
      title: "HR Manager at GrowthEdge",
      date: "Apr 18, 2025",
      logo: user8,
    },
    {
      text: "Since implementing Wurknest, we handle workforce challenges twice as quickly. Our unified personnel system and intelligence tools generate meaningful, actionable data. It's revolutionized how employees engage with us.",
      name: "Sofia Ramirez",
      title: "People Ops Director at BuildSphere",
      date: "Mar 8, 2025",
      logo: user9,
    },
  ];


  const [isAnnual, setIsAnnual] = useState(true);

  const monthlyPlans = [
    {
      name: "Private",
      description: "HR Essentials\nPerfect For Small Businesses",
      price: "$2",
      pricePeriod: "per month",
      buttonText: "Start With Private",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: false,
    },
    {
      name: "Business",
      description: "Advanced HR\nBest For Growing Companies",
      price: "$3.5",
      pricePeriod: "per month",
      buttonText: "Start With Business",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Complete HR Suite\nAll-in-one Solution",
      price: "$5",
      pricePeriod: "per month",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: LayersIcon, text: "", subtext: "All Previous Plan Features" },
        {
          icon: GlobeIcon,
          text: "",
          subtext: "Access to All Clikkle Products",
        },
        {
          icon: FileBarChartIcon,
          text: "",
          subtext: "Custom Reports & Analytics",
        },
        { icon: Bell, text: "", subtext: "Real-time Notifications" },
        { icon: DatabaseIcon, text: "", subtext: "Document Management" },
        { icon: PaletteIcon, text: "", subtext: "Mobile App Access" },
        { icon: TimerIcon, text: "", subtext: "Automated Payroll" },
        { icon: UserCogIcon, text: "", subtext: "Employee Self-Service" },
        { icon: BrainIcon, text: "", subtext: "AI Candidate Matching" },
        { icon: ProjectorIcon, text: "", subtext: "Video Interviewing" },
        { icon: KanbanIcon, text: "", subtext: "Project Management Tools" },
      ],
      highlighted: false,
    },
  ];

  const annualPlans = [
    {
      name: "Private",
      description: "HR Essentials\nPerfect For Small Businesses",
      price: "$20",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Private",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: false,
    },
    {
      name: "Business",
      description: "Advanced HR\nBest For Growing Companies",
      price: "$35",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Business",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Complete HR Suite\nAll-in-one Solution",
      price: "$50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: LayersIcon, text: "", subtext: "All Previous Plan Features" },
        {
          icon: GlobeIcon,
          text: "",
          subtext: "Access to All Clikkle Products",
        },
        {
          icon: FileBarChartIcon,
          text: "",
          subtext: "Custom Reports & Analytics",
        },
        { icon: Bell, text: "", subtext: "Real-time Notifications" },
        { icon: DatabaseIcon, text: "", subtext: "Document Management" },
        { icon: PaletteIcon, text: "", subtext: "Mobile App Access" },
        { icon: TimerIcon, text: "", subtext: "Automated Payroll" },
        { icon: UserCogIcon, text: "", subtext: "Employee Self-Service" },
        { icon: BrainIcon, text: "", subtext: "AI Candidate Matching" },
        { icon: ProjectorIcon, text: "", subtext: "Video Interviewing" },
        { icon: KanbanIcon, text: "", subtext: "Project Management Tools" },
      ],
      highlighted: false,
    },
  ];

  const faqs = [
    {
      question: "What's the process for setting up HR software?",
      answer: `Setup is straightforward! Register for a complimentary account to unlock our comprehensive implementation resources and training materials. Our dedicated support specialists are ready to assist with workflow configuration and onboarding.`,
    },
    {
      question: "Does it connect with payroll platforms?",
      answer:
        "Absolutely! Wurknest connects effortlessly with leading payroll solutions. Our intelligent synchronization guarantees precise information exchange between HR and payroll, minimizing data entry mistakes.",
    },
    {
      question: "What security measures protect employee information?",
      answer:
        "Security is our top priority with bank-level encryption, routine security assessments, and industry certifications. Personnel data is safeguarded through robust access management and granular permissions.",
    },
    {
      question: "Are HR workflows customizable?",
      answer:
        "Definitely! Our system provides extensive customization options for approval chains, employee onboarding paths, performance evaluations, and beyond. Configure workflows to align perfectly with your organization's needs.",
    },
    {
      question: "Can I use it on mobile devices?",
      answer:
        "Yes! Our mobile application delivers complete HR capabilities for staff and leadership. View pay stubs, submit leave requests, process approvals, and oversee your team on the go.",
    },
  ];

  const isDarkMode = theme === "dark";

  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://hr.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#0B0C0E] flex flex-col items-center w-full min-h-screen overflow-x-hidden">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader/>
            </div>

            <HeroSection
              announcementOpen={false}
              badge={{
                text: "Smart HR Management Platform",
                showPulse: true,
              }}
              title={{
                beforeHighlight: "Hire, manage, and grow your",
                highlight: "dream team",
                afterHighlight: "",
              }}
              description={{
                desktop: (
                  <>
                <div className="mb-2">
                  Streamline <span className="font-semibold text-gray-900 dark:text-white">hiring, onboarding, and workforce management</span>.
                </div>
                <div>
                  Built for modern HR teams <span className="font-semibold text-gray-900 dark:text-white">who move fast.</span>
                </div>
              </>
                ),
                mobile: (
                  <>
                    <span className="font-semibold text-gray-900 dark:text-white">HR management</span> built for modern teams.
                  </>
                ),
              }}
              cta={{
                primary: {
                  text: "Start Free →",
                  onClick: () => {
                    window.location.replace(
                      "https://hr.clikkle.com/signup?theme=" + theme
                    );
                  },
                },
                secondary: {
                  text: "Explore Features",
                  href: "#features",
                },
              }}
              trustIndicators={[
                { text: "No credit card" },
                { text: "9K+ reviews" },
                { text: "GDPR compliant" },
              ]}
            />

            <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full md:w-auto">
              <div className="relative w-full flex justify-center mb-5">
                <TabbedFeature
                  tabs={tabFeatures}
                  decorator={
                    <Image
                      src={popImg}
                      alt="popImg"
                      className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px] z-10 "
                      width={120}
                      height={120}
                    />
                  }
                />
              </div>
            </div>
          </section>
        </section>

        <section className="">
          <WhyProductSection
            badge="Why Wurknest HR?"
            heading="Transform Your HR Operations"
            subheading="Why waste time on manual HR tasks? Wurknest HR isn't just employee management; it's a complete workforce platform designed to accelerate hiring, streamline operations, and boost employee satisfaction."
            mainFeature={{
              badge: "Complete HR Platform",
              icon: SparklesIcon,
              title: "From Hiring to Retention in One Platform",
              description: "Manage your entire employee lifecycle with automated workflows, comprehensive analytics, and compliance tools that work 24/7.",
              image: hrDashboardDay,
              miniFeatures: [
                {
                  title: "Smart Recruitment",
                  description: "AI-powered hiring",
                },
                {
                  title: "Performance Tracking",
                  description: "Real-time insights",
                },
                {
                  title: "Leave Management",
                  description: "Automated approvals",
                },
                {
                  title: "Compliance Ready",
                  description: "GDPR & labor laws",
                },
              ],
            }}
            featureCards={[
              {
                icon: CalendarDays,
                title: "Streamlined Recruitment",
                description: "Post job listings, track applicants, schedule interviews, and onboard new hires all from a single dashboard.",
              },
              {
                icon: Users,
                title: "Centralized Employee Data",
                description: "Access complete employee records, documents, performance reviews, and attendance with bank-level security.",
              },
              {
                icon: LayoutDashboardIcon,
                title: "Performance Management",
                description: "Set goals, conduct reviews, and track employee development with customizable performance metrics.",
              },
              {
                icon: Workflow,
                title: "Workflow Automation",
                description: "Automate leave requests, approvals, payroll processing, and compliance reporting to save hours every week.",
              },
            ]}
          />
        </section>

          <section className="w-full">
            <section
              className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
              id="features3-3"
            >
              <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
                <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                  <FeatureSection
                    title="Accelerate Every HR Workflow with Smart Automation"
                    showIcon={true}
                    description="Wurknest HR eliminates manual tasks through intelligent automation, driving efficiency and ensuring regulatory compliance across your organization."
                    features={[
                      {
                        icon: <ClipboardCheckIcon className="w-6 h-6" />,
                        title: "Personnel Database",
                        description: "Secure centralized storage for all employee information.",
                      },
                      {
                        icon: <UsersIcon className="w-6 h-6" />,
                        title: "Hiring Pipeline",
                        description: "End-to-end applicant tracking and management system.",
                      },
                      {
                        icon: <FileTextIcon className="w-6 h-6" />,
                        title: "Digital Onboarding",
                        description: "Seamless automated processes for new team members.",
                      },
                      {
                        icon: <SparklesIcon className="w-6 h-6" />,
                        title: "Intelligent Insights",
                        description: "AI-driven recommendations for strategic HR decisions.",
                      },
                    ]}
                    cta1={{
                      label: "Learn More",
                      onClick: () => {
                        window.location.href = "/hr#features";
                      },
                      className:
                        "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-2 border-gray-200 dark:border-white/20 hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                    }}
                    cta2={{
                      label: "Start Free Trial",
                      mobileLabel: "Try Now",
                      onClick: () => {
                        window.location.replace(
                          "https://hr.clikkle.com/signup?theme=" + theme
                        );
                      },
                      className:
                        "px-2 py-2 md:px-6 md:py-3 bg-[#25272c] dark:bg-black hover:bg-black dark:hover:bg-gray-900 text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                    }}
                    quote={{
                      text: "Organizing personnel files has become seamless, freeing up countless hours for our entire HR department!",
                      userImg: user1,
                      userName: "Sarah K.",
                      userRole: "HR Manager",
                    }}
                    theme={theme}
                  />
                  <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none gap-[8rem] justify-self-end">
                    <div className="absolute w-[280px] sm:w-[380px] h-[280px] sm:h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                    <HRAnimationPanel />
                  </div>
                </div>
              </div>
            </section>
          </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-14">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[280px] sm:w-[380px] h-[280px] sm:h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <div className="relative w-full h-full max-w-[450px] max-h-[400px]">
                    <Image
                      src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800&auto=format&fit=crop&q=80"
                      alt="HR Analytics and Data Insights"
                      className="w-full h-full object-cover rounded-2xl shadow-2xl border-2 border-gray-200 dark:border-gray-700"
                      width={450}
                      height={400}
                      unoptimized
                    />
                  </div>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-start">
                  <FeatureSection
                    title="Transform workforce data into strategic insights"
                    
                    showIcon={true}
                    description="Unlock powerful HR analytics to drive better decisions on workforce planning, talent retention, and performance outcomes."
                    features={features2}
                    cta1={{
                      label: "Learn More",
                      onClick: () => {
                        window.scrollTo({ top: 0, behavior: "smooth" });
                      },
                      className:
                        "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-2 border-gray-200 dark:border-white/20 hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                    }}
                    cta2={{
                      label: "Get Started",
                      mobileLabel: "Get Started",
                      onClick: () => {
                        window.location.replace(
                          "https://hr.clikkle.com/signup?theme=" + theme
                        );
                      },
                      className:
                        "px-2 py-2 md:px-6 md:py-3 bg-[#25272c] dark:bg-black hover:bg-black dark:hover:bg-gray-900 text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                    }}
                    quote={{
                      text: "Our HR analytics have never been more insightful and actionable.",
                      userImg: user3,
                      userName: "James L.",
                      userRole: "HR Analyst",
                    }}
                    theme={theme}
                  />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <FeatureSection
                  title="Go paperless with digital employee management"
                  
                  showIcon={true}
                  description="Transform your HR operations with comprehensive digital talent management that streamlines every stage of the employee lifecycle."
                  features={features3}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.scrollTo({ top: 0, behavior: "smooth" });
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-2 border-gray-200 dark:border-white/20 hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                  }}
                  cta2={{
                    label: "Get Started",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://hr.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-[#25272c] dark:bg-black hover:bg-black dark:hover:bg-gray-900 text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                  }}
                  quote={{
                    text: "Our recruitment process is 50% faster with Clikkle's ATS!",
                    userImg: someee,
                    userName: "Michael T.",
                    userRole: "Talent Acquisition",
                  }}
                  theme={theme}
                />
                <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none gap-[8rem] justify-self-end">
                  <DigitalHRAnimationPanel />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-14">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[280px] sm:w-[380px] h-[280px] sm:h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <div className="relative w-full h-full max-w-[450px] max-h-[400px]">
                    <Image
                      src="https://images.pexels.com/photos/2041627/pexels-photo-2041627.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1"
                      alt="Team Collaboration and HR Management"
                      className="w-full h-full object-cover rounded-2xl shadow-2xl border-2 border-gray-200 dark:border-gray-700"
                      width={450}
                      height={400}
                      unoptimized
                    />
                  </div>
                </div>
                <FeatureSection
                  title="Empower teams with seamless HR tools"
                 
                  showIcon={true}
                  description="Enable employee self-service capabilities while providing HR teams with powerful administrative features for efficient management."
                  features={features4}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.scrollTo({ top: 0, behavior: "smooth" });
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-2 border-gray-200 dark:border-white/20 hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                  }}
                  cta2={{
                    label: "Get Started",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://hr.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-[#25272c] dark:bg-black hover:bg-black dark:hover:bg-gray-900 text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                  }}
                  quote={{
                    text: "Employee self-service has dramatically reduced HR inquiries.",
                    userImg: user4,
                    userName: "David R.",
                    userRole: "HR Operations",
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <AppsSection headingPrefix="Profit from streamlined HR operations" />
        </section>

        <TestimonialSection
          testimonials={testimonials}
          title="See What Our HR Leaders Are Saying"
        />

        <PricingSection
          title="HR Plans & Pricing"
          subtitle='Get started with our <span class="font-semibold">comprehensive HR solution</span> and scale as you grow.'
          monthlyPlans={monthlyPlans}
          annualPlans={annualPlans}
          onPlanSelect={(planName, cycle) => {
            window.location.href = `https://hr.clikkle.com/signup?plan=${planName.toLowerCase()}&cycle=${cycle}&theme=${theme}`;
          }}
          contactSalesUrl="/contact"
        />

        <FAQSection
          faqs={faqs}
          title="Frequently Asked Questions"
          subtitle="Our friendly team would love to answer your questions."
        />
        <SecuritySection />
        <PreFooterCTA
          badge="HR PLATFORM"
          mobileHeadline="Revolutionize Your HR Operations"
          desktopHeadline={`Revolutionize Your <span class="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">Workforce</span> Management`}
          description="Streamline HR processes, elevate team engagement, and unlock powerful insights with our comprehensive people management solution"
          buttonText="Start Free Today"
          buttonUrl={`https://hr.clikkle.com/signup?theme=${theme}`}
          userImages={[user1, user3, user4, user5]}
          userCount="10,000+ HR teams"
          rating="4.9/5"
          theme={theme}
        />
      </div>
      <Footer
        footerText="Transform your HR operations with our modern platform. Comprehensive solutions for every organization."
        darkLogo={
          "https://cdn.clikkle.com/images/hr/logo/2025/Clikkle%20HR%20Blue%20(%20White%20Text).png"
        }
        lightLogo={
          "https://cdn.clikkle.com/images/hr/logo/2025/Clikkle%20HR%20Blue%20(%20Black%20Text).png"
        }
        footerName={"Hr"}
        isWorksuite={false}
        isClikkle={false}
      />

      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default HrHome;
