"use client";
import Link from "next/link";
import Image from "next/image";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import { motion, AnimatePresence } from "framer-motion";
import {
  ClockIcon,
  DatabaseIcon,
  FileTextIcon,
  GlobeIcon,
  HeadphonesIcon,
  KeyIcon,
  LayersIcon,
  PaletteIcon,
  SearchIcon,
  SendIcon,
  Settings2Icon,
  ShieldCheckIcon,
  TimerIcon,
  UserCogIcon,
  UserIcon,
  ArrowDown,
  SparklesIcon,
  CheckCircle2,
  FolderIcon,
  LockIcon,
} from "lucide-react";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import { BarChart3Icon, RefreshCwIcon, UsersIcon } from "lucide-react";
import { useTheme } from "../atoms/theme";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/user23.jpeg";
import wsj from "../../public/images/peoplefirst.jpg";
import AppsSection from "../components/appsSection";
import HeroSection from "@/components/HeroSection";
import { footerColumns } from "../constants/footerText";
import TestimonialSection from "../components/TestimonialSection";
import user2 from "../../public/images/user2.jpeg";
import user5 from "../../public/images/user5.jpeg";
import user23 from "../../public/images/user23.jpeg";
import user6 from "../../public/images/user6.jpeg";
import user9 from "../../public/images/user9.jpeg";
import user7 from "../../public/images/user7.jpeg";
import user11 from "../../public/images/user11.jpeg";
import someee from "../../public/images/someee.jpeg";
import filesdark from "../../public/images/filesdark.png";
import fileslight from "../../public/images/fileslight.png";
import MainHeader from "@/components/MainHeader";
import FilesAnimationPanel from "@/components/FilesAnimationPanel";
import FileSearchAnimationPanel from "@/components/FileSearchAnimationPanel";
import FeatureSection from "@/components/FeatureSection";
import FAQSection from "@/components/FAQSection";
import Footer from "@/components/Footer";
import PricingSection from "@/components/PricingSection";
import SecuritySection from "@/components/SecuritySection";

const FilesHome: React.FC = () => {
  const { theme } = useTheme();
  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);
  const [currentTextIndex, setCurrentTextIndex] = useState(0);
  const [currentTestimonial, setCurrentTestimonial] = useState(0);
  const [touchStart, setTouchStart] = useState(0);
  const [touchEnd, setTouchEnd] = useState(0);

  // Animated headings for hero section
  const headings = [
    {
      line1: <>Store, Share, and</>,
      line2: (
        <>
          Collaborate{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Securely
          </span>
        </>
      ),
    },
    {
      line1: (
        <>
          Enterprise-Grade{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            File Storage
          </span>
        </>
      ),
      line2: <>Made Simple</>,
    },
    {
      line1: (
        <>
          Access Your{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Files
          </span>
        </>
      ),
      line2: <>Anywhere, Anytime</>,
    },
  ];

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentTextIndex((prev) => (prev + 1) % headings.length);
    }, 4000);
    return () => clearInterval(interval);
  }, [headings.length]);

  const features1 = [
    {
      icon: (
        <ShieldCheckIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "AES-256 Encryption",
      description: "Military-grade protection for files in transit and at rest.",
    },
    {
      icon: (
        <DatabaseIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Auto Versioning",
      description: "Track changes with automatic file version history.",
    },
    {
      icon: <GlobeIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Zero-Knowledge",
      description: "End-to-end encryption ensures only you access your data.",
    },
    {
      icon: (
        <RefreshCwIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Compliance Ready",
      description: "GDPR, HIPAA, and SOC 2 compliant infrastructure.",
    },
  ];

  const features2 = [
    {
      icon: (
        <LayersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Unlimited Growth",
      description: "Scale from 1GB to petabytes without migration hassles.",
    },
    {
      icon: (
        <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Smart Analytics",
      description: "Real-time insights into storage usage and file activity.",
    },
    {
      icon: (
        <UserCogIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Team Workspace",
      description: "Organize teams with custom roles and permissions.",
    },
    {
      icon: (
        <PaletteIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "White-Label Ready",
      description: "Brand the platform with your logo and colors.",
    },
  ];

  const features3 = [
    {
      icon: (
        <SearchIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "AI-Powered Search",
      description: "Natural language queries find any file in milliseconds.",
    },
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Instant Preview",
      description: "View 100+ file formats without downloading.",
    },
    {
      icon: <SendIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Secure Sharing",
      description: "Password-protected links with custom expiration.",
    },
    {
      icon: <ClockIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Activity Tracking",
      description: "Complete audit trail of all file interactions.",
    },
  ];

  const features4 = [
    {
      icon: <KeyIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Multi-Factor Auth",
      description: "Biometric and SMS verification for maximum security.",
    },
    {
      icon: (
        <Settings2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Role-Based Access",
      description: "Define precise permissions for each team member.",
    },
    {
      icon: <TimerIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Auto-Expiry Links",
      description: "Time-bound sharing with automatic revocation.",
    },
    {
      icon: (
        <HeadphonesIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Priority Support",
      description: "Expert help available around the clock, 365 days.",
    },
  ];


  const testimonials = [
    {
      text: "Clikkle Files revolutionized our document management. We've reduced file retrieval time by 70% and improved team collaboration significantly. Essential for modern businesses.",
      name: "Olivia Bennett",
      title: "IT Director at VisionTrack",
      date: "Jul 5, 2025",
      logo: user6,
      recommendNote: "Highly recommended for secure storage",
    },
    {
      text: "We've saved 15 hours weekly on file management since switching. The security features give us peace of mind for sensitive documents. A must-have for distributed teams.",
      name: "Ethan Roberts",
      title: "CTO at ApexFlow",
      date: "Jun 20, 2025",
      logo: user7,
      recommendNote: "Perfect for enterprise document management",
    },
    {
      text: "Our team collaboration improved dramatically with Clikkle Files. Version control and access management features have eliminated document chaos completely.",
      name: "Maya Chen",
      title: "Operations Director at NextWave",
      date: "May 30, 2025",
      logo: user2,
      recommendNote: "Game-changer for remote teams",
    },
    {
      text: "The security compliance features alone are worth the investment. We passed our annual audit with zero findings thanks to Clikkle's encryption and access logs.",
      name: "Lucas Grant",
      title: "Security Officer at GrowthEdge",
      date: "Apr 18, 2025",
      logo: user5,
      recommendNote: "Ideal for regulated industries",
    },
    {
      text: "Sharing large project files with clients is now effortless. The customizable branding makes our company look professional during file transfers.",
      name: "Sofia Ramirez",
      title: "Creative Director at BuildSphere",
      date: "Mar 8, 2025",
      logo: user9,
      recommendNote: "Best for client-facing teams",
    },
  ];


  const [isAnnual, setIsAnnual] = useState(true);

  const monthlyPlans = [
    {
      name: "Pro",
      description: "Perfect For Individuals\nAnd Small Teams",
      price: "$2",
      pricePeriod: "per month",
      buttonText: "Start With Pro",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UserIcon, text: "", subtext: "1 User Included" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: DatabaseIcon, text: "", subtext: "250 GB Storage" },
        { icon: SendIcon, text: "", subtext: "250 GB Transfer Limit" },
        { icon: GlobeIcon, text: "", subtext: "Unlimited Transfers" },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
        { icon: HeadphonesIcon, text: "", subtext: "Priority Support" },
      ],
      highlighted: false,
    },
    {
      name: "Team",
      description: "Best For Business Teams\nCollaborative Storage",
      price: "$3.5",
      pricePeriod: "per month",
      buttonText: "Start With Team",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: UsersIcon, text: "", subtext: "10 Users Included" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Pro Features" },
        { icon: DatabaseIcon, text: "", subtext: "1 TB Storage" },
        { icon: SendIcon, text: "", subtext: "500 GB Transfer Limit" },
        { icon: GlobeIcon, text: "", subtext: "Unlimited Transfers" },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Support" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "For Large Organizations\nCustom Solutions",
      price: "$5",
      pricePeriod: "per month",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UsersIcon, text: "", subtext: "10+ Users" },
        { icon: LayersIcon, text: "", subtext: "All Team Features" },
        { icon: DatabaseIcon, text: "", subtext: "5 TB Storage" },
        { icon: SendIcon, text: "", subtext: "Custom Transfer Limits" },
        { icon: KeyIcon, text: "", subtext: "Single Sign-On (SSO)" },
        { icon: GlobeIcon, text: "", subtext: "Custom Domain" },
        { icon: HeadphonesIcon, text: "", subtext: "Dedicated Manager" },
      ],
      highlighted: false,
    },
  ];

  const annualPlans = [
    {
      name: "Pro",
      description: "Perfect For Individuals\nAnd Small Teams",
      price: "$20",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Pro",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UserIcon, text: "", subtext: "1 User Included" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: DatabaseIcon, text: "", subtext: "250 GB Storage" },
        { icon: SendIcon, text: "", subtext: "250 GB Transfer Limit" },
        { icon: GlobeIcon, text: "", subtext: "Unlimited Transfers" },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
        { icon: HeadphonesIcon, text: "", subtext: "Priority Support" },
      ],
      highlighted: false,
    },
    {
      name: "Team",
      description: "Best For Business Teams\nCollaborative Storage",
      price: "$35",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Team",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: UsersIcon, text: "", subtext: "10 Users Included" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Pro Features" },
        { icon: DatabaseIcon, text: "", subtext: "1 TB Storage" },
        { icon: SendIcon, text: "", subtext: "500 GB Transfer Limit" },
        { icon: GlobeIcon, text: "", subtext: "Unlimited Transfers" },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Support" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "For Large Organizations\nCustom Solutions",
      price: "$50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UsersIcon, text: "", subtext: "10+ Users" },
        { icon: LayersIcon, text: "", subtext: "All Team Features" },
        { icon: DatabaseIcon, text: "", subtext: "5 TB Storage" },
        { icon: SendIcon, text: "", subtext: "Custom Transfer Limits" },
        { icon: KeyIcon, text: "", subtext: "Single Sign-On (SSO)" },
        { icon: GlobeIcon, text: "", subtext: "Custom Domain" },
        { icon: HeadphonesIcon, text: "", subtext: "Dedicated Manager" },
      ],
      highlighted: false,
    },
  ];

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);
  const faqs = [
    {
      question: "What security measures protect my stored files?",
      answer: `Every file is secured using AES-256 encryption during transfer and while stored. We conduct routine security assessments and provide two-factor authentication for additional security.`,
    },
    {
      question: "Is offline file access supported?",
      answer:
        "Absolutely! Our desktop application lets you designate files for offline use. Any modifications synchronize instantly once you're back online.",
    },
    {
      question: "Are there restrictions on file sizes?",
      answer:
        "Pro tier accommodates files up to 250GB each, Team tier up to 500GB, and Enterprise provides flexible limits. Total storage is unlimited within your plan's capacity.",
    },
    {
      question: "What's the file versioning policy?",
      answer:
        "We automatically preserve 180 days of version records for every file. You can revert to earlier versions or export complete revision logs whenever needed.",
    },
    {
      question: "Do you offer mobile applications?",
      answer:
        "Yes, our iOS and Android applications provide complete features including file uploads, link sharing, and offline access functionality.",
    },
  ];

  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://files.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  return (
    <div className="bg-white dark:bg-[#0B0C0E] flex flex-col items-center w-full min-h-screen overflow-x-hidden">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <MainHeader />

            <HeroSection
              announcementOpen={false}
              badge={{
                text: "Secure Cloud File Management",
                showPulse: true,
              }}
              title={{
                beforeHighlight: "Store, share, and access files",
                highlight: "from anywhere",
                afterHighlight: "",
              }}
              description={{
                desktop: (
                  <>
                    <span className="font-semibold text-gray-900 dark:text-white">Enterprise-grade file storage</span> and management made simple. Access your files <span className="font-semibold text-gray-900 dark:text-white">anywhere, anytime </span>with zero hassle . 
                  </>
                ),
                mobile: (
                  <>
                    <span className="font-semibold text-gray-900 dark:text-white">Secure storage</span> with easy access anywhere.
                  </>
                ),
              }}
              cta={{
                primary: {
                  text: "Start Free →",
                  onClick: () => {
                    window.location.replace(
                      "https://files.clikkle.com/signup?theme=" + theme
                    );
                  },
                },
                secondary: {
                  text: "Explore Features",
                  href: "#features",
                },
              }}
              trustIndicators={[
                { text: "No credit card" },
                { text: "Unlimited storage" },
                { text: "Cancel anytime" },
              ]}
            />

            {/* Dashboard Preview - Simplified */}
            <div className="relative w-full max-w-[1233px] mx-auto opacity-50 blur-[2px] mb-6 sm:mb-8 px-4 sm:px-0">
              <Image
                src={theme === "dark" ? filesdark : fileslight}
                alt="Files Dashboard"
                className="w-full h-auto rounded-lg shadow-2xl mb-20"
                priority
              />
            </div>
          </section>
        </section>
        <section className="w-full max-w-[1233px] text-gray-900 dark:text-white py-8 sm:py-12 md:py-16 px-4 md:px-0 lg:py-0 m-auto">
          <div className="w-full">
            <div className="max-w-[1233px] mx-auto px-0">
              <div className="flex flex-col items-center justify-center">
                {/* Header Section */}
                <div className="w-full mb-8 sm:mb-12 md:mb-16 text-center">
                  <div className="flex items-center justify-center gap-3 mb-6">
                    <span className="text-[#253237] dark:text-white font-semibold tracking-wider uppercase text-sm bg-[#090241]/10 dark:bg-[#16171B] px-4 py-2 rounded-full">
                      Why wurknest Files?
                    </span>
                  </div>
                  <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl xl:text-6xl font-bold text-[#253237] dark:text-white mb-4 md:mb-6 leading-tight">
                    Secure File Management That Scales
                  </h2>
                  <p className="text-[#3D3D3D] dark:text-[#94A3B8] text-sm sm:text-base md:text-lg lg:text-xl max-w-3xl mx-auto leading-relaxed">
                    Why settle for basic storage? wurknest Files isn&apos;t just cloud storage; it&apos;s a complete file management solution designed to protect and empower your team.
                  </p>
                </div>

                {/* Main Feature Card */}
                <div className="bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 sm:p-6 md:p-8 lg:p-12 max-w-[1233px] w-full shadow-lg mb-8 md:mb-12">
                  <div className="flex flex-col lg:flex-row gap-6 md:gap-8 lg:gap-12 items-center">
                    {/* Image Side */}
                    <div className="w-full lg:w-1/2">
                      <div className="relative rounded-xl overflow-hidden shadow-xl">
                        <img
                          src="https://images.unsplash.com/photo-1544197150-b99a580bb7a8?w=800&h=600&fit=crop"
                          alt="Secure File Management"
                          className="w-full h-full object-cover"
                        />
                      </div>
                    </div>

                    {/* Content Side */}
                    <div className="w-full lg:w-1/2 space-y-4 md:space-y-6 lg:space-y-8">
                      <div>
                        <div className="inline-flex items-center gap-2 bg-[#25272c] dark:bg-white text-white dark:text-black px-3 py-1.5 md:px-4 md:py-2 rounded-full text-xs md:text-sm font-semibold mb-3 md:mb-4">
                          <SparklesIcon className="w-4 h-4" />
                          Enterprise-Grade Security
                        </div>
                        <h3 className="text-xl sm:text-2xl md:text-3xl lg:text-4xl font-bold text-[#253237] dark:text-white mb-3 md:mb-4">
                          From Upload to Download, Fully Protected
                        </h3>
                        <p className="text-[#3D3D3D] dark:text-[#94A3B8] text-sm sm:text-base md:text-lg leading-relaxed">
                          Store confidently with military-grade encryption, automatic backups, and granular access controls that work 24/7.
                        </p>
                      </div>

                      <div className="grid grid-cols-2 gap-2 sm:gap-3 md:gap-4">
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">End-to-End Encrypted</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">AES-256 security</p>
                          </div>
                        </div>
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">Auto Backup</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">Version history</p>
                          </div>
                        </div>
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">Access Control</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">Granular permissions</p>
                          </div>
                        </div>
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">Compliance</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">GDPR & SOC2</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                {/* Feature Grid */}
                <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-3 sm:gap-4 md:gap-6 max-w-7xl w-full mb-8 md:mb-12">
                  {/* Feature Card 1 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <FolderIcon className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Smart Organization</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        AI-powered tagging, smart folders, and instant search make finding files effortless, no matter how large your library grows.
                      </p>
                    </div>
                  </div>

                  {/* Feature Card 2 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <GlobeIcon className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Anywhere Access</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        Access your files from any device, anywhere in the world. Seamless sync across desktop, mobile, and web platforms.
                      </p>
                    </div>
                  </div>

                  {/* Feature Card 3 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <UsersIcon className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Team Collaboration</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        Real-time collaboration, shared folders, and comment threads keep your team aligned and productive.
                      </p>
                    </div>
                  </div>

                  {/* Feature Card 4 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <LockIcon className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Advanced Security</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        Two-factor authentication, link expiry, and audit logs ensure your sensitive files stay protected at all times.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 py-20 relative overflow-hidden bg-transparent"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <div className="order-2 lg:order-1">
                  <FeatureSection
                    showIcon={false}
                    title="Bank-level security that protects every file you store"
                    description="Rest easy knowing your files are protected with military-grade encryption and enterprise security standards."
                    features={features1}
                    cta1={{
                      label: "Learn More",
                      onClick: () => {
                        window.location.href = "#features";
                      },
                    }}
                    cta2={{
                      label: "Get Started Free",
                      mobileLabel: "Get Started",
                      onClick: () => {
                        window.location.replace(
                          "https://files.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    quote={{
                      text: "Zero-trust security gives us peace of mind. Passed all compliance audits effortlessly!",
                      userImg: user11,
                      userName: "Harper R.",
                      userRole: "Vice President",
                    }}
                    theme={theme}
                  />
                </div>
                <div className="order-1 lg:order-2">
                  <FilesAnimationPanel />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 py-20 relative overflow-hidden bg-transparent"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <div className="order-1 lg:order-1">
                  <div className="relative flex items-center justify-center">
                    <img
                      src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=600&h=500&fit=crop"
                      alt="Storage Analytics Dashboard"
                      className="w-full h-auto rounded-xl shadow-2xl"
                    />
                  </div>
                </div>
                <div className="order-2 lg:order-2">
                  <FeatureSection
                    showIcon={false}
                    title="Storage that grows with your ambitions"
                    description="From startup to enterprise, scale seamlessly without worrying about storage limits or complex migrations."
                    features={features2}
                    cta1={{
                      label: "View Plans",
                      onClick: () => {
                        window.location.href = "#pricing";
                      },
                    }}
                    cta2={{
                      label: "Start Free Trial",
                      mobileLabel: "Try Free",
                      onClick: () => {
                        window.location.replace(
                          "https://files.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    quote={{
                      text: "Scaled storage seamlessly from 10GB to 5TB. Saved 40% compared to competitors!",
                      userImg: user23,
                      userName: "Raj P.",
                      userRole: "CTO",
                    }}
                    theme={theme}
                  />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 py-20 relative overflow-hidden bg-transparent"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <div className="order-2 lg:order-1">
                  <FeatureSection
                    showIcon={false}
                    title="Find any file in seconds, not hours"
                    description="Stop wasting time searching. Our AI-powered search and intuitive organization make file discovery effortless."
                    features={features3}
                    cta1={{
                      label: "See Demo",
                      onClick: () => {
                        window.location.href = "#features";
                      },
                    }}
                    cta2={{
                      label: "Try It Now",
                      mobileLabel: "Try Now",
                      onClick: () => {
                        window.location.replace(
                          "https://files.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    quote={{
                      text: "AI search cut our file retrieval time from 20 minutes to seconds!",
                      userImg: someee,
                      userName: "Emily T.",
                      userRole: "HR Manager",
                    }}
                    theme={theme}
                  />
                </div>
                <div className="order-1 lg:order-2">
                  <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center">
                    <div className="absolute w-[280px] sm:w-[380px] h-[280px] sm:h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                    <FileSearchAnimationPanel />
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 py-20 relative overflow-hidden bg-transparent"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <div className="order-1 lg:order-1">
                  <div className="relative flex items-center justify-center">
                    <img
                      src="https://images.unsplash.com/photo-1563986768494-4dee2763ff3f?w=600&h=500&fit=crop"
                      alt="Advanced Security and Access Control"
                      className="w-full h-auto rounded-xl shadow-2xl"
                    />
                  </div>
                </div>
                <div className="order-2 lg:order-2">
                  <FeatureSection
                    showIcon={false}
                    title="Enterprise security that never sleeps"
                    description="Protect your team with multi-layered security, granular permissions, and round-the-clock expert support."
                    features={features4}
                    cta1={{
                      label: "Security Details",
                      onClick: () => {
                        window.location.href = "#features";
                      },
                    }}
                    cta2={{
                      label: "Get Protected Now",
                      mobileLabel: "Get Protected",
                      onClick: () => {
                        window.location.replace(
                          "https://files.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    quote={{
                      text: "Multi-factor auth reduced our security incidents to zero and lowered insurance premiums by 15%!",
                      userImg: user11,
                      userName: "Harper R.",
                      userRole: "Vice President",
                    }}
                    theme={theme}
                  />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <AppsSection headingPrefix="Profit from instant team communication" />
        </section>

        <TestimonialSection 
          testimonials={testimonials}
          title="What Our Clients Are Saying"
        />

        <PricingSection
          title=" Plans & Pricing"
          subtitle='Get started with our <span class="font-semibold">comprehensive files solution</span> and scale as you grow.'
          monthlyPlans={monthlyPlans}
          annualPlans={annualPlans}
          onPlanSelect={(planName, cycle) => {
            window.location.href = `https://hr.clikkle.com/signup?plan=${planName.toLowerCase()}&cycle=${cycle}&theme=${theme}`;
          }}
          contactSalesUrl="/contact"
        />

         <FAQSection 
          faqs={faqs}
          title="Frequently Asked Questions"
          subtitle="Our friendly team would love to answer your questions."
        />
        <SecuritySection/>
        <section className="w-full flex justify-center items-center bg-transparent">
          <div className="relative my-24 mx-4 md:mx-0 w-full max-w-[1233px]">
            {/* Glassmorphic Container */}
            <div className="bg-white/30 dark:bg-black/30 backdrop-blur-xl border border-gray-900/10 dark:border-white/10 rounded-3xl md:rounded-[40px] shadow-2xl transition-all duration-500 p-8 md:p-12 relative overflow-hidden">
              {/* Decorative background elements */}
              <div className="absolute top-0 right-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -mr-32 -mt-32 blur-3xl" />
              <div className="absolute bottom-0 left-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -ml-32 -mb-32 blur-3xl" />
              
              <div className="flex flex-col items-center justify-center h-full relative z-10">
                <div className="w-full text-center flex flex-col items-center gap-6 max-w-3xl mx-auto">
                  {/* Heading */}
                  <div>
                    {/* Desktop badge */}
                    <div className="hidden md:inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 mb-6">
                      <span className="text-xs md:text-sm font-semibold text-gray-900 dark:text-white tracking-wider uppercase">
                        Ready to Transform?
                      </span>
                    </div>
                    
                    {/* Mobile simplified headline */}
                    <h2 className="md:hidden !text-[28px] font-bold text-gray-900 dark:text-white mb-3 leading-tight">
                      Secure Your Files Today
                    </h2>
                    
                    {/* Desktop full headline */}
                    <h2 className="hidden md:block !text-[40px] lg:!text-[55px] font-bold text-gray-900 dark:text-white mb-4 leading-tight">
                      <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
                        Secure Files
                      </span>{" "}
                      Today.<br />
                      Start Risk-Free!
                    </h2>
                  </div>

                  {/* Description */}
                  <p className="text-base md:text-lg text-gray-700 dark:text-gray-300 max-w-2xl leading-relaxed">
                    Join 1,000+ businesses protecting their data with enterprise-grade security.
                    <span className="hidden md:inline"> No credit card required.</span>
                  </p>

                  {/* CTA Button */}
                  <div className="flex flex-col sm:flex-row items-center gap-4 mt-4 w-full sm:w-auto">
                    <button
                      onClick={() => {
                        window.location.replace(
                          "https://files.clikkle.com/signup?theme=" + theme
                        );
                      }}
                      className="group relative px-8 md:px-10 py-4 md:py-5 bg-gray-900 dark:bg-white text-white dark:text-black rounded-2xl font-semibold text-base md:text-lg transition-all duration-300 hover:scale-105 hover:shadow-2xl w-full sm:w-auto overflow-hidden"
                    >
                      <span className="relative z-10 flex items-center justify-center gap-2">
                        Get Started for Free
                        <svg className="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                          <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 8l4 4m0 0l-4 4m4-4H3" />
                        </svg>
                      </span>
                      <div className="absolute inset-0 bg-gradient-to-r from-gray-800 to-gray-900 dark:from-gray-100 dark:to-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                    </button>
                  </div>

                  {/* Social Proof */}
                  <div className="mt-6 md:mt-8 pt-6 md:pt-8 border-t border-gray-900/10 dark:border-white/10 w-full">
                    <div className="flex flex-col sm:flex-row items-center justify-center gap-4 md:gap-8">
                      <div className="flex items-center gap-2">
                        <div className="flex -space-x-2">
                          <Image
                            src={user2}
                            alt="User"
                            className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover"
                          />
                          <Image
                            src={user5}
                            alt="User"
                            className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover"
                          />
                          <Image
                            src={user6}
                            alt="User"
                            className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover"
                          />
                          <Image
                            src={user7}
                            alt="User"
                            className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover"
                          />
                        </div>
                        <span className="text-xs font-semibold text-gray-900 dark:text-white">51,000+ users</span>
                      </div>
                      <div className="flex items-center gap-1">
                        {[...Array(5)].map((_, i) => (
                          <svg key={i} className="w-4 h-4 text-gray-900 dark:text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                          </svg>
                        ))}
                        <span className="text-xs font-semibold text-gray-900 dark:text-white ml-1">4.9/5</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>

      <Footer/>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default FilesHome;
