"use client";
import Link from "next/link";
import Image from "next/image";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import { motion, AnimatePresence } from "framer-motion";
import {
  ActivityIcon,
  ArrowDown,
  BellIcon,
  Ellipsis,
  HeartIcon,
  LayersIcon,
  LineChartIcon,
  MessageSquareIcon,
  Share2Icon,
  StarIcon,
  ThumbsUpIcon,
  TrendingUpIcon,
  WorkflowIcon,
  ZapIcon,
  SparklesIcon,
  CheckCircle2,
  Smartphone,
  PenTool,
  Briefcase,
  Target,
} from "lucide-react";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import {
  BarChart3Icon,
  RefreshCwIcon,
  SmileIcon,
  UsersIcon,
} from "lucide-react";
import custom1 from "../../public/images/custom1.png";
import custom2 from "../../public/images/custom2.png";
import custom3 from "../../public/images/custom3.png";
import custom4 from "../../public/images/custom4.png";
import { useTheme } from "../atoms/theme";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/new3.png";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/afterHero.jpeg";
import appstir from "../../public/images/appstir.png";
import {
  FileTextIcon,
  LayoutIcon,
  ShieldCheckIcon,
  SendIcon,
  HeadphonesIcon,
  HandshakeIcon,
  PaletteIcon,
  FileSignature,
} from "lucide-react";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import user11 from "../../public/images/user11.jpeg";
import user2 from "../../public/images/user2.jpeg";
import user5 from "../../public/images/user5.jpeg";
import user6 from "../../public/images/user6.jpeg";
import user7 from "../../public/images/user7.jpeg";
import rightArrow from "../../public/images/right-arrow.png";
import someee from "../../public/images/someee.jpeg";
import emmar from "../../public/images/emmar.jpeg";
import sarah from "../../public/images/Sarah.webp";
import jamesCarter from "../../public/images/james-carter.jpg";
import ayesha from "../../public/images/Ayesha.jpg";
import deniel from "../../public/images/deniel.png";
import linda from "../../public/images/linda.jpg";
import esigndark from "../../public/images/esigndark.png";
import esignlight from "../../public/images/esignlight.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import TabbedFeature from "../components/TabbedFeature";
import { MdCreate, MdDescription, MdSnippetFolder, MdSecurity, MdTrendingUp, MdSwapHoriz } from "react-icons/md";
import esignDrop from "../../public/images/esigndrop.png";
import avam from "../../public/images/avam.jpeg";
import { IoHeartCircle } from "react-icons/io5";
import MainHeader from "@/components/MainHeader";
import FeatureSection from "@/components/FeatureSection";
import TestimonialSection from "@/components/TestimonialSection";
import WhyProductSection from "@/components/WhyProductSection";
import HeroSection from "@/components/HeroSection";
import PricingSection from "@/components/PricingSection";
import FAQSection from "@/components/FAQSection";
import PreFooterCTA from "@/components/PreFooterCTA";
import SecuritySection from "@/components/SecuritySection";
import Footer from "@/components/Footer";
import EsignWorkflowAnimationPanel from "@/components/EsignWorkflowAnimationPanel";

const EsignHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  const [currentTextIndex, setCurrentTextIndex] = useState(0);
  
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  // Animated headings for hero section
  const headings = [
    {
      line1: <>Sign Documents,</>,
      line2: (
        <>
          Seal{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Agreements
          </span>
        </>
      ),
    },
    {
      line1: (
        <>
          Paperless{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Signatures
          </span>
        </>
      ),
      line2: <>Made Effortless</>,
    },
    {
      line1: (
        <>
          Close Deals{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Faster
          </span>
        </>
      ),
      line2: <>Than Ever Before</>,
    },
  ];

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentTextIndex((prev) => (prev + 1) % headings.length);
    }, 4000);
    return () => clearInterval(interval);
  }, [headings.length]);

  const tabFeatures = [
    {
      id: "sign",
      label: "Sign",
      icon: <MdCreate className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    },
    {
      id: "documents",
      label: "Documents",
      icon: <MdDescription className="w-4 h-4" />,
      lightImage: esignDrop,
      darkImage: esignDrop,
    },
    {
      id: "templates",
      label: "Templates",
      icon: <MdSnippetFolder className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    }
  ];

  const features1 = [
    {
      icon: (
        <ShieldCheckIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Encrypted Storage",
      description: "Bank-grade security protects every signed document",
    },
    {
      icon: <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Audit Trails",
      description: "Complete history of every action and timestamp",
    },
    {
      icon: (
        <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Multi-Party Signing",
      description: "Coordinate signatures from multiple stakeholders easily",
    },
    {
      icon: <CheckCircle2 className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Compliance Ready",
      description: "Meet ESIGN, UETA, and eIDAS legal requirements",
    },
  ];

  const features2 = [
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Template Library",
      description: "Pre-built contracts ready for instant deployment",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Team Collaboration",
      description: "Share templates and coordinate signature workflows",
    },
    {
      icon: <ZapIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Auto-Reminders",
      description: "Smart notifications ensure timely document completion",
    },
    {
      icon: (
        <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Analytics Dashboard",
      description: "Track completion rates and signing performance metrics",
    },
  ];

  const features3 = [
    {
      icon: (
        <ActivityIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Insights",
      description: "Track template performance and document analytics",
    },
    {
      icon: (
        <MessageSquareIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Engagement",
      description: "Live collaboration drives faster team alignment",
    },
    {
      icon: (
        <LayersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Performance",
      description: "Smart automation accelerates every workflow stage",
    },
    {
      icon: <StarIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Satisfaction",
      description: "Simple customization delivers effortless experiences",
    },
  ];
  const features4 = [
    {
      icon: (
        <TrendingUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Insights",
      description: "Review workflow metrics and signature completion rates",
    },
    {
      icon: (
        <Share2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Engagement",
      description: "Protected sharing empowers distributed team collaboration",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Performance",
      description: "Efficient processes unlock productivity from anywhere",
    },
    {
      icon: <HeartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Satisfaction",
      description: "Simple document handling creates delightful workflows",
    },
  ];

  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const esignTestimonials = [
    {
      text: "Wurknest's e-signature solution transformed our contract workflow entirely. We've cut signing time by 60% and our clients appreciate the professional, streamlined experience every single time.",
      name: "Sarah Mitchell",
      title: "CEO at TechFlow Solutions",
      date: "Jul 5, 2025",
      logo: sarah,
      recommendNote: "Wurknest tools are must recommended",
    },
    {
      text: "We've experienced remarkable efficiency gains with Wurknest's seamless e-signature platform. The detailed audit trail gives us complete peace of mind, while mobile signing ensures deals close faster from anywhere. It's become absolutely essential to our daily operations.",
      name: "James Carter",
      title: "COO at FinStream Inc.",
      date: "Jun 20, 2025",
      logo: jamesCarter,
      recommendNote: "Highly recommended for finance teams",
    },
    {
      text: "Wurknest made document signing effortless across our entire organization. Our legal team spends less time chasing signatures and more time on strategic work. The platform's reliability and integrated compliance features are truly exceptional for our needs.",
      name: "Linda Park",
      title: "Head of Legal at NovaCorp",
      date: "May 30, 2025",
      logo: linda,
      recommendNote: "A game-changer for legal teams",
    },
    {
      text: "Thanks to Wurknest, onboarding new hires became seamless and efficient. Automated workflows handle every step, while built-in compliance tracking prevents oversights. Our HR team saves hours weekly, and new employees love the smooth experience from day one.",
      name: "Daniel Rose",
      title: "HR Manager at BrightHire",
      date: "Apr 18, 2025",
      logo: deniel,
      recommendNote: "Perfect HR solution",
    },
    {
      text: "We're closing deals twice as fast since adopting Wurknest's platform. The intuitive interface, combined with powerful tracking features, builds trust in every client interaction. Our sales team finalizes agreements effortlessly, focusing more on building lasting relationships.",
      name: "Ayesha Malik",
      title: "Sales Director at DealStream",
      date: "Mar 8, 2025",
      logo: ayesha,
      recommendNote: "Best tool for sales enablement",
    },
  ];

  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://esign.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };

  const [isAnnual, setIsAnnual] = useState(true);

  const monthlyPlans = [
    {
      name: "Basic",
      description: "Perfect For\nSmall Teams",
      price: "$2",
      pricePeriod: "per month",
      buttonText: "Start With Basic",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: FileTextIcon, text: "5", subtext: "Documents" },
        { icon: LayoutIcon, text: "3", subtext: "Templates" },
        { icon: BarChart3Icon, text: "", subtext: "LTV Enabled" },
        { icon: ShieldCheckIcon, text: "10", subtext: "Signer Auth Credits" },
        { icon: LayersIcon, text: "", subtext: "App Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Document Sending" },
        { icon: HeadphonesIcon, text: "", subtext: "Basic Support" },
      ],
      highlighted: false,
    },
    {
      name: "Professional",
      description: "Best For\n1-5 Users",
      price: "$3.5",
      pricePeriod: "per month",
      buttonText: "Start With Professional",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: FileTextIcon, text: "10", subtext: "Documents" },
        { icon: LayoutIcon, text: "10", subtext: "Templates" },
        { icon: BarChart3Icon, text: "", subtext: "LTV Enabled" },
        { icon: ShieldCheckIcon, text: "20", subtext: "Signer Auth Credits" },
        { icon: UsersIcon, text: "5", subtext: "Users" },
        { icon: LayersIcon, text: "", subtext: "App Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Document Sending" },
        { icon: HeadphonesIcon, text: "", subtext: "Premium Support" },
        { icon: HandshakeIcon, text: "", subtext: "In person Signing" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Professional Plus",
      description: "Good option For\n1-15 Users",
      price: "$5",
      pricePeriod: "per month",
      buttonText: "Start With Professional Plus",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: FileTextIcon, text: "Unlimited", subtext: "Documents" },
        { icon: LayoutIcon, text: "25", subtext: "Templates" },
        { icon: BarChart3Icon, text: "", subtext: "LTV Enabled" },
        { icon: ShieldCheckIcon, text: "40", subtext: "Signer Auth Credits" },
        { icon: UsersIcon, text: "15", subtext: "Users" },
        { icon: LayersIcon, text: "", subtext: "App Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Document Sending" },
        { icon: HeadphonesIcon, text: "", subtext: "Premium Support" },
        { icon: HandshakeIcon, text: "", subtext: "In Person Support" },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
      ],
      highlighted: false,
    },
  ];

  const annualPlans = [
    {
      name: "Basic",
      description: "Perfect For\nSmall Teams",
      price: "$20",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Basic",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: FileTextIcon, text: "5", subtext: "Documents" },
        { icon: LayoutIcon, text: "3", subtext: "Templates" },
        { icon: BarChart3Icon, text: "", subtext: "LTV Enabled" },
        { icon: ShieldCheckIcon, text: "10", subtext: "Signer Auth Credits" },
        { icon: LayersIcon, text: "", subtext: "App Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Document Sending" },
        { icon: HeadphonesIcon, text: "", subtext: "Basic Support" },
      ],
      highlighted: false,
    },
    {
      name: "Professional",
      description: "Best For\n1-5 Users",
      price: "$35",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Professional",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: FileTextIcon, text: "10", subtext: "Documents" },
        { icon: LayoutIcon, text: "10", subtext: "Templates" },
        { icon: BarChart3Icon, text: "", subtext: "LTV Enabled" },
        { icon: ShieldCheckIcon, text: "20", subtext: "Signer Auth Credits" },
        { icon: UsersIcon, text: "5", subtext: "Users" },
        { icon: LayersIcon, text: "", subtext: "App Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Document Sending" },
        { icon: HeadphonesIcon, text: "", subtext: "Premium Support" },
        { icon: HandshakeIcon, text: "", subtext: "In person Signing" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Professional Plus",
      description: "Good option For\n1-15 Users",
      price: "$50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Professional Plus",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: FileTextIcon, text: "Unlimited", subtext: "Documents" },
        { icon: LayoutIcon, text: "25", subtext: "Templates" },
        { icon: BarChart3Icon, text: "", subtext: "LTV Enabled" },
        { icon: ShieldCheckIcon, text: "40", subtext: "Signer Auth Credits" },
        { icon: UsersIcon, text: "15", subtext: "Users" },
        { icon: LayersIcon, text: "", subtext: "App Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Document Sending" },
        { icon: HeadphonesIcon, text: "", subtext: "Premium Support" },
        { icon: HandshakeIcon, text: "", subtext: "In Person Support" },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
      ],
      highlighted: false,
    },
  ];

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);

  const faqs = [
    {
      question: "What's the setup process?",
      answer: `Starting is simple. Register your account, confirm your email, then upload a file or select from templates. Enter recipient addresses, configure signature sequence and form fields, and press "Send for Signature." We offer setup documentation, quick video guides, and helpful prompts to guide your initial submissions. Alternatively, our support specialists can configure templates and streamline your first process.`,
    },
    {
      question: "Which payment options are available?",
      answer:
        "We support all major credit and debit cards (Visa, Mastercard, American Express) plus PayPal for personal and small-business accounts. For enterprise or larger clients we provide invoice billing and bank transfer options (ACH/SEPA) — reach out to sales for invoicing setup or tailored payment arrangements.",
    },
    {
      question: "Can I modify or cancel my subscription whenever needed?",
      answer:
        "Absolutely — you can upgrade, downgrade, or terminate your plan from the billing section whenever you wish. Modifications apply instantly or at the beginning/end of your next cycle based on the change; enterprise agreements and specialized plans adhere to contract specifications. For clarification on prorated charges or refunds, reach out to support or consult our billing documentation.",
    },
    {
      question: "Are my documents protected and backed up?",
      answer:
        "Protection and accountability are fundamental. Files and electronic signatures utilize enterprise-grade encryption during transmission (TLS) and storage. Each signature event generates a tamper-proof activity log (time stamps, IP addresses, participant actions). We maintain routine backups and permission systems to secure your information. For particular regulatory requirements (e.g., SOC 2, HIPAA), we can explore alternatives and enterprise-tier commitments.",
    },
    {
      question: "Does it connect with other applications?",
      answer:
        "Absolutely — our solution features a REST API and webhook system to streamline document sending, tracking progress, and retrieving signed files. We offer ready-made connections with popular storage and collaboration platforms (Google Drive, Dropbox, OneDrive) plus compatibility with workflow automation services (Zapier). Require specialized integration or SSO? Reach out to our technical/sales staff for assistance.",
    },
  ];

  const isDarkMode = theme === "dark";
  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#0B0C0E] flex flex-col items-center w-full min-h-screen">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#0B0C0E]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#0B0C0E]/90"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader/>
            </div>

            <HeroSection
              announcementOpen={announcementOpen}
              badge={{
                text: "Digital Document Signing",
                showPulse: true,
              }}
              title={{
                beforeHighlight: "Sign documents anywhere,",
                highlight: "seal deals instantly",
                afterHighlight: "",
              }}
              description={{
                desktop: (
                  <>
                    Accelerate business workflows with <span className="font-semibold text-[#253237] dark:text-white">legally binding e-signatures</span>. Secure, compliant, and <span className="font-semibold text-[#253237] dark:text-white">trusted by thousands worldwide.</span>
                  </>
                ),
                mobile: (
                  <>
                    <span className="font-semibold text-[#253237] dark:text-white">Legally binding e-signatures</span> that are secure and compliant.
                  </>
                ),
              }}
              cta={{
                primary: {
                  text: "Start Signing →",
                  onClick: () => {
                    window.location.replace(
                      "https://esign.clikkle.com/signup?theme=" + theme
                    );
                  },
                },
                secondary: {
                  text: "Explore Features",
                  href: "#features",
                },
              }}
              trustIndicators={[
                { text: "No credit card" },
                { text: "Legally binding" },
                { text: "8K+ reviews" },
              ]}
            />

            <div className="relative w-full max-w-[1233px] mx-auto opacity-50 blur-[2px] mb-6 sm:mb-8 px-4 sm:px-0">
              <Image
                src={theme === "dark" ? esigndark : esignlight}
                alt="eSign Dashboard"
                className="w-full h-auto rounded-lg shadow-2xl mb-20"
                priority
              />
            </div>
          </section>
        </section>

        <WhyProductSection
          badge="Why Wurknest eSign?"
          heading="Signatures That Seal Every Deal"
          subheading="Why waste time with paper trails? Wurknest eSign isn't just digital signing; it's a complete document workflow designed to accelerate agreements and protect compliance."
          mainFeature={{
            badge: "Legally Binding Signatures",
            icon: SparklesIcon,
            title: "From Draft to Signature in Minutes",
            description: "Execute contracts with confidence using encrypted e-signatures, complete audit trails, and automated workflows that run 24/7.",
            image: "https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=800&h=600&fit=crop",
            miniFeatures: [
              { title: "Legally Binding", description: "Enforceable contracts" },
              { title: "Audit Trail", description: "Complete tracking" },
              { title: "Templates", description: "Reusable forms" },
              { title: "Compliance", description: "SOC 2 & GDPR" },
            ],
          }}
          featureCards={[
            {
              icon: PenTool,
              title: "Quick Document Setup",
              description: "Upload any document, drag signature fields, and send for signing in under 60 seconds with our intuitive editor.",
            },
            {
              icon: Smartphone,
              title: "Sign Anywhere, Anytime",
              description: "Signers can review and execute documents from any device without downloads or accounts required.",
            },
            {
              icon: Briefcase,
              title: "Workflow Automation",
              description: "Set up signing orders, reminders, and notifications that keep documents moving without manual follow-ups.",
            },
            {
              icon: Target,
              title: "Enterprise Security",
              description: "Bank-level encryption, two-factor authentication, and comprehensive audit logs ensure every signature is protected and verified.",
            },
          ]}
        />

        <section className="w-full max-w-[1480]">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-transparent"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="order-2 lg:order-1">
                  <FeatureSection
                    // icon={<FileSignature className="w-4.5 h-4.5 md:w-5 md:h-5 text-white dark:text-gray-900" />}
                    showIcon={true}
                    title="Secure E-Signatures That Close Deals Faster"
                    description="Execute contracts with confidence using bank-grade encryption, complete audit trails, and legally binding signatures."
                    features={features1}
                    cta1={{
                      label: "Learn More",
                      onClick: () => {
                        window.location.href = "#features";
                      },
                    }}
                    cta2={{
                      label: "Get Started Free",
                      mobileLabel: "Get Started",
                      onClick: () => {
                        window.location.replace(
                          "https://esign.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    quote={{
                      text: "E-signatures saved us hours weekly. Contracts close 3x faster now!",
                      userImg: avam,
                      userName: "Batu K.",
                      userRole: "Marketing Strategist",
                    }}
                    theme={theme}
                  />
                </div>
                <div className="order-1 lg:order-2">
                  <div className="relative flex items-center justify-center transition-all duration-700">
                    {/* Background Flare */}
                    <div className="absolute inset-0 flex items-center justify-center pointer-events-none">
                      <div className="w-[300px] h-[300px] md:w-[400px] md:h-[400px] rounded-full bg-gray-400/10 dark:bg-[#16171B] blur-3xl" />
                    </div>
                    
                    <div className="relative w-full max-w-md aspect-square shadow-lg bg-transparent rounded-3xl p-12 flex items-center justify-center overflow-hidden border border-black/20 dark:border-[#26282E] z-10">
                      {/* Animated Signature SVG */}
                      <svg 
                        viewBox="0 0 500 250" 
                        className="w-full h-auto"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <defs>
                          <style>
                            {`
                              @keyframes draw {
                                to {
                                  stroke-dashoffset: 0;
                                }
                              }
                              .signature-path {
                                stroke: currentColor;
                                stroke-width: 4;
                                fill: none;
                                stroke-linecap: round;
                                stroke-linejoin: round;
                                stroke-dasharray: 1500;
                                stroke-dashoffset: 1500;
                                animation: draw 3s ease-in-out forwards infinite;
                              }
                            `}
                          </style>
                        </defs>
                        
                        <g className="text-black dark:text-gray-200">
                          {/* Signature - Elegant cursive style */}
                          <path 
                            className="signature-path"
                            d="M 50 150 Q 80 90, 110 140 Q 130 170, 155 130 Q 175 100, 195 130 Q 210 150, 230 140 Q 260 125, 285 145 Q 310 165, 335 135 Q 355 115, 375 145 Q 390 165, 410 150 Q 430 135, 450 155 L 460 165 Q 465 145, 470 160"
                          />
                        </g>
                      </svg>
                    </div>

                    {/* Floating badge */}
                    <div className="absolute -bottom-2 -right-2 md:-bottom-4 md:right-10 bg-white dark:bg-gray-700 rounded-xl md:rounded-2xl shadow-lg px-3 py-1.5 md:px-6 md:py-3 border border-gray-200 dark:border-gray-600 opacity-100 z-20">
                      <div className="flex items-center gap-1 md:gap-2">
                        <svg className="w-3 h-3 md:w-5 md:h-5 text-green-500" fill="currentColor" viewBox="0 0 24 24">
                          <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z" />
                        </svg>
                        <span className="text-[9px] md:text-sm font-semibold text-gray-900 dark:text-white">Verified & Secure</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-transparent"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="order-1 lg:order-1">
                  <div className="relative flex items-center justify-center">
                    <Image
                      src="https://images.unsplash.com/photo-1556155092-490a1ba16284?w=800&h=600&fit=crop&q=80"
                      alt="Digital signature and document collaboration"
                      className="w-full h-auto rounded-xl shadow-2xl"
                      width={800}
                      height={600}
                      unoptimized
                    />
                  </div>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-start" style={{display: 'none'}}>
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Streamline Signature
                      </span>{" "}
                      <br className="hidden sm:block" />
                      Requests with Ease
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Request and track signatures easily with instant alerts,
                      reminders, and seamless integrations.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px]">
                    {features2.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}

                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://esign.clikkle.com/signup?theme=" +
                                theme
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>

                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                          Secure and effortless — exactly what I needed.
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                        </p>

                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={emmar}
                            alt="Ava M."
                            className="w-6 h-6 rounded-full"
                            width={24}
                            height={24}
                          />
                          <div>
                            <p className="font-semibold text-sm">Emma R.</p>
                            <p className="text-xs text-gray-400">
                              Business Owner
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="order-2 lg:order-2">
                  <FeatureSection
                    // icon={<FileTextIcon className="w-4.5 h-4.5 md:w-5 md:h-5 text-white dark:text-gray-900" />}
                    showIcon={true}
                    title="Streamline Every Document Workflow"
                    description="Accelerate agreements with templates, team collaboration, and intelligent automation that keeps every signature on track."
                    features={features2}
                    cta1={{
                      label: "Learn More",
                      onClick: () => {
                        window.location.href = "#features-2";
                      },
                    }}
                    cta2={{
                      label: "Get Started Free",
                      mobileLabel: "Get Started",
                      onClick: () => {
                        window.location.replace(
                          "https://esign.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    quote={{
                      text: "Secure and effortless — exactly what I needed for my contracts.",
                      userImg: emmar,
                      userName: "Emma R.",
                      userRole: "Business Owner",
                    }}
                    theme={theme}
                  />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="order-2 lg:order-1">
                  <FeatureSection
                    showIcon={false}
                    title="Build Templates, Automate Workflows Instantly"
                    description="Design reusable document templates, streamline approvals, and enable real-time team collaboration effortlessly."
                    features={features3}
                    cta1={{
                      label: "Get Started",
                      onClick: () => {
                        window.location.replace(
                          "https://esign.clikkle.com/signup?theme=" + theme
                        );
                      },
                      
                    }}
                    cta2={{
                      label: "Learn More",
                      mobileLabel: "Learn More",
                      onClick: () => {
                        window.location.href = "#features-3";
                      },
                      
                    }}
                    quote={{
                      text: "The best e-sign tool I've tried so far!",
                      userImg: someee,
                      userName: "Liam S.",
                      userRole: "Freelancer",
                    }}
                    theme={theme}
                  />
                </div>
                <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-2 gap-[8rem] justify-self-end">
                  <EsignWorkflowAnimationPanel />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <div className="relative w-auto h-full md:h-[520px] max-h-[350px] overflow-hidden rounded-lg group">
                    <Image
                      src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?q=80&w=600&auto=format&fit=crop"
                      alt="Digital signature and document management"
                      className="w-auto h-full relative rounded-lg object-cover"
                      width={600}
                      height={400}
                    />
                    <div className="absolute inset-0 -translate-x-full group-hover:translate-x-full transition-transform duration-1000 ease-in-out bg-gradient-to-r from-transparent via-white/30 to-transparent skew-x-12 pointer-events-none animate-shine" />
                  </div>
                </div>
                <div className="order-2 lg:order-2">
                  <FeatureSection
                    showIcon={false}
                    title="Work faster and easier with e-signatures."
                    description="Execute agreements safely and handle files effortlessly through optimized processes and fluid teamwork from any location."
                    features={features4}
                    cta1={{
                      label: "Get Started",
                      onClick: () => {
                        window.location.replace(
                          "https://esign.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    cta2={{
                      label: "Learn More",
                      mobileLabel: "Learn More",
                      onClick: () => {
                        window.location.href = "#features-4";
                      },
                    }}
                    quote={{
                      text: "Quick setup and works flawlessly every time!",
                      userImg: sarah,
                      userName: "Ava M.",
                      userRole: "Project Manager",
                    }}
                    theme={theme}
                  />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <AppsSection headingPrefix="Profit from fast digital signatures"/>
        </section>

        <section className="w-full">
          <TestimonialSection 
            testimonials={esignTestimonials}
            title="What Our Clients Are Saying"
          />
        </section>
        <section className="w-full" id="moreInfo">
          <PricingSection
            title="Plans and Pricing"
            subtitle='Secure your documents with <span class="font-semibold text-gray-900 dark:text-white">unlimited signatures</span> when you pay yearly, and save on your plan.'
            monthlyPlans={monthlyPlans}
            annualPlans={annualPlans}
            onPlanSelect={redirectToSignup}
            contactSalesUrl="/contact"
          />
        </section>
        <FAQSection 
          faqs={faqs}
          title="Frequently Asked Questions"
          subtitle="Our friendly team would love to answer your questions."
        />
        <SecuritySection />
        <PreFooterCTA
          badge="Ready to Transform?"
          mobileHeadline="Sign Documents Today"
          desktopHeadline={`<span class="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">Sign Documents</span> Today.<br />Start Risk-Free!`}
          description='Join 15,000+ businesses streamlining contracts with secure e-signatures.<span class="hidden md:inline"> No credit card required.</span>'
          buttonText="Get Started for Free"
          buttonUrl={"https://esign.clikkle.com/signup?theme=" + theme}
          userImages={[user2, user5, user6, user7]}
          userCount="15,000+ users"
          rating="4.9/5"
          theme={theme}
        />
        
      </div>

      <Footer/>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default EsignHome;
