"use client";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import { motion, AnimatePresence } from "framer-motion";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import {
  ActivityIcon,
  ArrowDown,
  BellIcon,
  Ellipsis,
  HeartIcon,
  LayersIcon,
  LayoutDashboardIcon,
  LineChartIcon,
  MessageSquareIcon,
  Share2Icon,
  StarIcon,
  ThumbsUpIcon,
  TrendingUpIcon,
  WorkflowIcon,
  ZapIcon,
  LockIcon,
  BellRingIcon,
  SmartphoneIcon,
} from "lucide-react";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import {
  BarChart3Icon,
  RefreshCwIcon,
  SmileIcon,
  UsersIcon,
} from "lucide-react";
import custom1 from "../../public/images/crmpic1.png";
import custom2 from "../../public/images/crmpic2.png";
import custom3 from "../../public/images/crmpic3.png";
import custom4 from "../../public/images/wurknest/dash.png";
import { useTheme } from "../atoms/theme";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/crmproductspic.png";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/crm_user_pic.jpeg";
import crmPipelineImage from "../../public/images/crm-pipeline-management.jpg";
import crmRelationshipImage from "../../public/images/crm-relationship-feature.jpg";
import businessTeamAnalytics from "../../public/images/vecteezy_group-of-business-people-working-together-in-office-flat_.jpg";
import projectManagementIllustration from "../../public/images/Project-Management-Illustration.jpg";
import appstir from "../../public/images/zairlabs.png";
import {
  FileTextIcon,
  LayoutIcon,
  ShieldCheckIcon,
  SendIcon,
  HeadphonesIcon,
  HandshakeIcon,
  PaletteIcon,
} from "lucide-react";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import MainHeader from "../components/MainHeader";
import TestimonialSection from "../components/TestimonialSection";
import PricingSection from "../components/PricingSection";
import Footer from "../components/Footer";
import FAQSection from "../components/FAQSection";
import HeroSection from "@/components/HeroSection";
import { footerColumns } from "../constants/footerText";
import Link from "next/link";
import Image from "next/image";
import esigndark from "../../public/images/crmdark.png";
import esignlight from "../../public/images/crmlight.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import someee from "../../public/images/someee.jpeg";
import emmar from "../../public/images/emmar.jpeg";
import sarah from "../../public/images/Sarah.webp";
import jamesCarter from "../../public/images/james-carter.jpg";
import ayesha from "../../public/images/Ayesha.jpg";
import deniel from "../../public/images/deniel.png";
import linda from "../../public/images/linda.jpg";
import user11 from "../../public/images/user11.jpeg";
import user1 from "../../public/images/user1.jpeg";
import user2 from "../../public/images/user2.jpeg";
import user3 from "../../public/images/user3.jpeg";
import user4 from "../../public/images/user4.jpeg";
import rightArrow from "../../public/images/right-arrow.png";
import TabbedFeature from "../components/TabbedFeature";
import avam from "../../public/images/avam.jpeg";
import { IoHeartCircle } from "react-icons/io5";
import WhyProductSection from "../components/WhyProductSection";
import FeatureSection from "../components/FeatureSection";
import PreFooterCTA from "../components/PreFooterCTA";
import SecuritySection from "@/components/SecuritySection";
import CRMAnimationPanel from "@/components/CRMAnimationPanel";
import DashboardVisualizationPanel from "@/components/DashboardVisualizationPanel";

const CrmHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  // Animated CRM headings
  const crmHeadings = [
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Smarter
          </span>{" "}
          CRM for
        </>
      ),
      line2: "Growing Businesses" 
    },
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Close
          </span>
          ,{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Manage
          </span>
          ,
        </>
      ),
      line2: "Scale Effortlessly" 
    },
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Customer-First
          </span>
        </>
      ),
      line2: "CRM Platform" 
    },
  ];

  const [currentCRMTextIndex, setCurrentCRMTextIndex] = useState(0);

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentCRMTextIndex((prev) => (prev + 1) % crmHeadings.length);
    }, 3000);
    return () => clearInterval(interval);
  }, [crmHeadings.length]);

  const tabFeatures = [
    {
      id: "overview",
      label: "Overview",
      icon: <LayoutDashboardIcon className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    },
    {
      id: "pipeline",
      label: "Pipeline",
      icon: <TrendingUpIcon className="w-4 h-4" />,
      lightImage: custom1,
      darkImage: custom1,
    },
    {
      id: "contacts",
      label: "Contacts",
      icon: <UsersIcon className="w-4 h-4" />,
      lightImage: custom2,
      darkImage: custom2,
    },
    {
      id: "deals",
      label: "Deals",
      icon: <HandshakeIcon className="w-4 h-4" />,
      lightImage: custom3,
      darkImage: custom3,
    },
    {
      id: "reports",
      label: "Reports",
      icon: <BarChart3Icon className="w-4 h-4" />,
      lightImage: custom4,
      darkImage: custom4,
    },
  ];

  const features1 = [
    {
      icon: (
        <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Analytics",
      description: "Track customer interactions and sales patterns",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Engagement",
      description: "Build stronger relationships with automated follow-ups",
    },
    {
      icon: (
        <RefreshCwIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Efficiency",
      description: "Streamline sales processes with workflow automation",
    },
    {
      icon: <SmileIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Satisfaction",
      description: "Improve customer experience with personalized service",
    },
  ];

  const features2 = [
    {
      icon: (
        <LineChartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Insights",
      description: "Monitor sales pipeline and conversion rates",
    },
    {
      icon: <BellIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Alerts",
      description: "Instant notifications for important customer activities",
    },
    {
      icon: <ZapIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Performance",
      description: "Automated workflows maximize team productivity",
    },
    {
      icon: (
        <ThumbsUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Success",
      description: "Close more deals with intelligent lead scoring",
    },
  ];

  const features3 = [
    {
      icon: (
        <ActivityIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Dashboard",
      description: "Real-time overview of sales and customer metrics",
    },
    {
      icon: (
        <MessageSquareIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Collaboration",
      description: "Team communication within customer records",
    },
    {
      icon: (
        <LayersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Integration",
      description: "Connect with your favorite tools and platforms",
    },
    {
      icon: <StarIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Experience",
      description: "Customizable interface for optimal workflow",
    },
  ];
  const features4 = [
    {
      icon: (
        <TrendingUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Growth",
      description: "Scale your business with powerful CRM tools",
    },
    {
      icon: (
        <Share2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Connectivity",
      description: "Sync data across teams and departments",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Automation",
      description: "Reduce manual tasks with smart workflows",
    },
    {
      icon: <HeartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Retention",
      description: "Build lasting customer relationships",
    },
  ];

  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "This CRM has completely transformed how we manage customer relationships. The intuitive interface and powerful features have helped us increase sales by 35% since implementation. I can't imagine running our business without it now.",
      name: "Sarah Mitchell",
      title: "CEO at TechFlow Solutions",
      date: "Jul 5, 2025",
      logo: sarah,
      recommendNote: "Wurknest CRM is must recommended",
    },
    {
      text: "We've experienced a remarkable 50% increase in sales productivity thanks to Wurknest's seamless CRM workflows. The detailed customer insights give us complete visibility, while the mobile app ensures we can manage relationships anywhere. It has become an irreplaceable tool for our sales team.",
      name: "James Carter",
      title: "COO at FinStream Inc.",
      date: "Jun 20, 2025",
      logo: jamesCarter,
      recommendNote: "Highly recommended for sales teams",
    },
    {
      text: "Wurknest CRM has made customer management effortless for our entire organization. Our sales team now spends far less time on admin and far more time building relationships. The platform's reliability and integrated features have made it an invaluable asset for growth.",
      name: "Linda Park",
      title: "Head of Sales at NovaCorp",
      date: "May 30, 2025",
      logo: linda,
      recommendNote: "A game-changer for sales teams",
    },
    {
      text: "Thanks to Wurknest CRM, managing customer interactions has never been easier. The automated workflows streamline every touchpoint, while built-in analytics ensure we never miss an opportunity. Our team saves valuable time each week while delivering better service.",
      name: "Daniel Rose",
      title: "Sales Manager at BrightHire",
      date: "Apr 18, 2025",
      logo: deniel,
      recommendNote: "Perfect sales solution",
    },
    {
      text: "We're closing deals twice as fast since adopting Wurknest CRM. The intuitive interface, combined with powerful automation features, helps our team focus on what matters most - building relationships. It has truly transformed our sales process entirely.",
      name: "Ayesha Malik",
      title: "Sales Director at DealStream",
      date: "Mar 8, 2025",
      logo: ayesha,
      recommendNote: "Best tool for customer management",
    },
  ];

  const [idx, setIdx] = useState(0);
  const { text, name, title, date, logo, recommendNote } = testimonials[idx];

  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://crm.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };

  const prev = () =>
    setIdx((idx - 1 + testimonials.length) % testimonials.length);
  const next = () => setIdx((idx + 1) % testimonials.length);

  const [isAnnual, setIsAnnual] = useState(true);
  const monthlyPlans = [
    {
      name: "Basic",
      description: "Perfect For\nSmall Teams",
      price: "$2",
      pricePeriod: "per month",
      buttonText: "Start With Basic",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UsersIcon, text: "5", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "1000",
          subtext: "Contacts (CRUD & Search)",
        },
        { icon: BarChart3Icon, text: "", subtext: "Basic Sales Reporting" },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Email Logging / Integration (basic)",
        },
        { icon: LayoutIcon, text: "", subtext: "Task & Follow-up Reminders" },
        { icon: LayersIcon, text: "", subtext: "Live Chat Sync" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Basic Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Deal Tracking (Kanban - basic)",
        },
      ],
      highlighted: false,
    },
    {
      name: "Professional",
      description: "Best For\n1-10 Users",
      price: "$3.5",
      pricePeriod: "per month",
      buttonText: "Start With Professional",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: UsersIcon, text: "10", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "",
          subtext: "5000 Contacts (advanced search & notes)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Advanced Sales Reporting & Dashboards",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Priority Email Integration & Logging",
        },
        { icon: LayoutIcon, text: "10", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "App & Live Chat Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Email / Email Campaigns" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Premium Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Kanban Deal Pipeline & Deal Management",
        },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Good option For\nUnlimited Users",
      price: "$5",
      pricePeriod: "per month",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UsersIcon, text: "Unlimited", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "Unlimited",
          subtext: "Contacts (enterprise-grade)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Custom Analytics & Reports",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "24/7 Email & Chat Integration",
        },
        { icon: LayoutIcon, text: "Unlimited", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "API Access & Integrations" },
        {
          icon: SendIcon,
          text: "",
          subtext: "Advanced Email Automation & Logging",
        },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Dedicated Support Manager",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Full Sales Pipeline & Deal Management",
        },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
      ],
      highlighted: false,
    },
  ];

  const annualPlans = [
    {
      name: "Basic",
      description: "Perfect For\nSmall Teams",
      price: "$20",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Basic",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UsersIcon, text: "5", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "1000",
          subtext: "Contacts (CRUD & Search)",
        },
        { icon: BarChart3Icon, text: "", subtext: "Basic Sales Reporting" },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Email Logging / Integration (basic)",
        },
        { icon: LayoutIcon, text: "", subtext: "Task & Follow-up Reminders" },
        { icon: LayersIcon, text: "", subtext: "Live Chat Sync" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Basic Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Deal Tracking (Kanban - basic)",
        },
      ],
      highlighted: false,
    },
    {
      name: "Professional",
      description: "Best For\n1-10 Users",
      price: "$35",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Professional",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: UsersIcon, text: "10", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "",
          subtext: "5000 Contacts (advanced search & notes)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Advanced Sales Reporting & Dashboards",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Priority Email Integration & Logging",
        },
        { icon: LayoutIcon, text: "10", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "App & Live Chat Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Email / Email Campaigns" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Premium Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Kanban Deal Pipeline & Deal Management",
        },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Good option For\nUnlimited Users",
      price: "$50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: UsersIcon, text: "Unlimited", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "Unlimited",
          subtext: "Contacts (enterprise-grade)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Custom Analytics & Reports",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "24/7 Email & Chat Integration",
        },
        { icon: LayoutIcon, text: "Unlimited", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "API Access & Integrations" },
        {
          icon: SendIcon,
          text: "",
          subtext: "Advanced Email Automation & Logging",
        },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Dedicated Support Manager",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Full Sales Pipeline & Deal Management",
        },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
      ],
      highlighted: false,
    },
  ];

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);

  const faqs = [
    {
      question: "How do I get started with CRM?",
      answer: `Getting started is quick. Create an account, import your contacts, and set up your sales pipeline. We provide an onboarding guide, tutorial videos, and in-app tooltips to walk you through the setup. If you prefer, our support team can help configure your first workflows and automation.`,
    },
    {
      question: "What payment methods do you accept?",
      answer:
        "We accept major credit and debit cards (Visa, Mastercard, American Express) and PayPal for individual and small-business subscriptions. For enterprise customers we offer invoiced billing and direct bank transfers — contact sales to enable invoicing or arrange custom payment terms.",
    },
    {
      question: "Can I change or cancel my plan anytime?",
      answer:
        "Yes — you can upgrade, downgrade, or cancel your subscription from the billing page at any time. Changes take effect immediately or at the start/end of the next billing period depending on the action; enterprise contracts follow the terms in your agreement. For questions about proration or refunds, contact support.",
    },
    {
      question: "Is my customer data secure?",
      answer:
        "Security is our top priority. Customer data is protected with industry-standard encryption in transit (TLS) and at rest. We run regular backups and maintain strict access controls. If you have specific compliance needs (e.g., SOC 2, GDPR), we can discuss options and enterprise-level agreements.",
    },
    {
      question: "Can I integrate with other tools?",
      answer:
        "Yes — our CRM includes a REST API and webhooks to sync data with your existing systems. We provide prebuilt integrations with common business tools (Google Workspace, Microsoft 365, Slack) and support for third-party automation platforms. Need a custom integration? Contact our developer team.",
    },
  ];

  const isDarkMode = theme === "dark";
  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  // Feature Section 1 Data
  const featureSection1Data = {
    title: "Smart Relationship Management",
    icon: <HeartIcon className="w-5 h-5" />,
    description: "Build lasting connections with automated follow-ups and intelligent lead scoring that transforms prospects into loyal customers.",
    features: [
      {
        icon: <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-white" />,
        title: "Analytics",
        description: "Track customer interactions and sales patterns"
      },
      {
        icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-white" />,
        title: "Engagement",
        description: "Build stronger relationships with automated follow-ups"
      },
      {
        icon: <RefreshCwIcon className="w-6 h-6 text-gray-600 dark:text-white" />,
        title: "Efficiency",
        description: "Streamline sales processes with workflow automation"
      },
      {
        icon: <SmileIcon className="w-6 h-6 text-gray-600 dark:text-white" />,
        title: "Satisfaction",
        description: "Improve customer experience with personalized service"
      }
    ],
    cta1: {
      label: "Learn More",
      onClick: () => window.open("https://crm.clikkle.com/features", "_blank")
    },
    cta2: {
      label: "Get Started Free",
      mobileLabel: "Start Free",
      onClick: () => window.location.replace("https://crm.clikkle.com/signup?theme=" + theme)
    },
    quote: {
      text: "Super easy to use and helped us increase sales by 40%!",
      userImg: avam,
      userName: "Batu K.",
      userRole: "Marketing Strategist"
    }
  };

  // Why CRM Section Data
  const whyCRMData = {
    badge: "Why Worknest CRM?",
    heading: "Build stronger relationships, seal more deals",
    subheading: "Transform contacts into conversions with intelligent automation, seamless workflows, and insights that drive real growth.",
    mainFeature: {
      badge: "Pipeline Management",
      icon: TrendingUpIcon,
      title: "Visual sales pipeline that moves deals forward",
      description: "Track every opportunity from first contact to closed deal. Drag-and-drop simplicity meets powerful automation to keep your pipeline flowing.",
      image: crmPipelineImage,
      miniFeatures: [
        {
          title: "Drag & Drop",
          description: "Move deals effortlessly"
        },
        {
          title: "Smart Alerts",
          description: "Never miss follow-ups"
        },
        {
          title: "Win Analysis",
          description: "Learn what closes deals"
        },
        {
          title: "Team Sync",
          description: "Everyone stays aligned"
        }
      ]
    },
    featureCards: [
      {
        icon: LockIcon,
        title: "Centralized customer data hub",
        description: "Store contacts, communications, and deal history in one secure place—accessible anytime, anywhere."
      },
      {
        icon: BellRingIcon,
        title: "Instant activity notifications",
        description: "Get real-time alerts on customer actions, deal updates, and team activities so you're always in the loop."
      },
      {
        icon: UsersIcon,
        title: "Simple, intuitive interface",
        description: "Designed for teams who need power without complexity—get up and running in minutes, not weeks."
      },
      {
        icon: SmartphoneIcon,
        title: "Access from any device",
        description: "Work seamlessly across desktop, tablet, and mobile—your CRM goes wherever your business takes you."
      }
    ]
  };

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#0B0C0E] flex flex-col items-center w-full min-h-screen overflow-x-hidden">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader/>
            </div>

            <HeroSection
              announcementOpen={false}
              badge={{
                text: "Smart Customer Relationship Platform",
                showPulse: true,
              }}
              title={{
                beforeHighlight: "Build relationships that",
                highlight: "close deals faster",
                afterHighlight: "",
              }}
              description={{
                desktop: (
                  <>
                    Streamline customer management with <span className="font-semibold text-gray-900 dark:text-white">powerful automation</span>.<br/> Built for <span className="font-semibold text-gray-900 dark:text-white">sales teams</span>  who move fast.
                  </>
                ),
                mobile: (
                  <>
                    <span className="font-semibold text-gray-900 dark:text-white">Powerful CRM</span> built for fast-moving sales teams.
                  </>
                ),
              }}
              cta={{
                primary: {
                  text: "Start Free →",
                  onClick: () => {
                    window.location.replace(
                      "https://crm.clikkle.com/signup?theme=" + theme
                    );
                  },
                },
                secondary: {
                  text: "Explore Features",
                  href: "#features",
                },
              }}
              trustIndicators={[
                { text: "No credit card" },
                { text: "12K+ reviews" },
                { text: "Close more deals" },
              ]}
            />

            <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full md:w-auto">
              <div className="relative w-full flex justify-center">
                <TabbedFeature
                  tabs={tabFeatures}
                  decorator={
                    <Image
                      src={popImg}
                      alt="popImg"
                      className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px] z-10"
                      width={120}
                      height={120}
                    />
                  }
                />
              </div>
            </div>
          </section>
        </section>

        <section className="">
          <WhyProductSection
            badge={whyCRMData.badge}
            heading={whyCRMData.heading}
            subheading={whyCRMData.subheading}
            mainFeature={whyCRMData.mainFeature}
            featureCards={whyCRMData.featureCards}
          />
        </section>

        <section className="w-full max-w-[1480]">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent dark:bg-transparent"
            id="features"
          >
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 lg:gap-16 max-w-[1233px] mx-auto px-4 md:px-8">
              <FeatureSection
                title={featureSection1Data.title}
                description={featureSection1Data.description}
                features={featureSection1Data.features}
                cta1={featureSection1Data.cta1}
                cta2={featureSection1Data.cta2}
                quote={featureSection1Data.quote}
                theme={theme}
              />
              <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-end order-first lg:order-none">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <CRMAnimationPanel/>
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent dark:bg-transparent"
            id="features2-2"
          >
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center gap-12 lg:gap-16">
              <div className="relative flex items-center justify-center lg:justify-start order-2 lg:order-1">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <Image
                  src="https://freerangestock.com:443/sample/147824/group-of-diverse-business-people-meeting-clients.jpg"
                  alt="Business team collaborating on sales analytics and pipeline growth"
                  className="w-full h-auto relative rounded-2xl shadow-2xl"
                  width={600}
                  height={600}
                />
              </div>
              <div className="order-1 lg:order-2">
                <FeatureSection
                  title="Accelerate Your Sales Pipeline"
                  showIcon={false}
                  description="Drive revenue growth with intelligent pipeline tracking, real-time alerts, and seamless workflow automation."
                  features={features2}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      document.getElementById("features3-3")?.scrollIntoView({ behavior: "smooth" });
                    },
                  }}
                  cta2={{
                    label: "Start Free Trial",
                    mobileLabel: "Try Free",
                    onClick: () => {
                      window.location.replace(
                        "https://crm.clikkle.com/signup?theme=" + theme
                      );
                    },
                  }}
                  quote={{
                    text: "Seamless and powerful — transformed how we close deals every day.",
                    userImg: emmar,
                    userName: "Emma R.",
                    userRole: "Sales Director",
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent dark:bg-transparent"
            id="features3-3"
          >
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center gap-12 lg:gap-16">
              <div className="order-1 lg:order-1">
                <FeatureSection
                  title="Visualize Data with Smart Dashboards"
                  showIcon={false}
                  description="Build custom dashboards, automate reporting workflows, and enable real-time team collaboration for maximum efficiency."
                  features={features3}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      document.getElementById("features4-4")?.scrollIntoView({ behavior: "smooth" });
                    },
                  }}
                  cta2={{
                    label: "Start Free Trial",
                    mobileLabel: "Try Free",
                    onClick: () => {
                      window.location.replace(
                        "https://crm.clikkle.com/signup?theme=" + theme
                      );
                    },
                  }}
                  quote={{
                    text: "Game-changing analytics — insights we never knew we needed until now.",
                    userImg: someee,
                    userName: "Liam S.",
                    userRole: "Sales Analyst",
                  }}
                  theme={theme}
                />
              </div>
              <div className="relative flex items-center justify-center lg:justify-end order-2 lg:order-2">
                <DashboardVisualizationPanel />
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent dark:bg-transparent"
            id="features4-4"
          >
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center gap-12 lg:gap-16">
              <div className="relative flex items-center justify-center lg:justify-start order-2 lg:order-1">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <Image
                  src={custom4}
                  alt="crm picture"
                  className="w-full h-auto relative rounded-2xl shadow-2xl"
                  width={600}
                  height={600}
                />
              </div>
              <div className="order-1 lg:order-2">
                <FeatureSection
                  title="Transform Sales with Intelligent CRM"
                  showIcon={false}
                  description="Empower your team with smart customer management, streamlined deal tracking, and collaborative tools that work everywhere."
                  features={features4}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.scrollTo({ top: 0, behavior: "smooth" });
                    },
                  }}
                  cta2={{
                    label: "Start Free Trial",
                    mobileLabel: "Try Free",
                    onClick: () => {
                      window.location.replace(
                        "https://crm.clikkle.com/signup?theme=" + theme
                      );
                    },
                  }}
                  quote={{
                    text: "Simple setup, instant impact — our sales team adapted within hours.",
                    userImg: sarah,
                    userName: "Ava M.",
                    userRole: "Sales Manager",
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <AppsSection headingPrefix="Profit from your data with our CRM & Hub." />
        </section>

        <TestimonialSection
          testimonials={testimonials}
          title="See What Our Customers Are Saying"
        />

        <PricingSection
          title="CRM Plans & Pricing"
          subtitle='Get started with our <span class="font-semibold">comprehensive CRM solution</span> and scale as you grow.'
          monthlyPlans={monthlyPlans}
          annualPlans={annualPlans}
          onPlanSelect={(planName, cycle) => {
            window.location.href = `https://hr.clikkle.com/signup?plan=${planName.toLowerCase()}&cycle=${cycle}&theme=${theme}`;
          }}
          contactSalesUrl="/contact"
        />

        <FAQSection
          faqs={faqs}
          title="Frequently Asked Questions"
          subtitle="Our friendly team would love to answer your questions."
        />
        <SecuritySection />
        <PreFooterCTA
          badge="CRM PLATFORM"
          mobileHeadline="Supercharge Your Sales Performance"
          desktopHeadline={`Elevate Your <span class="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">Customer</span> Relationships`}
          description="Transform customer engagement, accelerate deal closures, and unlock powerful insights with our intelligent CRM solution"
          buttonText="Start Free Today"
          buttonUrl={`https://crm.clikkle.com/signup?theme=${theme}`}
          userImages={[user1, user2, user3, user4]}
          userCount="15,000+ sales teams"
          rating="4.8/5"
          theme={theme}
        />
      </div>
      <Footer/>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default CrmHome;
