"use client";
import Link from "next/link";
import Image from "next/image";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import { motion, AnimatePresence } from "framer-motion";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import {
  LayersIcon,
  Ellipsis,
  ZapIcon,
  FileTextIcon,
  ImageIcon,
  Wand2Icon,
  BrushIcon,
  TrendingUpIcon,
  Share2Icon,
  BellIcon,
  ArrowDown,
  SparklesIcon,
} from "lucide-react";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import { UsersIcon } from "lucide-react";
import custom1 from "../../public/images/creator_pic_0.png";
import custom2 from "../../public/images/creator_pic_1.png";
import custom3 from "../../public/images/creator_pic_2.png";
import custom4 from "../../public/images/creator_pic_3.png";
import { useTheme } from "../atoms/theme";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/crmproductspic.png";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/CretorPOV.jpg";
import craettt from "../../public/images/Clean-And-Simple-Personal-Logo-Example.jpg";
import {
  SendIcon,
  HeadphonesIcon,
  HandshakeIcon,
  PaletteIcon,
} from "lucide-react";
import { apps } from "../constants/products";
import { footerColumns } from "../constants/footerText";
import creatorAIdark from "../../public/images/creatorai.png";
import creatorAIlight from "../../public/images/creatorai.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import rightArrow from "../../public/images/right-arrow.png";
import chat2 from "../../public/images/chat2.jpeg";
import chat3 from "../../public/images/chat3.jpeg";
import chat4 from "../../public/images/chat4.jpeg";
import emmar from "../../public/images/emmar.jpeg";
import sarah from "../../public/images/Sarah.webp";
import jamesCarter from "../../public/images/james-carter.jpg";
import ayesha from "../../public/images/Ayesha.jpg";
import deniel from "../../public/images/deniel.png";
import linda from "../../public/images/linda.jpg";
import TabbedFeature from "../components/TabbedFeature";
import MainHeader from "../components/MainHeader";
import TestimonialSection from "../components/TestimonialSection";
import PricingSection from "../components/PricingSection";
import FAQSection from "../components/FAQSection";
import Footer from "../components/Footer";
import ContentWorkflowAnimationPanel from "@/components/ContentWorkflowAnimationPanel";
import AIContentIntelligencePanel from "@/components/AIContentIntelligencePanel";
import WhyProductSection from "../components/WhyProductSection";
import FeatureSection from "../components/FeatureSection";
import PreFooterCTA from "../components/PreFooterCTA";
import SecuritySection from "@/components/SecuritySection";
import { IoHeartCircle } from "react-icons/io5";
import HeroSection from "@/components/HeroSection";

const CreatorAIHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);
  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  // Animated creator headings
  const creatorHeadings = [
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Create
          </span>{" "}
          Content
        </>
      ),
      line2: "At Lightning Speed" 
    },
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            AI-Powered
          </span>
        </>
      ),
      line2: "Content Generation" 
    },
    { 
      line1: (
        <>
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Transform
          </span>{" "}
          Ideas
        </>
      ),
      line2: "Into Viral Content" 
    },
  ];

  const [currentCreatorTextIndex, setCurrentCreatorTextIndex] = useState(0);

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentCreatorTextIndex((prev) => (prev + 1) % creatorHeadings.length);
    }, 3000);
    return () => clearInterval(interval);
  }, [creatorHeadings.length]);

  const tabFeatures = [
    {
      id: "overview",
      label: "Overview",
      icon: <SparklesIcon className="w-4 h-4" />,
      lightImage: creatorAIlight,
      darkImage: creatorAIdark,
    },
    {
      id: "smart-content",
      label: "Smart Content",
      icon: <FileTextIcon className="w-4 h-4" />,
      lightImage: custom1,
      darkImage: custom1,
    },
    {
      id: "ai-editor",
      label: "AI Editor",
      icon: <ImageIcon className="w-4 h-4" />,
      lightImage: custom2,
      darkImage: custom2,
    },
    {
      id: "optimization",
      label: "Optimization",
      icon: <Wand2Icon className="w-4 h-4" />,
      lightImage: custom3,
      darkImage: custom3,
    },
    {
      id: "publishing",
      label: "Publishing",
      icon: <SendIcon className="w-4 h-4" />,
      lightImage: custom4,
      darkImage: custom4,
    },
  ];

  const features1 = [
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Smart Content Maker",
      description: "Generate professional content for you in minutes",
    },
    {
      icon: <ImageIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "AI Content Editor",
      description: "Effortless edits with real-time AI updates",
    },
    {
      icon: <Wand2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Promo Content Creator",
      description: "Create stunning promos while preserving quality",
    },
    {
      icon: <BrushIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Text-to-Video",
      description: "Create custom videos and content from text prompts",
    },
  ];
  const features5 = [
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Video & Content Plan",
      description:
        "Plan and schedule videos and content across multiple platforms",
    },
    {
      icon: (
        <Share2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Direct Publishing",
      description: "Post content directly to social media channels",
    },
    {
      icon: (
        <LayersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Campaign Management",
      description: "Manage integrated content campaigns with ease",
    },
    {
      icon: <BellIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "AI Content Insights",
      description: "Get optimization suggestions for better performance",
    },
  ];
  const features6 = [
    {
      icon: (
        <PaletteIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Brand Style Control",
      description: "Maintain consistent look across all content",
    },
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Content Templates",
      description: "Save and reuse successful content formats",
    },
    {
      icon: (
        <TrendingUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Performance Analytics",
      description: "Track views, shares, and engagement metrics",
    },
    {
      icon: <ZapIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Bulk Content Creation",
      description: "Generate multiple content pieces simultaneously",
    },
  ];
  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const testimonials = [
    {
      text: "It's one of my favourite products right now, honestly, and I'm pretty hard to please. So the fact that I love your product is amazing. I have loved it, and I don't usually love anything like this because it's typically hard to work with.",
      name: "Sheila Wysocki",
      title: "President & CEO, Without Warning LLC",
      date: "Jul 5, 2025",
      logo: sarah,
      recommendNote: "Essential for any serious video team",
    },
    {
      text: "Wurknest Creator AI Transforms months of work into captivating content in just five minutes! This is more than just a tool; it’s a game-changer. Thanks to the increased views and recognition, my business is thriving like never before.",
      name: "Joe Lipman",
      title: "President, Summit Management Services",
      date: "Jun 20, 2025",
      logo: jamesCarter,
      recommendNote: "Reduced our video & content costs by 80%",
    },
    {
      text: "Wurknest is simple and effective. It completely removes the bottleneck from the content process and provides a step by step guide to creating engaging videos.",
      name: "Dennis Yu",
      title: "Blitzmetrics",
      date: "May 30, 2025",
      logo: linda,
      recommendNote: "Best investment in video marketing",
    },
    {
      text: "Love this tool. With all of the advertising stats pointing towards using video to get noticed, Wurknest just makes it so easy. It looks way too professional for my budget!! This is a good thing.",
      name: "Matt Cooper",
      title: "TechPoint Solutions",
      date: "Apr 18, 2025",
      logo: deniel,
      recommendNote: "Perfect for independent creators",
    },
    {
      text: "5/5 for sensational service. Not only is it an easy to use platform, the tech support is on point and ready to help you with anything to help you get the job done.",
      name: "Calum Maxwell",
      title: "Optimise Online",
      date: "Mar 8, 2025",
      logo: ayesha,
      recommendNote: "Scalable solution for growing teams",
    },
  ];
  const [idx, setIdx] = useState(0);
  const { text, name, title, date, logo, recommendNote } = testimonials[idx];
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://creator.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const prev = () =>
    setIdx((idx - 1 + testimonials.length) % testimonials.length);
  const next = () => setIdx((idx + 1) % testimonials.length);
  const [isAnnual, setIsAnnual] = useState(true);
  const monthlyPlans = [
    {
      name: "Basic",
      description: "Perfect For\nIndividual Creators",
      pricePeriod: "per month",
      price: "$2",
      buttonText: "Start With Basic",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        {
          icon: FileTextIcon,
          text: "0",
          subtext: "AI Videos",
        },
        { icon: ImageIcon, text: "120", subtext: "Premium Clips" },
        { icon: Wand2Icon, text: "2 GB", subtext: "Upload Storage" },
        { icon: BrushIcon, text: "1", subtext: "Brand Kit" },
        { icon: UsersIcon, text: "200", subtext: "Music Tracks" },
        { icon: LayersIcon, text: "", subtext: "Basic Templates" },
        { icon: HeadphonesIcon, text: "", subtext: "Email Support" },
        { icon: HandshakeIcon, text: "", subtext: "Standard Resolution" },
      ],
      highlighted: false,
    },
    {
      name: "Standard",
      description: "Best For\nBrand Managers",
      pricePeriod: "per month",
      price: "$3.5",
      buttonText: "Start With Standard",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        {
          icon: FileTextIcon,
          text: "360",
          subtext: "AI Videos",
        },
        { icon: ImageIcon, text: "3,600", subtext: "Premium Clips" },
        { icon: Wand2Icon, text: "10 GB", subtext: "Upload Storage" },
        { icon: BrushIcon, text: "3", subtext: "Brand Kits" },
        { icon: UsersIcon, text: "1,000", subtext: "Music Tracks" },
        { icon: LayersIcon, text: "", subtext: "Premium Templates" },
        { icon: SendIcon, text: "", subtext: "Bulk Processing" },
        { icon: HeadphonesIcon, text: "", subtext: "Priority Support" },
        { icon: HandshakeIcon, text: "", subtext: "HD Resolution" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Pro",
      description: "Good option For\nProfessional Marketers",
      pricePeriod: "per month",
      price: "$5",
      buttonText: "Start With Pro",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        {
          icon: FileTextIcon,
          text: "3,600",
          subtext: "AI Videos",
        },
        { icon: ImageIcon, text: "36,000", subtext: "Premium Clips" },
        { icon: Wand2Icon, text: "50 GB", subtext: "Upload Storage" },
        { icon: BrushIcon, text: "10", subtext: "Brand Kits" },
        { icon: UsersIcon, text: "2,000", subtext: "Music Tracks" },
        { icon: LayersIcon, text: "", subtext: "All Templates" },
        { icon: SendIcon, text: "", subtext: "White Label" },
        { icon: HeadphonesIcon, text: "", subtext: "Dedicated Support" },
        { icon: HandshakeIcon, text: "", subtext: "4K Resolution" },
        { icon: PaletteIcon, text: "", subtext: "Reselling Rights" },
      ],
      highlighted: false,
    },
  ];
  const annualPlans = [
    {
      name: "Basic",
      description: "Perfect For\nIndividual Creators",
      price: "$20",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Basic",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        {
          icon: FileTextIcon,
          text: "0",
          subtext: "AI Videos",
        },
        { icon: ImageIcon, text: "120", subtext: "Premium Clips" },
        { icon: Wand2Icon, text: "2 GB", subtext: "Upload Storage" },
        { icon: BrushIcon, text: "1", subtext: "Brand Kit" },
        { icon: UsersIcon, text: "200", subtext: "Music Tracks" },
        { icon: LayersIcon, text: "", subtext: "Basic Templates" },
        { icon: HeadphonesIcon, text: "", subtext: "Email Support" },
        { icon: HandshakeIcon, text: "", subtext: "Standard Resolution" },
      ],
      highlighted: false,
    },
    {
      name: "Standard",
      description: "Best For\nBrand Managers",
      price: "$35",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Standard",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        {
          icon: FileTextIcon,
          text: "360",
          subtext: "AI Videos",
        },
        { icon: ImageIcon, text: "3,600", subtext: "Premium Clips" },
        { icon: Wand2Icon, text: "10 GB", subtext: "Upload Storage" },
        { icon: BrushIcon, text: "3", subtext: "Brand Kits" },
        { icon: UsersIcon, text: "1,000", subtext: "Music Tracks" },
        { icon: LayersIcon, text: "", subtext: "Premium Templates" },
        { icon: SendIcon, text: "", subtext: "Bulk Processing" },
        { icon: HeadphonesIcon, text: "", subtext: "Priority Support" },
        { icon: HandshakeIcon, text: "", subtext: "HD Resolution" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Pro",
      description: "Good option For\nProfessional Marketers",
      price: "$50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start With Pro",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: FileTextIcon, text: "3,600", subtext: "AI Videos" },
        { icon: ImageIcon, text: "36,000", subtext: "Premium Clips" },
        { icon: Wand2Icon, text: "50 GB", subtext: "Upload Storage" },
        { icon: BrushIcon, text: "10", subtext: "Brand Kits" },
        { icon: UsersIcon, text: "2,000", subtext: "Music Tracks" },
        { icon: LayersIcon, text: "", subtext: "All Templates" },
        { icon: SendIcon, text: "", subtext: "White Label" },
        { icon: HeadphonesIcon, text: "", subtext: "Dedicated Support" },
        { icon: HandshakeIcon, text: "", subtext: "4K Resolution" },
        { icon: PaletteIcon, text: "", subtext: "Reselling Rights" },
      ],
      highlighted: false,
    },
  ];
  const [openFAQ, setOpenFAQ] = useState<number | null>(0);
  const faqs = [
    {
      question: "How does the AI generate content that matches my brand?",
      answer: `Our AI learns from your website or inputs to create content in your brand style. You can provide guidelines, logos, and preferences that the AI uses for every piece of content.`,
    },
    {
      question: "What video and content formats are available?",
      answer:
        "Basic plan includes Standard Resolution (1080p). Standard offers HD (2K), and Pro provides 4K resolution. All plans include commercial usage rights.",
    },
    {
      question: "Can I cancel or upgrade my plan easily?",
      answer:
        "Yes! Upgrades are instant. Downgrades apply next cycle. Manage everything in your account with no fees.",
    },
    {
      question: "Do you offer team collaboration features?",
      answer:
        "Yes. Standard and Pro plans include sharing, comments, and permissions. Basic has basic sharing.",
    },
    {
      question: "How accurate is the video and content editing tool?",
      answer:
        "Our AI provides precise edits with 99% accuracy, including complex transitions and effects.",
    },
  ];
  const isDarkMode = theme === "dark";
  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);
  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);
  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };
    checkDismissedAnnouncements();
    const interval = setInterval(checkDismissedAnnouncements, 1000);
    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-transparent dark:bg-[#0B0C0E] flex flex-col items-center w-full min-h-screen">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full md:min-h-[1038px] overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader/>                  
            </div>
            <HeroSection
              announcementOpen={false}
              badge={{
                text: "AI Content Creation Platform",
                showPulse: true,
              }}
              title={{
                beforeHighlight: "Create content that",
                highlight: "captivates instantly",
                afterHighlight: "",
              }}
              description={{
                desktop: (
                  <>
                    Transform your ideas into <span className="font-semibold text-gray-900 dark:text-white">engaging content across all platforms</span>.<br/> Just enter your concept and <span className="font-semibold text-gray-900 dark:text-white">watch AI bring it to life.</span>
                  </>
                ),
                mobile: (
                  <>
                    <span className="font-semibold text-gray-900 dark:text-white">AI-powered content</span> across all platforms instantly.
                  </>
                ),
              }}
              cta={{
                primary: {
                  text: "Create Content →",
                  onClick: () => {
                    window.location.replace(
                      "https://creator.clikkle.com/signup?theme=" + theme
                    );
                  },
                },
                secondary: {
                  text: "Explore Features",
                  href: "#features",
                },
              }}
              trustIndicators={[
                { text: "No credit card" },
                { text: "15K+ creators" },
                { text: "10x faster" },
              ]}
            />

            {/* Single Image Display */}
            <div className="flex items-center justify-center pb-8 mt-8 mb-8 rounded-lg w-full md:w-auto px-4">
              <div className="relative w-full max-w-[1233px] flex justify-center">
                <Image
                  src={creatorAIlight}
                  alt="Creator AI Platform Interface"
                  className="w-full h-auto rounded-xl shadow-2xl border border-gray-200 dark:border-gray-700"
                  width={1200}
                  height={700}
                />
              </div>
            </div>
          </section>
        </section>
        <WhyProductSection
          badge="Why Wurknest Creator AI?"
          heading="Transform content creation with AI"
          subheading="Everything you need to produce professional content at scale—from social media posts to ads, all powered by intelligent automation."
          mainFeature={{
            badge: "Trusted by Creators",
            icon: SparklesIcon,
            title: "Built for modern content teams",
            description: "Since 2024, thousands of creators and agencies have revolutionized their workflows with Wurknest Creator AI. Produce more, engage better, and scale effortlessly.",
            image: "https://images.pexels.com/photos/3184465/pexels-photo-3184465.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1",
            miniFeatures: [
              {
                title: "10x faster",
                description: "Content production speed"
              },
              {
                title: "Higher engagement",
                description: "Across all platforms"
              },
              {
                title: "Professional quality",
                description: "Every single time"
              },
              {
                title: "Zero learning curve",
                description: "Start creating instantly"
              }
            ]
          }}
          featureCards={[
            {
              icon: FileTextIcon,
              title: "AI Content Generator",
              description: "Create compelling copy, scripts, and captions that captivate audiences and drive conversions automatically."
            },
            {
              icon: ImageIcon,
              title: "Intelligent Editing",
              description: "Transform raw footage into polished videos with AI-powered editing tools for professional results."
            },
            {
              icon: BrushIcon,
              title: "Asset Library",
              description: "Access millions of premium stock photos, videos, and graphics to elevate your content instantly."
            },
            {
              icon: ZapIcon,
              title: "Lightning Speed",
              description: "Produce high-quality content 10x faster while maintaining exceptional standards and consistency."
            }
          ]}
        />
        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features5"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <FeatureSection
                  title="Plan, Create, Publish—All in One"
                  description="Streamline your entire content workflow from ideation to publication. Manage social posts, videos, and campaigns seamlessly from a unified platform."
                  features={[
                    {
                      icon: <Share2Icon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Multi-Platform Publishing",
                      description: "Schedule and post to all social channels simultaneously"
                    },
                    {
                      icon: <FileTextIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Content Calendar",
                      description: "Visualize and organize your entire content strategy"
                    },
                    {
                      icon: <ImageIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Media Library",
                      description: "Store and access all your assets in one place"
                    },
                    {
                      icon: <TrendingUpIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Performance Analytics",
                      description: "Track engagement and optimize content strategy"
                    }
                  ]}
                  cta1={{
                    label: "View Demo",
                    onClick: () => {
                      window.location.href = "#demo";
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300"
                  }}
                  cta2={{
                    label: "Start Creating",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://creator.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2"
                  }}
                  quote={{
                    text: "Our content output tripled and engagement soared. This platform is a game-changer for creators!",
                    userImg: chat4,
                    userName: "Ethan Rodriguez",
                    userRole: "Creative Director at Digital Studios"
                  }}
                  theme={theme}
                />
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <ContentWorkflowAnimationPanel />
                </div>
              </div>
            </div>
          </section>
        </section>
        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features6"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-start order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <img
                    src="https://images.pexels.com/photos/3184360/pexels-photo-3184360.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1"
                    alt="Professional photography and visual content creation"
                    className="w-auto h-full relative md:h-[520px] max-h-[350px] rounded-xl shadow-2xl object-cover"
                    width={520}
                    height={520}
                  />
                </div>
                <FeatureSection
                  title="Premium Visual Assets at Scale"
                  description="Elevate your brand with unlimited access to 275M+ professional photos, videos, and graphics from premium stock libraries."
                  features={[
                    {
                      icon: <ImageIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Massive Library",
                      description: "Access millions of premium photos and videos instantly"
                    },
                    {
                      icon: <BrushIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "AI Enhancement",
                      description: "Auto-enhance images with intelligent filters and tools"
                    },
                    {
                      icon: <LayersIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Brand Templates",
                      description: "Create consistent visuals with custom templates"
                    },
                    {
                      icon: <SparklesIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Quality Guarantee",
                      description: "Professional-grade assets for every project"
                    }
                  ]}
                  cta1={{
                    label: "Browse Library",
                    onClick: () => {
                      window.location.href = "#library";
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300"
                  }}
                  cta2={{
                    label: "Start Creating",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://creator.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2"
                  }}
                  quote={{
                    text: "The quality of visuals we can now produce is incredible. Our brand looks more professional than ever!",
                    userImg: chat3,
                    userName: "Lucas Garcia",
                    userRole: "Brand Manager at Creative Co"
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>
        </section>
        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features7"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <FeatureSection
                  title="AI-Powered Content Intelligence"
                  description="Let AI handle the heavy lifting—from brainstorming ideas to selecting perfect media. Stay ahead of trends effortlessly with intelligent automation."
                  features={[
                    {
                      icon: <SparklesIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Idea Generation",
                      description: "AI suggests trending topics and creative angles"
                    },
                    {
                      icon: <ImageIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Smart Media Selection",
                      description: "Automatically choose the best visuals for your content"
                    },
                    {
                      icon: <TrendingUpIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Trend Analysis",
                      description: "Stay ahead with real-time trend monitoring"
                    },
                    {
                      icon: <ZapIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Auto-Optimization",
                      description: "Continuously improve content performance"
                    }
                  ]}
                  cta1={{
                    label: "See How It Works",
                    onClick: () => {
                      window.location.href = "#how-it-works";
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300"
                  }}
                  cta2={{
                    label: "Start Creating",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://creator.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2"
                  }}
                  quote={{
                    text: "Saves me 10+ hours every week while producing higher quality content. It's like having a creative team in my pocket!",
                    userImg: chat2,
                    userName: "Olivia Bennett",
                    userRole: "Content Strategist at MediaHub"
                  }}
                  theme={theme}
                />
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <AIContentIntelligencePanel />
                </div>
              </div>
            </div>
          </section>
        </section>
        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features8"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-start order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <img
                    src="https://images.pexels.com/photos/3184339/pexels-photo-3184339.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1"
                    alt="Professional team collaborating with legal protection"
                    className="w-auto h-full relative md:h-[520px] max-h-[350px] rounded-xl shadow-2xl object-cover"
                    width={520}
                    height={520}
                  />
                </div>
                <FeatureSection
                  title="Royalty-Free Content Protection"
                  description="Create with confidence knowing every asset is 100% royalty-free and backed by premium licensing. Zero copyright worries, ever."
                  features={[
                    {
                      icon: <HandshakeIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Getty Images Backed",
                      description: "All assets protected by premium licensing agreements"
                    },
                    {
                      icon: <FileTextIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Commercial Use",
                      description: "Full rights for business and commercial projects"
                    },
                    {
                      icon: <HeadphonesIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Legal Support",
                      description: "24/7 assistance for any licensing questions"
                    },
                    {
                      icon: <SparklesIcon className="w-5 h-5 text-gray-600 dark:text-white" />,
                      title: "Zero Worry",
                      description: "Complete copyright claim protection guaranteed"
                    }
                  ]}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.location.href = "#licensing";
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300"
                  }}
                  cta2={{
                    label: "Start Creating",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://creator.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className: "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2"
                  }}
                  quote={{
                    text: "No more copyright worries! The licensing protection gives us complete peace of mind to create freely.",
                    userImg: emmar,
                    userName: "Emma Richardson",
                    userRole: "Legal & Brand Manager"
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>
        </section>
        <TestimonialSection
          testimonials={testimonials}
          title="See What Our Creators Are Saying"
        />

        <PricingSection
          title="Ai Creator Plans & Pricing"
          subtitle='Get started with our <span class="font-semibold">comprehensive Creator solution</span> and scale as you grow.'
          monthlyPlans={monthlyPlans}
          annualPlans={annualPlans}
          onPlanSelect={(planName, cycle) => {
            window.location.href = `https://hr.clikkle.com/signup?plan=${planName.toLowerCase()}&cycle=${cycle}&theme=${theme}`;
          }}
          contactSalesUrl="/contact"
        />
        <FAQSection
          faqs={faqs}
          title="Frequently Asked Questions"
          subtitle="Our friendly team would love to answer your questions."
        />
        <SecuritySection />
        <PreFooterCTA
          badge="AI CONTENT PLATFORM"
          mobileHeadline="Transform Your Content Creation"
          desktopHeadline={`Revolutionize Your <span class="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">Content</span> Strategy`}
          description="Generate professional content, edit with AI precision, and publish seamlessly across all platforms with our intelligent creation suite"
          buttonText="Start Free Today"
          buttonUrl={`https://creator.clikkle.com/signup?theme=${theme}`}
          userImages={[sarah, jamesCarter, ayesha, linda]}
          userCount="15,000+ creators"
          rating="4.9/5"
          theme={theme}
        />
      </div>
      <Footer/>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};
export default CreatorAIHome;
