"use client";
import React from "react";
import { useTheme } from "../atoms/theme";
import Image from "next/image";
import { FaRocket } from "react-icons/fa";
import Link from "next/link";
import user1 from "../../public/images/user1.jpeg";
import user2 from "../../public/images/user2.jpeg";
import user3 from "../../public/images/user3.jpeg";
import user4 from "../../public/images/user4.jpeg";
import user5 from "../../public/images/user5.jpeg";

function ComingSoon() {
  const { theme } = useTheme();

  return (
    <div className="min-h-screen h-screen bg-white dark:bg-[#0a0a0a] text-gray-900 dark:text-white overflow-hidden flex items-center justify-center">
      {/* Hero Section */}
      <section className="relative w-full h-full flex items-center justify-center px-4">
        {/* Decorative Background Elements */}
        <div className="absolute inset-0 overflow-hidden">
          <div className="absolute top-20 left-10 w-72 h-72 bg-gray-900/5 dark:bg-white/5 rounded-full blur-3xl" />
          <div className="absolute bottom-20 right-10 w-96 h-96 bg-gray-900/5 dark:bg-white/5 rounded-full blur-3xl" />
          <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[800px] h-[800px] bg-gray-900/3 dark:bg-white/3 rounded-full blur-3xl" />
        </div>

        <div className="container mx-auto max-w-5xl relative z-10">
          <div className="text-center space-y-8">
            {/* Badge */}
            <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 mb-4">
              <FaRocket className="text-gray-900 dark:text-white" />
              <span className="text-sm font-semibold text-gray-900 dark:text-white tracking-wider uppercase">
                Launching Soon
              </span>
            </div>

            {/* Main Heading */}
            <h1 className="text-4xl md:text-6xl lg:text-7xl font-bold text-gray-900 dark:text-white leading-tight">
              Something Amazing
              <br />
              <span className="text-gray-900 dark:text-white">Is Coming</span>
            </h1>

            {/* Description */}
            <p className="text-lg md:text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto leading-relaxed">
              We&apos;re crafting an exceptional experience for you. 
              Stay tuned and explore our other amazing products in the meantime.
            </p>

            {/* CTA Buttons */}
            <div className="flex flex-wrap items-center justify-center gap-4 pt-6">
              <Link href="/">
                <button className="px-8 py-4 bg-gray-900 dark:bg-white text-white dark:text-black rounded-2xl font-semibold hover:scale-105 transition-all duration-300 shadow-lg">
                  Explore Our Products
                </button>
              </Link>
              <Link href="/contact">
                <button className="px-8 py-4 bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 text-gray-900 dark:text-white rounded-2xl font-semibold hover:scale-105 transition-all duration-300">
                  Contact Us
                </button>
              </Link>
            </div>

            {/* Social Proof with Real Images */}
            <div className="pt-12 flex flex-col items-center gap-4">
              <div className="flex -space-x-3">
                {[user1, user2, user3, user4, user5].map((userImg, i) => (
                  <Image
                    key={i}
                    src={userImg}
                    alt={`Team member ${i + 1}`}
                    className="w-12 h-12 rounded-full border-2 border-white dark:border-black object-cover"
                    width={48}
                    height={48}
                  />
                ))}
              </div>
              <p className="text-sm text-gray-600 dark:text-gray-400">
                <span className="font-semibold text-gray-900 dark:text-white">Join our community</span> of innovators and early adopters
              </p>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}

export default ComingSoon;
