"use client";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import {
  Bolt,
  BoltIcon,
  ChartBar,
  Ellipsis,
  ClockIcon,
  FileTextIcon,
  Globe,
  GlobeIcon,
  HeartIcon,
  LayoutDashboardIcon,
  MessageCircle,
  PhoneIcon,
  SearchIcon,
  ShieldCheckIcon,
  Smartphone,
  SparklesIcon,
  TrendingUpIcon,
  UserCogIcon,
  Users,
  WorkflowIcon,
  ArrowDown,
} from "lucide-react";
import { useState } from "react";
import { Button } from "../components/button";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import { UsersIcon } from "lucide-react";
import { useTheme } from "../atoms/theme";
import ThemeSwitch from "../components/themeSwitch";
import illustration from "../../public/images/new1.png";
import illustration2 from "../../public/images/new2.png";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/user26.jpeg";
import wsj from "../../public/images/logogg.jpg";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import ClikkleLogo from "@/components/ClikkleLogo";
import { iconMap } from "../utils/iconMap";
import HeroSection from "@/components/HeroSection";
import {
  CheckCircle2,
  User,
  Building,
  MessageSquare,
  History,
  Infinity,
  Target,
  FileText,
  PenTool,
  Users as UsersLucide,
  Briefcase,
} from "lucide-react";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import chat5 from "../../public/images/chat5.png";
import ChatAnimationPanel from "../components/ChatAnimationPanel";
import GlobalSupportAnimationPanel from "../components/GlobalSupportAnimationPanel";
import Link from "next/link";
import Image from "next/image";
import chat2 from "../../public/images/chat2.jpeg";
import chat1 from "../../public/images/chat1.jpeg";
import chat3 from "../../public/images/chat3.jpeg";
import chat4 from "../../public/images/chat4.jpeg";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import { motion, AnimatePresence } from "framer-motion";

import chatMessagesDay from "../../public/images/chat/chat widget messages-daymode.png";
import chatMessagesDark from "../../public/images/chat/chat widget messages-darkmode.png";
import MainHeader from "@/components/MainHeader";
import FeatureSection from "@/components/FeatureSection";
import FAQSection from "@/components/FAQSection";
import Footer from "@/components/Footer";
import TestimonialSection from "@/components/TestimonialSection";
import PricingSection from "@/components/PricingSection";
import SecuritySection from "@/components/SecuritySection";

const ChatHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  const [currentTextIndex, setCurrentTextIndex] = useState(0);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  // Animated headings for hero section
  const headings = [
    {
      line1: <>Connect Instantly,</>,
      line2: (
        <>
          Convert{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Effortlessly
          </span>
        </>
      ),
    },
    {
      line1: (
        <>
          Real-Time{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Conversations
          </span>
        </>
      ),
      line2: <>That Drive Results</>,
    },
    {
      line1: (
        <>
          Never Miss a{" "}
          <span className="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">
            Lead
          </span>
        </>
      ),
      line2: <>Ever Again</>,
    },
  ];

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentTextIndex((prev) => (prev + 1) % headings.length);
    }, 4000);
    return () => clearInterval(interval);
  }, [headings.length]);


  const features1 = [
    {
      icon: (
        <MessageCircle className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Intelligent Assistant",
      description:
        "Powered by state-of-the-art language models to handle inquiries independently.",
    },
    {
      icon: (
        <SparklesIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Instant Solutions",
      description:
        "Automatically resolves standard issues, drastically reducing ticket volume.",
    },
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Knowledge Base Integration",
      description:
        "Pulls from your documentation to deliver precise, verified answers.",
    },
    {
      icon: (
        <SearchIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Context-Aware Responses",
      description: "Tailors answers based on customer history and preferences.",
    },
  ];

  const features2 = [
    {
      icon: (
        <LayoutDashboardIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Automation Builder",
      description: "Visual, no-code builder to create automations and bots.",
    },
    {
      icon: <BoltIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Triggers & Rules",
      description:
        "Fire actions based on events, conditions, and user behavior.",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Reusable Flows",
      description: "Build and reuse automation blocks across teams and sites.",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Team Automations",
      description:
        "Automate handoffs, routing and agent workflows for efficiency.",
    },
  ];

  const features3 = [
    {
      icon: <ClockIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "24/7 Availability",
      description: "Answer customers anytime with always-on bots and queues.",
    },
    {
      icon: <GlobeIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Omnichannel",
      description:
        "Support web, mobile, and messaging channels from one inbox.",
    },
    {
      icon: <PhoneIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Global Reach",
      description:
        "Operate across time zones, languages and regions seamlessly.",
    },
    {
      icon: (
        <Smartphone className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Mobile & Web",
      description: "Agents respond on mobile or desktop with full context.",
    },
  ];

  const features4 = [
    {
      icon: <HeartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Higher CSAT",
      description:
        "Faster replies and accurate answers boost customer satisfaction.",
    },
    {
      icon: (
        <TrendingUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Improved Efficiency",
      description:
        "Automation reduces manual work and speeds up resolution times.",
    },
    {
      icon: (
        <ShieldCheckIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Security & 2FA",
      description: "Protect access and data with two-factor authentication.",
    },
    {
      icon: (
        <UserCogIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Access Controls",
      description:
        "Role-based permissions ensure only authorized access to files.",
    },
  ];

  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "Wurknest Chat transformed our customer support — response times dropped 70% and conversion from chat increased by 18%. The agent mobile app means we never miss a lead. Highly recommended for any customer-facing team.",
      name: "Lucas C.",
      title: "Head of Technical Team",
      logo: chat1,
    },
    {
      text: "Automated routing and saved replies let our small support team handle 4x more chats without hiring. Integrations with our CRM keep customer context synced and agents love the intuitive UI.",
      name: "Olivia B.",
      title: "Support Ops Manager at ApexFlow",
      logo: chat2,
    },
    {
      text: "Wurknest Chat made multi-site chat management effortless. We consolidated widgets across 7 sites, unified histories, and now run targeted chat campaigns that drive engagement.",
      name: "Maya Chen",
      title: "Growth Lead at NextWave",
      logo: chat3,
    },
    {
      text: "Onboarding new agents is quick — predefined workflows, role permissions, and real-time coaching mean ramp time dropped dramatically. Chat analytics give us actionable insights every week.",
      name: "Lucas Grant",
      title: "Customer Experience Manager at GrowthEdge",
      logo: chat4,
    },
    {
      text: "Our support KPIs improved across the board: first response time halved and customer satisfaction jumped. Centralized transcripts and exportable reports make auditing and training simple.",
      name: "Sofia Ramirez",
      title: "Director of CX at BuildSphere",
      logo: chat5,
    },
  ];


  const [isAnnual, setIsAnnual] = useState(true);

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);
  const faqs = [
    {
      question: "What's the setup process for the chat widget?",
      answer: `Getting started is simple — register your account, add your domain, and insert the widget code in your site's header. We offer detailed setup instructions, tutorial videos, and ready-made code for popular platforms. Alternatively, our setup specialists can handle your initial site and conversation setup for you.`,
    },
    {
      question: "Does the chat connect with CRM or support systems?",
      answer:
        "Absolutely — our chat solution connects seamlessly with leading CRMs, support platforms, and tracking systems. Leverage our native integrations or API webhooks to route messages, generate support tickets, and synchronize customer information instantly.",
    },
    {
      question: "What security measures protect chat conversations?",
      answer:
        "We employ enterprise-grade encryption for data transmission and storage, permission-based access management, and automated backups. You can download conversation records and activity logs anytime. We additionally accommodate enterprise needs including SSO authentication and IP whitelisting.",
    },
    {
      question: "Are the widget appearance and chat routing configurable?",
      answer:
        "Certainly. Tailor the widget's design and functionality (colors, placement, localization), define routing logic by team or expertise, establish automated replies, and set up priority/escalation protocols to align with your operations.",
    },
    {
      question: "Can agents and supervisors use mobile devices?",
      answer:
        "Yes — support staff can reply via our native apps (available for iOS and Android) or through the browser interface. Supervisors can access live analytics, oversee ongoing conversations, and get mobile alerts for critical interactions.",
    },
    {
      question: "What's the chat history storage policy and export capability?",
      answer:
        "Storage duration varies by subscription tier (ranging from 30 days to 15 years). You can download chat records in CSV or JSON format, or configure scheduled exports to your preferred cloud storage for permanent retention.",
    },
    {
      question: "What assistance and service guarantees are included?",
      answer:
        "Every plan provides email assistance and help documentation. Premium levels include faster response times, phone support/SLAs, and dedicated setup assistance. Enterprise clients receive tailored SLAs and round-the-clock support availability.",
    },
  ];

  const isDarkMode = theme === "dark";

  const monthlyPlans = [
    {
      name: "Starter",
      description: "Starts from",
      price: "$2",
      pricePeriod: "per month",
      buttonText: "Start Starter",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: User, text: "", subtext: "1 Seat" },
        { icon: User, text: "", subtext: "1 Agent" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "30 day Chat History" },
      ],
      highlighted: false,
    },
    {
      name: "Basic",
      description: "Starts from",
      price: "$3.5",
      pricePeriod: "per month",
      buttonText: "Start Basic",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "5 Year Chat History" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Starts from",
      price: "$5",
      pricePeriod: "per month",
      buttonText: "Start Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "Unlimited Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "15 Year Chat History" },
      ],
      highlighted: false,
    },
  ];
  const annualPlans = [
    {
      name: "Starter",
      description: "Starts from",
      price: "$20",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Starter",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: User, text: "", subtext: "1 Seat" },
        { icon: User, text: "", subtext: "1 Agent" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "30 day Chat History" },
      ],
      highlighted: false,
    },
    {
      name: "Basic",
      description: "Starts from",
      price: "$35",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Basic",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "5 Year Chat History" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Starts from",
      price: "$50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Enterprise",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "Unlimited Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "15 Year Chat History" },
      ],
      highlighted: false,
    },
  ];

  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://chat.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#0B0C0E] flex flex-col items-center w-full min-h-screen overflow-x-hidden">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#0B0C0E]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#0B0C0E]/90"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader/>
            </div>

            <HeroSection
              announcementOpen={announcementOpen}
              badge={{
                text: "Real-Time Customer Engagement",
                showPulse: true,
              }}
              title={{
                beforeHighlight: "Turn conversations into",
                highlight: "lasting relationships",
                afterHighlight: "",
              }}
              description={{
                desktop: (
                  <>
                    Transform visitor interactions with <span className="font-semibold text-gray-900 dark:text-white">AI-powered chat</span> that scales with your business. <span className="font-semibold text-gray-900 dark:text-white">Never miss a lead </span>, always stay connected.
                  </>
                ),
                mobile: (
                  <>
                    <span className="font-semibold text-gray-900 dark:text-white">AI-powered chat</span> that scales with your business.
                  </>
                ),
              }}
              cta={{
                primary: {
                  text: "Start Free Trial →",
                  onClick: () => {
                    window.location.replace(
                      "https://chat.clikkle.com/signup?theme=" + theme
                    );
                  },
                },
                secondary: {
                  text: "Explore Features",
                  href: "#features",
                },
              }}
              trustIndicators={[
                { text: "No credit card" },
                { text: "14-day trial" },
                { text: "Cancel anytime" },
              ]}
            />

            <div className="relative w-full max-w-[1233px] mx-auto opacity-50 blur-[2px] mb-6 sm:mb-8 px-4 sm:px-0">
              <Image
                src={theme === "dark" ? chatMessagesDark : chatMessagesDay}
                alt="Chat Dashboard"
                className="w-full h-auto rounded-lg shadow-2xl mb-20"
                priority
              />
            </div>
          </section>
        </section>
        <section className="w-full max-w-[1233px] text-gray-900 dark:text-white py-8 sm:py-12 md:py-16 md:px-0 px-4 m-auto">
          <div className="w-full">
            <div className="max-w-[1233px] mx-auto px-0">
              <div className="flex flex-col items-center justify-center">
                {/* Header Section */}
                <div className="w-full mb-8 sm:mb-12 md:mb-16 text-center">
                  <div className="flex items-center justify-center gap-3 mb-6">
                    <span className="text-[#253237] dark:text-white font-semibold tracking-wider uppercase text-sm bg-[#090241]/10 dark:bg-[#16171B] px-4 py-2 rounded-full">
                      Why Wurknest Chat?
                    </span>
                  </div>
                  <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl xl:text-6xl font-bold text-[#253237] dark:text-white mb-4 md:mb-6 leading-tight">
                    Customer Conversations That Convert
                  </h2>
                  <p className="text-[#3D3D3D] dark:text-[#94A3B8] text-sm sm:text-base md:text-lg lg:text-xl max-w-3xl mx-auto leading-relaxed">
                    Why let leads slip away? Wurknest Chat isn&apos;t just a messaging tool; it&apos;s a conversion engine designed to turn every visitor into a customer.
                  </p>
                </div>

                {/* Main Feature Card */}
                <div className="bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 sm:p-6 md:p-8 lg:p-12 w-full shadow-lg mb-8 md:mb-12">
                  <div className="flex flex-col lg:flex-row gap-6 md:gap-8 lg:gap-12 items-center">
                    {/* Image Side */}
                    <div className="w-full lg:w-1/2">
                      <div className="relative rounded-xl overflow-hidden shadow-xl">
                        <img
                          src="https://images.unsplash.com/photo-1553877522-43269d4ea984?w=800&h=600&fit=crop"
                          alt="Team Communication and Chat"
                          className="w-full h-full object-cover"
                        />
                      </div>
                    </div>

                    {/* Content Side */}
                    <div className="w-full lg:w-1/2 space-y-4 md:space-y-6 lg:space-y-8">
                      <div>
                        <div className="inline-flex items-center gap-2 bg-[#25272c] dark:bg-white text-white dark:text-black px-3 py-1.5 md:px-4 md:py-2 rounded-full text-xs md:text-sm font-semibold mb-3 md:mb-4">
                          <SparklesIcon className="w-4 h-4" />
                          Real-Time Engagement
                        </div>
                        <h3 className="text-xl sm:text-2xl md:text-3xl lg:text-4xl font-bold text-[#253237] dark:text-white mb-3 md:mb-4">
                          From First Message to Closed Deal
                        </h3>
                        <p className="text-[#3D3D3D] dark:text-[#94A3B8] text-sm sm:text-base md:text-lg leading-relaxed">
                          Capture every opportunity with instant responses, smart routing, and AI-powered assistance that works 24/7.
                        </p>
                      </div>

                      <div className="grid grid-cols-2 gap-2 sm:gap-3 md:gap-4">
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">Instant Connect</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">Real-time chat</p>
                          </div>
                        </div>
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">AI-Powered</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">Smart automation</p>
                          </div>
                        </div>
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">Multi-Channel</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">Unified inbox</p>
                          </div>
                        </div>
                        <div className="flex items-start gap-2 md:gap-3">
                          <div className="w-8 h-8 md:w-10 md:h-10 bg-black/10 dark:bg-[#16171B] rounded-lg flex items-center justify-center flex-shrink-0">
                            <CheckCircle2 className="w-4 h-4 md:w-5 md:h-5 text-[#253237] dark:text-white" />
                          </div>
                          <div>
                            <p className="font-semibold text-[#253237] dark:text-white text-xs sm:text-sm md:text-base">Analytics</p>
                            <p className="text-[10px] sm:text-xs md:text-sm text-[#3D3D3D] dark:text-[#94A3B8]">Deep insights</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                {/* Feature Grid */}
                <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-3 sm:gap-4 md:gap-6 max-w-7xl w-full mb-8 md:mb-12">
                  {/* Feature Card 1 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <MessageCircle className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Live Chat Widget</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        Embed beautiful, responsive chat widgets that engage visitors the moment they land on your site.
                      </p>
                    </div>
                  </div>

                  {/* Feature Card 2 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <Globe className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Multi-Site Management</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        Manage unlimited websites from one dashboard. Perfect for agencies and multi-brand businesses.
                      </p>
                    </div>
                  </div>

                  {/* Feature Card 3 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <Bolt className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Smart Automation</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        Route chats intelligently, automate responses, and let AI handle routine queries while you focus on complex issues.
                      </p>
                    </div>
                  </div>

                  {/* Feature Card 4 */}
                  <div className="group relative bg-white dark:bg-black/40 border border-gray-300 dark:border-[#575662] rounded-xl md:rounded-2xl p-4 md:p-6 lg:p-8 hover:shadow-xl transition-all duration-300">
                    <div className="relative">
                      <div className="w-10 h-10 md:w-12 md:h-12 lg:w-14 lg:h-14 bg-black/10 dark:bg-[#16171B] rounded-lg md:rounded-xl flex items-center justify-center mb-3 md:mb-4 lg:mb-6 group-hover:scale-110 transition-transform duration-300">
                        <ChartBar className="w-5 h-5 md:w-6 md:h-6 lg:w-7 lg:h-7 text-[#253237] dark:text-white" />
                      </div>
                      <h3 className="text-sm md:text-lg lg:text-xl xl:text-2xl font-bold text-[#253237] dark:text-white mb-2 md:mb-3 leading-tight">Deep Analytics</h3>
                      <p className="text-xs md:text-sm lg:text-base text-[#3D3D3D] dark:text-[#94A3B8] leading-relaxed">
                        Track response times, satisfaction scores, and conversion metrics with detailed, actionable reports.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            {/* Testimonial Section */}
            <section className="min-h-[50vh] px-4 md:px-0 py-8 md:py-16 transition-colors duration-300 flex items-center md:mt-8 lg:mt-16">
              <div className="max-w-[1233px] mx-auto w-full">
                <div className="transition-all duration-1000 opacity-100 translate-y-0">
                  <div className="grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-8 items-center">
                    {/* Left side - Testimonial text */}
                    <div>
                      <h2 className="text-xl sm:text-2xl md:text-3xl lg:text-4xl font-bold text-[#253237] dark:text-white mb-3 md:mb-4 leading-tight">
                        Wurknest Chat transformed our customer support - response times dropped 70% since implementation.
                      </h2>
                      
                      <p className="text-xs sm:text-sm md:text-base text-gray-600 dark:text-gray-300 leading-relaxed mb-4 md:mb-6">
                        The platform is now essential for our customer-facing teams. Chat-driven conversions increased 18% and our support team handles 4x more conversations without additional headcount.
                      </p>

                      {/* User info */}
                      <div className="flex items-center gap-3">
                        <Image
                          src={wsj}
                          alt="Radiant Retail"
                          className="w-12 h-12 rounded-full"
                          width={48}
                          height={48}
                        />
                        <div>
                          <h4 className="text-base font-bold text-[#253237] dark:text-white">
                            Henry Mitchell
                          </h4>
                          <p className="text-gray-600 dark:text-gray-400 text-xs">
                            Head of Customer Support, Radiant Retail
                          </p>
                        </div>
                      </div>
                    </div>

                    {/* Right side - Image */}
                    <div className="relative">
                      <div className="rounded-3xl overflow-hidden shadow-2xl">
                        <img 
                          src="https://images.pexels.com/photos/3771807/pexels-photo-3771807.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1"
                          alt="Satisfied Business Professional" 
                          className="w-full h-[300px] md:h-[350px] object-cover object-center"
                        />
                      </div>
                      {/* Decorative elements */}
                      <div className="absolute -bottom-4 -right-4 w-24 h-24 bg-gray-200 dark:bg-gray-700 rounded-3xl -z-10"></div>
                      <div className="absolute -top-4 -left-4 w-20 h-20 bg-gray-300 dark:bg-gray-600 rounded-3xl -z-10"></div>
                    </div>
                  </div>
                </div>
              </div>
            </section>
          </div>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <div className="order-2 lg:order-1">
                  <FeatureSection
                    showIcon={false}
                    title="Cut support workload in half with intelligent automation"
                    description="Leverage cutting-edge AI technology to autonomously handle common customer inquiries without human intervention."
                    features={features1}
                    cta1={{
                      label: "Learn More",
                      onClick: () => {
                        window.location.href = "#features";
                      },
                    }}
                    cta2={{
                      label: "Get Started Free",
                      mobileLabel: "Get Started",
                      onClick: () => {
                        window.location.replace(
                          "https://chat.clikkle.com/signup?theme=" + theme
                        );
                      },
                    }}
                    quote={{
                      text: "Automated responses handle most inquiries instantly — our team's workload has been dramatically reduced.",
                      userImg: chat1,
                      userName: "Emma Li",
                      userRole: "Support Lead at BrightPath",
                    }}
                    theme={theme}
                  />
                </div>
                <div className="order-1 lg:order-2">
                  <ChatAnimationPanel />
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-start order-first lg:order-none">
                  <img
                    src="https://images.unsplash.com/photo-1600880292203-757bb62b4baf?w=800&h=600&fit=crop"
                    alt="Workflow automation"
                    className="relative z-10 rounded-xl md:w-[491px] md:h-[465px] w-full h-auto object-cover"
                  />
                </div>
                <FeatureSection
                  showIcon={false}
                  title="Streamline operations with intelligent automation"
                  description="Automate tasks easily with no-code tools, empowering both customers and teammates."
                  features={features2}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.location.href = "#features2-2";
                    },
                  }}
                  cta2={{
                    label: "Get Started Free",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://chat.clikkle.com/signup?theme=" + theme
                      );
                    },
                  }}
                  quote={{
                    text: "Automation has transformed our workflow — we're more efficient than ever.",
                    userImg: chat2,
                    userName: "Jordan K.",
                    userRole: "Operations Director",
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <FeatureSection
                  showIcon={false}
                  title="Connect with customers anywhere, anytime"
                  description="Engage with your customers across all channels and devices with 24/7 availability and global reach."
                  features={features3}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.location.href = "#features3-3";
                    },
                  }}
                  cta2={{
                    label: "Get Started Free",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://chat.clikkle.com/signup?theme=" + theme
                      );
                    },
                  }}
                  quote={{
                    text: "Always-on bots mean customers get help 24/7 — no more missed leads.",
                    userImg: chat3,
                    userName: "Maya C.",
                    userRole: "Growth Lead",
                  }}
                  theme={theme}
                />
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-start order-first lg:order-none">
                  <div className="absolute w-[280px] sm:w-[380px] h-[280px] sm:h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <GlobalSupportAnimationPanel />
                </div>
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-4 md:px-6 py-20 relative overflow-hidden bg-transparent"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-8 sm:gap-16 lg:gap-[8rem]">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px] justify-center md:justify-start order-first lg:order-none">
                  <img
                    src="https://images.unsplash.com/photo-1552664730-d307ca884978?w=800&h=600&fit=crop"
                    alt="Customer satisfaction and efficiency"
                    className="relative z-10 rounded-xl md:w-[491px] md:h-[465px] w-full h-auto object-cover"
                  />
                </div>
                <FeatureSection
                  showIcon={false}
                  title="Enhance customer satisfaction and efficiency"
                  description="Deliver faster responses and more accurate solutions while maintaining the highest security standards."
                  features={features4}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.location.href = "#features4-4";
                    },
                  }}
                  cta2={{
                    label: "Get Started Free",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://chat.clikkle.com/signup?theme=" + theme
                      );
                    },
                  }}
                  quote={{
                    text: "Mobile app keeps our agents responsive — excellent UX and context.",
                    userImg: chat4,
                    userName: "Lucas G.",
                    userRole: "Customer Experience Manager",
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <AppsSection headingPrefix="Profit from instant team communication"/>
        </section>

        {/* Mobile Feedback Section */}
        <TestimonialSection 
          testimonials={testimonials}
          title="What Our Clients Are Saying"
        />

      <section className="w-full" id="moreInfo">
        <PricingSection
          title="Chat Plans & Pricing"
          subtitle='Get started with our <span class="font-semibold">comprehensive Chat solution</span> and scale as you grow.'
          monthlyPlans={monthlyPlans}
          annualPlans={annualPlans}
          onPlanSelect={(planName, cycle) => {
            window.location.href = `https://hr.clikkle.com/signup?plan=${planName.toLowerCase()}&cycle=${cycle}&theme=${theme}`;
          }}
          contactSalesUrl="/contact"
        />
        </section>

        <FAQSection 
          faqs={faqs}
          title="Frequently Asked Questions"
          subtitle="Our friendly team would love to answer your questions."
        />
        <SecuritySection/>
        <section className="w-full flex justify-center items-center bg-transparent">
          <div className="relative my-24 mx-4 md:mx-[50px] w-full max-w-[1233px]">
            {/* Glassmorphic Container */}
            <div className="bg-white/30 dark:bg-black/30 backdrop-blur-xl border border-gray-900/10 dark:border-white/10 rounded-3xl md:rounded-[40px] shadow-2xl transition-all duration-500 p-8 md:p-12 relative overflow-hidden">
              {/* Decorative background elements */}
              <div className="absolute top-0 right-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -mr-32 -mt-32 blur-3xl" />
              <div className="absolute bottom-0 left-0 w-64 h-64 bg-gray-900/5 dark:bg-white/5 rounded-full -ml-32 -mb-32 blur-3xl" />
              
              <div className="flex flex-col items-center justify-center h-full relative z-10">
                <div className="w-full text-center flex flex-col items-center gap-6 max-w-3xl mx-auto">
                  {/* Heading */}
                  <div>
                    {/* Desktop badge */}
                    <div className="hidden md:inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 mb-6">
                      <span className="text-xs md:text-sm font-semibold text-gray-900 dark:text-white tracking-wider uppercase">
                        Ready to Transform?
                      </span>
                    </div>
                    
                    {/* Mobile simplified headline */}
                    <h2 className="md:hidden !text-[28px] font-bold text-gray-900 dark:text-white mb-3 leading-tight">
                      Scale Your Business Today
                    </h2>
                    
                    {/* Desktop full headline */}
                    <div className="hidden md:block">
                      <h2 className="!text-[32px] md:!text-[56px] leading-none font-bold text-gray-900 dark:text-white mb-3">
                        Transform Your{" "}
                        <span className="text-[#253237] dark:text-white">
                          Workflow
                        </span>
                      </h2>
                      <h3 className="!text-[32px] md:!text-[56px] font-bold text-gray-900 dark:text-white leading-tight">
                        Scale Your Business
                      </h3>
                    </div>
                  </div>

                  <p className="text-gray-600 dark:text-[#94A3B8] text-sm md:text-lg font-medium max-w-2xl mx-auto">
                    Join thousands of teams streamlining operations and driving growth with our all-in-one platform. Start free, scale fast.
                  </p>

                  {/* Form Section */}
                  <div className="w-full max-w-2xl flex flex-col items-center gap-4">
                    <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                      <input
                        type="email"
                        placeholder="Enter Your Email"
                        className="flex-1 px-5 py-4 rounded-xl bg-white/80 dark:bg-black/40 backdrop-blur-sm text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-900/20 dark:focus:ring-white/20 w-full border border-gray-900/10 dark:border-white/10 shadow-lg transition-all duration-300 hover:bg-white dark:hover:bg-black/60"
                      />
                      <button
                        onClick={() => {
                          window.location.replace(
                            "https://chat.clikkle.com/signup?theme=" + theme
                          );
                        }}
                        className="cursor-pointer px-8 py-4 bg-[#253237] dark:bg-white text-white dark:text-[#253237] font-bold rounded-xl transition-all duration-300 w-full sm:w-auto shadow-xl hover:shadow-2xl hover:scale-105 hover:bg-[#1a2329] dark:hover:bg-gray-100"
                      >
                        Get Started Free
                      </button>
                    </div>

                    {/* Terms Checkbox */}
                    <div className="flex items-start gap-3 text-xs md:text-sm text-gray-600 dark:text-[#94A3B8]">
                      <label className="relative flex items-center h-full cursor-pointer mt-0.5">
                        <input
                          type="checkbox"
                          id="terms"
                          aria-label="Agree to terms and conditions"
                          defaultChecked
                          className="peer appearance-none h-5 w-5 border-2 border-gray-300 dark:border-gray-600 rounded-md bg-white/50 dark:bg-black/50 backdrop-blur-sm checked:bg-[#253237] dark:checked:bg-white checked:border-[#253237] dark:checked:border-white transition duration-200"
                        />
                        <span className="absolute left-0 top-0 h-5 w-5 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white dark:peer-checked:before:text-[#253237] peer-checked:before:text-xs peer-checked:before:font-bold"></span>
                      </label>

                      <span className="leading-5 font-medium">
                        I agree with the{" "}
                        <Link
                          href="/terms-of-service"
                          className="underline text-gray-900 dark:text-white hover:text-[#253237] dark:hover:text-gray-300 transition-colors font-semibold"
                          target="_blank"
                          rel="noopener noreferrer"
                        >
                          Terms and Conditions
                        </Link>
                      </span>
                    </div>

                    {/* Trust Indicators */}
                    <div className="flex items-center gap-6 mt-2 flex-wrap justify-center">
                      <div className="flex items-center gap-2">
                        <div className="flex -space-x-2">
                          <img src="https://i.pravatar.cc/150?img=12" alt="User" className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover" />
                          <img src="https://i.pravatar.cc/150?img=26" alt="User" className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover" />
                          <img src="https://i.pravatar.cc/150?img=47" alt="User" className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover" />
                        </div>
                        <span className="text-xs font-semibold text-gray-900 dark:text-white">51,000+ users</span>
                      </div>
                      <div className="flex items-center gap-1">
                        {[...Array(5)].map((_, i) => (
                          <svg key={i} className="w-4 h-4 text-gray-900 dark:text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                          </svg>
                        ))}
                        <span className="text-xs font-semibold text-gray-900 dark:text-white ml-1">4.9/5</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        </div>
        <Footer />
        <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
      
    </div>
  );
};

export default ChatHome;
