"use client";

import { FaArrowRight } from "react-icons/fa";
import React from "react";
import {
  ArrowDown,
  Bolt,
  ChartBar,
  Ellipsis,
  Globe,
  MessageCircle,
  Smartphone,
  Users,
  CheckCircle2,
  Send,
  Target,
  Zap as Lightning,
  BarChart2,
} from "lucide-react";
import campaigns1 from "../../public/images/campaigns1.jpeg";
import campaigns2 from "../../public/images/campaigns2.jpeg";
import campaigns3 from "../../public/images/campaigns3.jpeg";
import campaigns4 from "../../public/images/campaigns4.jpeg";
import campaigns5 from "../../public/images/campaigns5.jpeg";
import rightArrow from "../../public/images/right-arrow.png";
import chat3 from "../../public/images/chat3.jpeg";
import chat4 from "../../public/images/chat4.jpeg";
import filesListDark from "../../public/images/files/files app-home list view-darkmode.png";
import filesListLight from "../../public/images/files/files app-home list view-daymode.png";
import filesTileDark from "../../public/images/files/files app-home tile view-darkmode.png";
import filesTileLight from "../../public/images/files/files app-home tile view-daymode.png";
import filesShareDark from "../../public/images/files/files app-share-darkmode.png";
import filesShareLight from "../../public/images/files/files app-share-daymode.png";
import { useState } from "react";
import popImg from "../../public/images/pop-img.png";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import { useTheme } from "../atoms/theme";
import SidebarDrawer from "../components/sidebarDrawer";
import { Clock as Schedule } from "lucide-react";
import {
  Mail as MailIcon,
  Users as UserIcon,
  Phone as PhoneIcon,
  Layout as DragIcon,
  Zap as SparklesIcon,
  FileText as TemplateIcon,
  Calendar as CalendarIcon,
  BarChart as ChartIcon,
  Repeat as AutomationIcon,
  FilePlus as FormsIcon,
  Layers as SegmentIcon,
  Box as IntegrationIcon,
  CornerUpRight as ResendIcon,
  Globe as AdsIcon,
  Monitor as GoogleAdsIcon,
  Handshake as HandshakeIcon,
  Star as StarIcon,
  RefreshCw as DynamicIcon,
  Share2 as SocialAdvancedIcon,
  TrendingUp as ChartComprehensiveIcon,
  Repeat as AutomationUnlimitedIcon,
  ShoppingCart as EcommerceIcon,
  Send as WelcomeIcon,
  Layers as SegmentUnlimitedIcon,
  Megaphone as AdsAdvancedIcon,
  Search as SeoIcon,
} from "lucide-react";
import {
  Mail,
  Zap,
  FileText,
  Search,
  Layout,
  Repeat,
  Calendar,
  BarChart,
  ShoppingCart,
  Database,
  ShieldCheck,
  TrendingUp,
  Monitor,
} from "lucide-react";
import ThemeSwitch from "../components/themeSwitch";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import chat1 from "../../public/images/chat1.jpeg";
import campaignsdark from "../../public/images/campaignsdark.png";
import campaignslight from "../../public/images/campaignslight.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import TabbedFeature from "../components/TabbedFeature";
import Image from "next/image";
import Link from "next/link";
import MainHeader from "@/components/MainHeader";
import WhyProductSection from "../components/WhyProductSection";
import FeatureSection from "../components/FeatureSection";
import TestimonialSection from "../components/TestimonialSection";
import PricingSection from "../components/PricingSection";
import FAQSection from "../components/FAQSection";
import Footer from "../components/Footer";
import PreFooterCTA from "../components/PreFooterCTA";
import SecuritySection from "@/components/SecuritySection";
import CampaignsAnimationPanel from "@/components/CampaignsAnimationPanel";
import LeadCaptureAnimationPanel from "@/components/LeadCaptureAnimationPanel";

const CampaignsHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const tabFeatures = [
    {
      id: "overview",
      label: "Overview",
      icon: <ChartIcon className="w-4 h-4" />,
      lightImage: filesListLight,
      darkImage: filesListDark,
    },
    {
      id: "email",
      label: "Email",
      icon: <MailIcon className="w-4 h-4" />,
      lightImage: filesTileLight,
      darkImage: filesTileDark,
    },
    {
      id: "automation",
      label: "Automation",
      icon: <AutomationIcon className="w-4 h-4" />,
      lightImage: filesShareLight,
      darkImage: filesShareDark,
    },
    {
      id: "analytics",
      label: "Analytics",
      icon: <ChartComprehensiveIcon className="w-4 h-4" />,
      lightImage: campaigns3,
      darkImage: campaigns3,
    },
    {
      id: "segments",
      label: "Segments",
      icon: <SegmentIcon className="w-4 h-4" />,
      lightImage: filesListLight,
      darkImage: filesListDark,
    },
    {
      id: "forms",
      label: "Forms",
      icon: <FormsIcon className="w-4 h-4" />,
      lightImage: filesTileLight,
      darkImage: filesTileDark,
    },
  ];

  const features1 = [
    {
      icon: <Mail className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Email Builder",
      description: "Drag-&-drop editor with AI copy generator and templates.",
    },
    {
      icon: <FileText className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Templates",
      description:
        "Prebuilt email and landing page templates for fast launches.",
    },
    {
      icon: <Zap className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "AI Tools",
      description: "Generate subject lines, body copy and content suggestions.",
    },
    {
      icon: <Search className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "SEO & Send Tests",
      description:
        "Subject-line tests, deliverability checks and SEO tips for pages.",
    },
  ];

  const features2 = [
    {
      icon: <Layout className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Automation Builder",
      description: "No-code visual flows: triggers, conditions and actions.",
    },
    {
      icon: <Repeat className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Drip & Sequences",
      description: "Create multi-step nurture sequences and autoresponders.",
    },
    {
      icon: <Users className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Segmentation",
      description: "Filter and target audiences with custom segments.",
    },
    {
      icon: <Calendar className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Scheduling & A/B",
      description: "A/B subject tests, send-time optimization and calendars.",
    },
  ];

  const features3 = [
    {
      icon: <Globe className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Multi-channel",
      description: "Email, social posts, SMS and landing pages from one place.",
    },
    {
      icon: <Monitor className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Ads & Integrations",
      description: "Connect Google/Facebook ad flows and 300+ apps.",
    },
    {
      icon: (
        <ShoppingCart className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Ecommerce",
      description: "Templates, carts, & automations for product journeys.",
    },
    {
      icon: (
        <Smartphone className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Mobile-ready",
      description:
        "Responsive pages, mobile previews and push-ready templates.",
    },
  ];

  const features4 = [
    {
      icon: <BarChart className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Analytics",
      description: "Open/click/exposure reports, cohort and revenue tracking.",
    },
    {
      icon: (
        <TrendingUp className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Growth Tools",
      description: "Lookalike audiences, ad targeting and performance tips.",
    },
    {
      icon: <Database className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Integrations",
      description: "Connect CRMs, stores, analytics and storage providers.",
    },
    {
      icon: (
        <ShieldCheck className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Security & Compliance",
      description: "DKIM/SPF/DMARC, role-based access and data controls.",
    },
  ];
  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "Wurknest Campaigns helped us boost conversion rates — email-driven revenue increased 27% in three months. Templates and automations saved hours weekly.",
      name: "Amir Khan",
      title: "Head of Marketing, Radiant Retail",
      date: "Jul 5, 2025",
      logo: campaigns1,
      recommendNote: "Higher conversions & faster launches",
    },
    {
      text: "The automation builder made lead nurturing simple. We moved prospects through personalized flows and doubled demo signups.",
      name: "Norma Moreno",
      title: "Growth Lead, ApexFlow",
      date: "Jun 20, 2025",
      logo: campaigns2,
      recommendNote: "Essential for growth marketing",
    },
    {
      text: "Easy A/B testing and clear reporting let us optimize subject lines and timing — open rates rose significantly.",
      name: "Maya Chen",
      title: "Acquisition Manager, NextWave",
      date: "May 30, 2025",
      logo: campaigns3,
      recommendNote: "Actionable analytics",
    },
    {
      text: "Multi-channel scheduling (email + social) and ad integrations saved our team days of manual work each month.",
      name: "Lucas Grant",
      title: "IT Director, SkyBridge",
      date: "Apr 18, 2025",
      logo: campaigns4,
      recommendNote: "Great for cross-channel teams",
    },
    {
      text: "Our event pages + payment flows launched in one afternoon — event signups and revenue both scaled up.",
      name: "Sofia Ramirez",
      title: "Head of Events, BuildSphere",
      date: "Mar 8, 2025",
      logo: campaigns5,
      recommendNote: "Fast launches for events & promos",
    },
  ];

  const [isAnnual, setIsAnnual] = useState(true);

  const monthlyPlans = [
    {
      name: "Lite",
      description: "Ideal for beginners",
      price: "$2",
      pricePeriod: "per month",
      buttonText: "Start Lite",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: DragIcon, text: "", subtext: "Drag-&-drop email editor" },
        { icon: SparklesIcon, text: "", subtext: "AI copy generator" },
        { icon: TemplateIcon, text: "", subtext: "Basic email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post automation" },
        { icon: ChartIcon, text: "", subtext: "Basic reporting analytics" },
        { icon: AutomationIcon, text: "", subtext: "1 automation template" },
        { icon: FormsIcon, text: "", subtext: "Web signup forms" },
        { icon: SegmentIcon, text: "", subtext: "1 custom segment" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
    {
      name: "Standard",
      description: "Great for most businesses",
      price: "$3.5",
      pricePeriod: "per month",
      buttonText: "Start Standard",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: Schedule, text: "", subtext: "Email scheduling & A/B" },
        { icon: TemplateIcon, text: "", subtext: "Advanced email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post scheduling" },
        {
          icon: ChartIcon,
          text: "",
          subtext: "Advanced reporting (opens/clicks)",
        },
        { icon: AutomationIcon, text: "", subtext: "3 automation templates" },
        { icon: ResendIcon, text: "", subtext: "Auto resend to non-openers" },
        { icon: SegmentIcon, text: "", subtext: "10 custom segments" },
        { icon: AdsIcon, text: "", subtext: "Facebook lookalike & ads" },
        { icon: GoogleAdsIcon, text: "", subtext: "Google Ad Manager" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Premium",
      description: "Ideal for pros",
      price: "$5",
      pricePeriod: "per month",
      buttonText: "Start Premium",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: HandshakeIcon, text: "", subtext: "Priority onboarding" },
        { icon: StarIcon, text: "", subtext: "Dedicated priority support" },
        { icon: DynamicIcon, text: "", subtext: "Dynamic email content" },
        {
          icon: TemplateIcon,
          text: "",
          subtext: "All Standard email features",
        },
        {
          icon: SocialAdvancedIcon,
          text: "",
          subtext: "Advanced social tools",
        },
        {
          icon: ChartComprehensiveIcon,
          text: "",
          subtext: "Comprehensive reporting",
        },
        {
          icon: AutomationUnlimitedIcon,
          text: "",
          subtext: "Unlimited automation templates",
        },
        { icon: AutomationIcon, text: "", subtext: "Custom automations" },
        { icon: EcommerceIcon, text: "", subtext: "Ecommerce templates" },
        { icon: WelcomeIcon, text: "", subtext: "Auto-send welcome emails" },
        {
          icon: SegmentUnlimitedIcon,
          text: "",
          subtext: "Unlimited custom segments",
        },
        { icon: AdsAdvancedIcon, text: "", subtext: "Advanced ad targeting" },
        { icon: SeoIcon, text: "", subtext: "Premium SEO tools" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
  ];
  const annualPlans = [
    {
      name: "Lite",
      description: "Ideal for beginners",
      price: "$20",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Lite",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: DragIcon, text: "", subtext: "Drag-&-drop email editor" },
        { icon: SparklesIcon, text: "", subtext: "AI copy generator" },
        { icon: TemplateIcon, text: "", subtext: "Basic email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post automation" },
        { icon: ChartIcon, text: "", subtext: "Basic reporting analytics" },
        { icon: AutomationIcon, text: "", subtext: "1 automation template" },
        { icon: FormsIcon, text: "", subtext: "Web signup forms" },
        { icon: SegmentIcon, text: "", subtext: "1 custom segment" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
    {
      name: "Standard",
      description: "Great for most businesses",
      price: "$35",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Standard",
      buttonVariant: "primary" as const,
      badge: "BEST VALUE",
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: Schedule, text: "", subtext: "Email scheduling & A/B" },
        { icon: TemplateIcon, text: "", subtext: "Advanced email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post scheduling" },
        {
          icon: ChartIcon,
          text: "",
          subtext: "Advanced reporting (opens/clicks)",
        },
        { icon: AutomationIcon, text: "", subtext: "3 automation templates" },
        { icon: ResendIcon, text: "", subtext: "Auto resend to non-openers" },
        { icon: SegmentIcon, text: "", subtext: "10 custom segments" },
        { icon: AdsIcon, text: "", subtext: "Facebook lookalike & ads" },
        { icon: GoogleAdsIcon, text: "", subtext: "Google Ad Manager" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Premium",
      description: "Ideal for pros",
      price: "$50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Premium",
      buttonVariant: "outline" as const,
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: HandshakeIcon, text: "", subtext: "Priority onboarding" },
        { icon: StarIcon, text: "", subtext: "Dedicated priority support" },
        { icon: DynamicIcon, text: "", subtext: "Dynamic email content" },
        {
          icon: TemplateIcon,
          text: "",
          subtext: "All Standard email features",
        },
        {
          icon: SocialAdvancedIcon,
          text: "",
          subtext: "Advanced social tools",
        },
        {
          icon: ChartComprehensiveIcon,
          text: "",
          subtext: "Comprehensive reporting",
        },
        {
          icon: AutomationUnlimitedIcon,
          text: "",
          subtext: "Unlimited automation templates",
        },
        { icon: AutomationIcon, text: "", subtext: "Custom automations" },
        { icon: EcommerceIcon, text: "", subtext: "Ecommerce templates" },
        { icon: WelcomeIcon, text: "", subtext: "Auto-send welcome emails" },
        {
          icon: SegmentUnlimitedIcon,
          text: "",
          subtext: "Unlimited custom segments",
        },
        { icon: AdsAdvancedIcon, text: "", subtext: "Advanced ad targeting" },
        { icon: SeoIcon, text: "", subtext: "Premium SEO tools" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
  ];

  const faqs = [
    {
      question: "How do I launch my first marketing campaign?",
      answer:
        "Quick start: create an account, import contacts or add a signup form, pick a template, and press send. We provide step-by-step guides, templates, and 1:1 onboarding for paid plans.",
    },
    {
      question: "Can I connect Wurknest Campaigns to my CRM or store?",
      answer:
        "Yes — connect CRMs, ecommerce platforms, and analytics tools via native integrations or webhooks to sync contacts, events, and conversions in real time.",
    },
    {
      question: "How does Wurknest handle deliverability & compliance?",
      answer:
        "We follow email best practices (DKIM/SPF/DMARC), provide deliverability guidance, and offer suppression lists, unsubscribe handling, and GDPR-ready controls.",
    },
    {
      question: "Can I automate email sequences and run A/B tests?",
      answer:
        "Absolutely — build drip sequences with the visual automation builder, run A/B subject-line and send-time tests, and auto-resend to non-openers.",
    },
    {
      question: "Are there pre-built templates and design tools?",
      answer:
        "Yes — use our drag-and-drop editor, AI copy-generator, and library of templates for emails, landing pages and event pages to launch faster.",
    },
    {
      question: "Is there a mobile app or mobile-friendly dashboard?",
      answer:
        "You can manage campaigns from mobile web and get notifications; full desktop features are available in the web dashboard. Mobile access supports quick edits and approvals.",
    },
    {
      question: "What customer support and SLA are included?",
      answer:
        "All plans include email docs and knowledge base. Higher tiers include priority onboarding, phone & chat support, and dedicated success managers for enterprises.",
    },
  ];

  const isDarkMode = theme === "dark";
  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://campaigns.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#0B0C0E] flex flex-col items-center w-full min-h-screen overflow-x-hidden">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px] overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                  : ""
              }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <MainHeader/>
            </div>

            <section
              className={`px-4 md:px-6 ${announcementOpen ? "pt-[14rem]" : "pt-32 md:pt-44"} pb-12 md:pb-20 max-w-7xl mx-auto container relative overflow-hidden`}
            >
              {/* Background gradient effects */}
              <div className="absolute inset-0 -z-10">
                <div className="absolute top-0 left-1/4 w-96 h-96 bg-[radial-gradient(circle,_rgba(37,50,55,0.08)_0%,transparent_70%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.03)_0%,transparent_70%)]" />
                <div className="absolute top-20 right-1/4 w-96 h-96 bg-[radial-gradient(circle,_rgba(37,50,55,0.06)_0%,transparent_70%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.02)_0%,transparent_70%)]" />
              </div>

              <div className="text-center max-w-5xl mx-auto">
                <div className="inline-flex items-center gap-2 bg-gray-100 dark:bg-[#16171B] border border-gray-200 dark:border-[#26282E] rounded-full px-3 md:px-4 py-1.5 md:py-2 mb-4 md:mb-6">
                  <span className="relative flex h-2 w-2">
                    <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-[#253237] dark:bg-white opacity-75"></span>
                    <span className="relative inline-flex rounded-full h-2 w-2 bg-[#253237] dark:bg-white"></span>
                  </span>
                  <p className="text-xs md:text-sm text-gray-700 dark:text-gray-300 font-medium">
                    Marketing automation that actually works
                  </p>
                </div>
                
                <h1 className="text-[28px] sm:text-[36px] md:text-[4rem] lg:text-[4.5rem] font-extrabold text-gray-900 dark:text-white leading-[1.1] mb-4 md:mb-6 px-2">
                  <span className="relative inline-block">
                    <span className="text-[#253237] dark:text-white">Automation</span>
                    <svg className="absolute -bottom-1 md:-bottom-2 left-0 w-full" height="8" viewBox="0 0 200 8" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M1 5.5C50 2.5 150 2.5 199 5.5" stroke="#253237" className="dark:stroke-white" strokeWidth="3" strokeLinecap="round"/>
                    </svg>
                  </span>
                  {" "}for{" "}
                  <br className="hidden md:block" />
                  Marketing Teams
                </h1>
                
                <p className="text-sm md:text-lg lg:text-xl text-gray-600 dark:text-gray-400 leading-relaxed max-w-3xl mx-auto mb-6 md:mb-8 px-2">
                  <span className="hidden md:inline">Grow with powerful tools for web, social, chat, and text. </span>
                  <span className="md:hidden">Connect at every stage. </span>
                  <span className="font-semibold text-gray-900 dark:text-white">Connect at every stage</span>
                  <span className="hidden md:inline"> of the customer journey with </span>
                  <span className="md:hidden"> with </span>
                  <span className="font-semibold text-gray-900 dark:text-white">
                    <span className="hidden md:inline">email, automation & analytics</span>
                    <span className="md:hidden">smart automation</span>
                  </span>
                  <span className="hidden md:inline"> all in one place.</span>
                </p>

                <div className="flex flex-col sm:flex-row items-center justify-center gap-3 md:gap-4 mb-8 md:mb-12 px-2">
                  <button
                    onClick={() => {
                      window.location.replace(
                        "https://campaigns.clikkle.com/signup?theme=" + theme
                      );
                    }}
                    className="w-full sm:w-auto bg-[#253237] dark:bg-white text-white dark:text-[#253237] px-6 md:px-8 py-3 md:py-4 rounded-lg font-semibold hover:bg-[#1a2428] dark:hover:bg-gray-100 transition-all shadow-lg hover:shadow-xl text-base md:text-lg"
                  >
                    Get Started for Free →
                  </button>
                  <Link
                    href="#pricing"
                    className="w-full sm:w-auto text-gray-900 dark:text-white px-6 md:px-8 py-3 md:py-4 rounded-lg font-semibold border-2 border-gray-300 dark:border-[#ffffff3a] hover:bg-gray-100 dark:hover:bg-[#16171B] transition-colors text-base md:text-lg text-center"
                  >
                    See Pricing
                  </Link>
                </div>

                {/* Trust indicators */}
                <div className="flex flex-wrap items-center justify-center gap-4 md:gap-8 text-xs md:text-sm text-gray-600 dark:text-gray-400 px-2">
                  <div className="flex items-center gap-1.5 md:gap-2">
                    <CheckCircle2 className="w-4 md:w-5 h-4 md:h-5 text-[#253237] dark:text-white flex-shrink-0" />
                    <span className="whitespace-nowrap">Free forever plan</span>
                  </div>
                  <div className="flex items-center gap-1.5 md:gap-2">
                    <CheckCircle2 className="w-4 md:w-5 h-4 md:h-5 text-[#253237] dark:text-white flex-shrink-0" />
                    <span className="whitespace-nowrap">No credit card required</span>
                  </div>
                  <div className="flex items-center gap-1.5 md:gap-2">
                    <CheckCircle2 className="w-4 md:w-5 h-4 md:h-5 text-[#253237] dark:text-white flex-shrink-0" />
                    <span className="whitespace-nowrap">Cancel anytime</span>
                  </div>
                </div>
              </div>
            </section>

            <div className="flex items-center justify-center pb-8 mt-8 mb-5 rounded-lg w-full md:w-auto">
              <div className="relative w-full flex justify-center">
                <TabbedFeature
                  tabs={tabFeatures}
                  decorator={
                    <Image
                      src={popImg}
                      alt="popImg"
                      className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px] z-10"
                      width={120}
                      height={120}
                    />
                  }
                />
              </div>
            </div>
          </section>
        </section>

        <WhyProductSection
          badge="Why Wurknest Campaigns?"
          heading="Marketing That Converts on Autopilot"
          subheading="Launch high-performing campaigns across email, social, SMS, and landing pages. Automate workflows, track performance, and scale your marketing without scaling your team."
          mainFeature={{
            badge: "Intelligent Automation",
            icon: Lightning,
            title: "From Idea to Campaign in Minutes",
            description: "Build beautiful emails with drag-and-drop tools, launch automated sequences, and track every interaction with real-time analytics—all in one unified platform.",
            image: "https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800&h=600&fit=crop",
            miniFeatures: [
              { title: "Visual Builder", description: "Drag-and-drop design" },
              { title: "AI-Powered", description: "Smart copy suggestions" },
              { title: "Multi-channel", description: "Email, SMS, social" },
              { title: "Real-time Analytics", description: "Live performance data" },
            ],
          }}
          featureCards={[
            {
              icon: Send,
              title: "Smart Email Campaigns",
              description: "Create stunning emails with our visual builder, AI copy assistant, and hundreds of mobile-optimized templates. A/B test subject lines and send-time optimization included.",
            },
            {
              icon: Lightning,
              title: "Workflow Automation",
              description: "Build no-code automation flows with triggers, conditions, and actions. Set up welcome sequences, cart abandonment, re-engagement campaigns, and more.",
            },
            {
              icon: Target,
              title: "Advanced Segmentation",
              description: "Target the right audience with dynamic segments based on behavior, demographics, engagement history, and custom attributes. Personalize at scale.",
            },
            {
              icon: BarChart2,
              title: "Performance Analytics",
              description: "Track opens, clicks, conversions, and revenue in real-time. Get actionable insights with cohort analysis, funnel reports, and ROI tracking.",
            },
          ]}
        />

        <section className="w-full">
          <section
            className="w-full md:py-32 px-6 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                {/* Left Column: Feature Text */}
                <FeatureSection
                  title="Smart Workflows that Save Hours"
                  showIcon={true}
                  description="Nurture leads on autopilot with personalized workflows that drive engagement and conversions automatically."
                  features={features1}
                  cta1={{
                    label: "Learn More",
                    onClick: () => {
                      window.location.href = "#features";
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                  }}
                  cta2={{
                    label: "Start Workflows",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://campaigns.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                  }}
                  quote={{
                    text: "Build beautiful campaigns in minutes, not days.",
                    userImg: chat1,
                    userName: "Lucas C.",
                    userRole: "Head of Marketing",
                  }}
                  theme={theme}
                />

                {/* Right Column: Animation Panel */}
                <div className="w-full relative flex items-center justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <CampaignsAnimationPanel />
                </div>
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 px-6 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                {/* Left Column: Image Panel (Inverted) */}
                <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none justify-self-start">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <Image
                    src="https://images.pexels.com/photos/193003/pexels-photo-193003.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1"
                    width={520}
                    height={520}
                    alt="Campaigns Personalization"
                    className="w-auto h-full relative md:h-[520px] max-h-[350px] rounded-xl shadow-2xl grayscale-[60%]"
                  />
                </div>

                {/* Right Column: Feature Text */}
                <FeatureSection
                  title="Multi-Channel Personalization Made Easy"
                  showIcon={true}
                  description="Engage customers across every touchpoint with personalized messages based on behavior, preferences, and activity patterns."
                  features={features2}
                  cta1={{
                    label: "View Features",
                    onClick: () => {
                      window.location.href = "#features";
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                  }}
                  cta2={{
                    label: "Start Personalizing",
                    mobileLabel: "Get Started",
                    onClick: () => {
                      window.location.replace(
                        "https://campaigns.clikkle.com/signup?theme=" + theme
                      );
                    },
                    className:
                      "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                  }}
                  quote={{
                    text: "One unified platform for email, SMS, and social outreach.",
                    userImg: chat1,
                    userName: "Lucas C.",
                    userRole: "Growth Marketing Lead",
                  }}
                  theme={theme}
                />
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
        <section
          className="w-full md:py-32 px-6 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
          id="features3-3"
        >
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
              {/* Left Column: Feature Text */}
              <FeatureSection
                title="Capture Leads & Grow Your Audience"
                showIcon={true}
                description="Build customizable forms to capture leads, deliver gated content, and trigger smart automations that nurture prospects into customers."
                features={features3}
                cta1={{
                  label: "Explore Forms",
                  onClick: () => {
                    window.location.href = "#features";
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                }}
                cta2={{
                  label: "Start Capturing Leads",
                  mobileLabel: "Get Started",
                  onClick: () => {
                    window.location.replace(
                      "https://campaigns.clikkle.com/signup?theme=" + theme
                    );
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                }}
                quote={{
                  text: "Analytics that make decisions crystal clear and actionable.",
                  userImg: chat3,
                  userName: "Lucas G.",
                  userRole: "Growth Marketing Lead",
                }}
                theme={theme}
              />

              {/* Right Column: Animation Panel */}
              <div className="w-full relative flex items-center justify-center md:justify-end order-first lg:order-none">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <LeadCaptureAnimationPanel />
              </div>
            </div>
          </div>
        </section>
      </section>

        <section className="w-full">
        <section
          className="w-full md:py-32 px-6 md:px-6 py-20 relative overflow-hidden bg-white dark:bg-transparent"
          id="features4-4"
        >
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
            <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
              {/* Left Column: Image Panel (Inverted) */}
              <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none justify-self-start">
                <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                <Image
                  src="https://images.pexels.com/photos/3184292/pexels-photo-3184292.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1"
                  width={520}
                  height={520}
                  alt="Multi-Channel Reach"
                  className="w-auto h-full relative md:h-[520px] max-h-[350px] rounded-xl shadow-2xl"
                />
              </div>

              {/* Right Column: Feature Text */}
              <FeatureSection
                title="Reach Customers Where They Are"
                showIcon={true}
                description="Connect with your audience across every channel—email, SMS, social, and landing pages—with seamless automation and personalized experiences."
                features={features4}
                cta1={{
                  label: "See Integrations",
                  onClick: () => {
                    window.location.href = "#features";
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-white dark:bg-transparent text-gray-900 dark:text-white text-[14px] md:text-base font-medium rounded-lg md:rounded-xl border-1 border-gray-200 dark:border-[#26282E] hover:border-gray-300 dark:hover:border-gray-200 transition-all duration-300",
                }}
                cta2={{
                  label: "Start Multi-Channel",
                  mobileLabel: "Get Started",
                  onClick: () => {
                    window.location.replace(
                      "https://campaigns.clikkle.com/signup?theme=" + theme
                    );
                  },
                  className:
                    "px-2 py-2 md:px-6 md:py-3 bg-[#253237] dark:bg-white hover:bg-black dark:hover:bg-gray-200 text-white dark:text-black text-[14px] md:text-base font-medium rounded-lg md:rounded-xl transition-all duration-300 hover:shadow-lg hover:scale-105 flex items-center justify-center gap-1 md:gap-2",
                }}
                quote={{
                  text: "Automated workflows eliminate hours of manual work instantly.",
                  userImg: chat4,
                  userName: "Ethan R.",
                  userRole: "Customer Experience Manager",
                }}
                theme={theme}
              />
            </div>
          </div>
        </section>
      </section>
        <section className="w-full">
          <AppsSection headingPrefix="Profit from smarter customer engagement"/>
        </section>

        <TestimonialSection
          title="See what our Users are saying"
          testimonials={testimonials}
        />

        <PricingSection
          monthlyPlans={monthlyPlans}
          annualPlans={annualPlans}
          onPlanSelect={redirectToSignup}
        />

        <FAQSection
          title="Frequently asked questions"
          subtitle=""
          faqs={faqs}
        />
        <section className="w-full flex justify-center items-center">
          <SecuritySection />
          <PreFooterCTA
            badge="Start Free Today"
            mobileHeadline="Scale your campaigns faster"
            desktopHeadline={`<span class='relative inline-block after:content-[""] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm'>Scale</span> your <span class='bg-gradient-to-r from-gray-900 to-gray-600 dark:from-white dark:to-gray-300 bg-clip-text text-transparent font-extrabold'>campaigns</span>.<br/>Launch in <span class='relative inline-block after:content-[""] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm'>minutes</span>.`}
            description="Build stunning emails, landing pages, and workflows—all from one powerful platform."
            buttonText="Start Free Trial"
            buttonUrl={`https://campaigns.clikkle.com/signup?theme=${theme}`}
            theme={theme}
          />
        </section>
      </div>

      <Footer/>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default CampaignsHome;
