/* eslint-disable react-hooks/exhaustive-deps */
/* eslint-disable @next/next/no-img-element */
/* eslint-disable react-hooks/rules-of-hooks */
"use client";
/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { useEffect, useState } from "react";
import { useRouter, useParams } from "next/navigation";
import {
  ArrowLeft,
  Calendar,
  Clock,
  Share2,
  Facebook,
  Twitter,
  Linkedin,
  Copy,
  Check,
} from "lucide-react";
import { BlogPost } from "../constants/blogData";
import { useTheme } from "../atoms/theme";
import Link from "next/link";
import Footer from "@/components/Footer";
import MainHeader from "@/components/MainHeader";

const DEFAULT_API_BASE_URL = "https://admin.clikkle.com:5100/api";

interface BlogPostPageProps {
  blogId: string;
  initialPost?: BlogPost | null;
}

const BlogPostPage: React.FC<BlogPostPageProps> = ({ blogId, initialPost }) => {
  const router = useRouter();
  const params = useParams();
  const slug = (params?.slug as string) || (params?.id as string) || blogId;

  if (!slug) {
    return (
      <div className="min-h-screen bg-white dark:bg-[#0B0C0E] flex items-center justify-center flex-col gap-4">
        <p className="text-gray-600 dark:text-gray-300">
          No blog post slug provided
        </p>
        <button
          onClick={() => router.push("/blogs")}
          className="text-[#253237] dark:text-white hover:underline cursor-pointer"
        >
          Back to blogs
        </button>
      </div>
    );
  }
  const [post, setPost] = useState<BlogPost | null | undefined>(initialPost);
  const [relatedPosts, setRelatedPosts] = useState<BlogPost[]>([]);
  const [loading, setLoading] = useState(!initialPost);
  const [shareMenuOpen, setShareMenuOpen] = useState(false);
  const [copySuccess, setCopySuccess] = useState(false);
  const API_BASE_URL = DEFAULT_API_BASE_URL;

  useEffect(() => {
    const fetchPostBySlug = async () => {
      if (initialPost) {
        setLoading(false);
        return;
      }
      if (!slug) {
        setLoading(false);
        setPost(null);
        return;
      }
      try {
        setLoading(true);
        const apiUrl = `${API_BASE_URL}/blogs/public/slug/${slug}`;

        const controller = new AbortController();
        const timeoutId = setTimeout(() => controller.abort(), 10000);

        try {
          const res = await fetch(apiUrl, {
            method: "GET",
            headers: {
              "Content-Type": "application/json",
            },
            signal: controller.signal,
          });
          clearTimeout(timeoutId);

          if (res.ok) {
            const json = await res.json();
            if (json?.success && json.data) {
              const b = json.data;
              const mapped: BlogPost = {
                id: b._id,
                slug: b.slug,
                title: b.title,
                excerpt: b.excerpt || "",
                content: b.content || "",
                featuredImage:
                  b.featuredImage ||
                  "https://cdn.clikkle.com/images/clikkle/logo/2025/clikkle.png",
                author: {
                  name: b.author?.name || "Unknown Author",
                  avatar:
                    b.author?.avatar ||
                    "https://cdn.clikkle.com/images/clikkle/logo/2025/clikkle.png",
                  bio: b.author?.bio || "",
                },
                publishedDate: b.publishedDate || new Date().toISOString(),
                category: b.category || "News",
                tags: Array.isArray(b.tags) ? b.tags : [],
                readTime: b.readTime ?? b.calculatedReadTime ?? 0,
                seoTitle: b.metaTitle || b.title,
                seoDescription: b.metaDescription || b.excerpt || "",
              };
              setPost(mapped);

              document.title = `Clikkle Blogs | ${
                mapped.excerpt || mapped.title
              }`;
              const metaDescription = document.querySelector(
                'meta[name="description"]'
              );
              if (metaDescription) {
                metaDescription.setAttribute(
                  "content",
                  mapped.seoDescription || mapped.excerpt
                );
              }
              return;
            }
          }
        } catch (apiError) {
          console.log(apiError);
          clearTimeout(timeoutId);
        }
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
      } catch (err) {
        setPost(null);
      } finally {
        setLoading(false);
      }
    };

    fetchPostBySlug();
  }, [slug]);

  useEffect(() => {
    const incrementViews = async () => {
      try {
        if (!post?.id) return;
        await fetch(`${API_BASE_URL}/blogs/public/${post?.id}/views`, {
          method: "PATCH",
        });
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
      } catch (_) {}
    };
    incrementViews();
  }, [post?.id]);

  useEffect(() => {
    const fetchRelated = async () => {
      try {
        if (!post?.category) return;
        const params = new URLSearchParams();
        params.set("page", "1");
        params.set("limit", "6");
        params.set("status", "published");
        params.set("category", post?.category);
        params.set("sortBy", "publishedDate");
        params.set("sortOrder", "desc");

        const res = await fetch(
          `${API_BASE_URL}/blogs/public?${params?.toString()}`
        );
        const json = await res.json();
        if (!res.ok || !json?.success) return;
        const mapped: BlogPost[] = (json.data || [])
          .filter((b: any) => b.slug !== post?.slug)
          .slice(0, 3)
          .map((b: any) => ({
            id: b._id,
            slug: b.slug,
            title: b.title,
            excerpt: b.excerpt || "",
            content: b.content || "",
            featuredImage:
              b.featuredImage ||
              "https://cdn.clikkle.com/images/clikkle/logo/2025/clikkle.png",
            author: {
              name: b.author?.name || "Unknown Author",
              avatar:
                b.author?.avatar ||
                "https://cdn.clikkle.com/images/clikkle/logo/2025/clikkle.png",
              bio: b.author?.bio || "",
            },
            publishedDate: b.publishedDate || new Date().toISOString(),
            category: b.category || "News",
            tags: Array.isArray(b.tags) ? b.tags : [],
            readTime: b.readTime ?? b.calculatedReadTime ?? 0,
            seoTitle: b.metaTitle || b.title,
            seoDescription: b.metaDescription || b.excerpt || "",
          }));
        setRelatedPosts(mapped);
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
      } catch (_) {}
    };
    fetchRelated();
  }, [post?.category, post?.slug]);

  const handleShare = (platform: string) => {
    const url = window.location.href;
    const title = post?.title || "";

    let shareUrl = "";
    switch (platform) {
      case "facebook":
        shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(
          url
        )}`;
        break;
      case "twitter":
        shareUrl = `https://twitter.com/intent/tweet?url=${encodeURIComponent(
          url
        )}&text=${encodeURIComponent(title)}`;
        break;
      case "linkedin":
        shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(
          url
        )}`;
        break;
      case "copy":
        navigator.clipboard.writeText(url);
        setCopySuccess(true);
        setTimeout(() => setCopySuccess(false), 2000);
        return;
    }

    if (shareUrl) {
      window.open(shareUrl, "_blank", "width=600,height=400");
    }
    setShareMenuOpen(false);
  };

  const formatDate = (dateString: string) => {
    return new Date(dateString).toLocaleDateString("en-US", {
      year: "numeric",
      month: "long",
      day: "numeric",
    });
  };
  const { theme } = useTheme();

  if (loading) {
    return (
      <div className="min-h-screen bg-white dark:bg-[#0B0C0E] flex items-center justify-center">
        <div className="animate-spin rounded-full h-32 w-32 border-b-2 border-[#253237]"></div>
      </div>
    );
  }

  if (post == null) {
    return (
      <div className="min-h-screen bg-white dark:bg-[#0B0C0E] flex items-center justify-center flex-col gap-4">
        <p className="text-gray-600 dark:text-gray-300">Post not found</p>
        <Link
          href="/blogs"
          className="text-[#253237] dark:text-white cursor-pointer"
        >
          Back to blogs
        </Link>
      </div>
    );
  }

  return (
    <>
      <MainHeader />
      <div className="min-h-screen bg-white dark:bg-[#0B0C0E] pt-24">
        <div className="">
          <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <button
              onClick={() => router.push("/blogs")}
              className="flex items-center transition-colors cursor-pointer"
            >
              <ArrowLeft className="h-5 w-5 mr-2" />
              Back to Blogs
            </button>
          </div>
        </div>

        <article className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
          <h1 className="text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-6 leading-tight">
            {post?.title}
          </h1>
          <div className="mb-8">
            <img
              src={post?.featuredImage}
              alt={post?.title}
              className="w-full h-auto object-cover rounded-lg shadow-lg"
            />
          </div>

          <header className="mb-8">
            <div className="mb-4">
              <span className="inline-block cursor-pointer px-3 py-1 text-sm font-medium bg-gray-200 text-gray-800 dark:bg-[#26282E] dark:text-white rounded-full">
                {post?.category}
              </span>
            </div>

            <div className="flex flex-wrap items-center gap-6 text-gray-600 dark:text-gray-300 mb-6">
              <div className="flex items-center">
                <img
                  src={post?.author.avatar}
                  alt={post?.author.name}
                  className="w-8 h-8 rounded-full mr-2 object-cover"
                />
                <span>{post?.author.name}</span>
              </div>
              <div className="flex items-center">
                <Calendar className="h-4 w-4 mr-2" />
                <span>
                  {formatDate(post?.publishedDate || new Date().toISOString())}
                </span>
              </div>
              <div className="flex items-center">
                <Clock className="h-4 w-4 mr-2" />
                <span>{post?.readTime} min read</span>
              </div>
            </div>

            <div className="relative">
              <button
                onClick={() => setShareMenuOpen(!shareMenuOpen)}
                className="cursor-pointer flex items-center px-4 py-2 bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-200 dark:hover:bg-gray-600 transition-colors"
              >
                <Share2 className="h-4 w-4 mr-2" />
                Share
              </button>

              {shareMenuOpen && (
                <div className="absolute top-full left-0 mt-2 bg-white dark:bg-[#0B0C0E] rounded-lg shadow-lg border dark:border-gray-700 p-2 z-10">
                  <button
                    onClick={() => handleShare("facebook")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    <Facebook className="h-4 w-4 mr-2 text-[#253237]" />
                    Facebook
                  </button>
                  <button
                    onClick={() => handleShare("twitter")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    <Twitter className="h-4 w-4 mr-2 text-blue-400" />
                    Twitter
                  </button>
                  <button
                    onClick={() => handleShare("linkedin")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    <Linkedin className="h-4 w-4 mr-2 text-gray-700" />
                    LinkedIn
                  </button>
                  <button
                    onClick={() => handleShare("copy")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    {copySuccess ? (
                      <Check className="h-4 w-4 mr-2 text-green-600" />
                    ) : (
                      <Copy className="h-4 w-4 mr-2" />
                    )}
                    {copySuccess ? "Copied!" : "Copy Link"}
                  </button>
                </div>
              )}
            </div>
          </header>

          <div className="bg-white dark:bg-[#0B0C0E] p-6 xs:p-8 sm:p-0 mb-8">
            <div className="prose dark:prose-invert max-w-none">
              <div dangerouslySetInnerHTML={{ __html: post?.content || "" }} />
            </div>
          </div>

          {post?.author.bio && (
            <div className="bg-white dark:bg-[#0B0C0E] rounded-lg shadow-sm p-6 mb-8  border border-gray-300 dark:border-[#26282E]">
              <div className="flex items-start space-x-4">
                <img
                  src={post?.author.avatar}
                  alt={post?.author.name}
                  className="w-16 h-16 rounded-full object-cover"
                />
                <div>
                  <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                    About {post?.author.name}
                  </h3>
                  <p className="text-gray-600 dark:text-gray-300">
                    {post?.author.bio}
                  </p>
                </div>
              </div>
            </div>
          )}

          {relatedPosts.length > 0 && (
            <div className="bg-white dark:bg-[#0B0C0E] rounded-lg shadow-sm p-6  border border-gray-300 dark:border-[#26282E]">
              <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-6">
                Related Posts
              </h3>
              <div className="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
                {relatedPosts.map((relatedPost) => (
                  <Link
                    key={relatedPost.id}
                    href={`/blogs/${relatedPost.slug}`}
                    onClick={() =>
                      window.scrollTo({ top: 0, behavior: "smooth" })
                    }
                    className="group block"
                  >
                    <div className="bg-white dark:bg-[#0B0C0E] border border-gray-300 dark:border-[#26282E] rounded-lg overflow-hidden hover:shadow-md transition-shadow">
                      <img
                        src={relatedPost.featuredImage}
                        alt={relatedPost.title}
                        className="w-full h-32 object-cover group-hover:scale-105 transition-transform duration-300"
                      />
                      <div className="p-4">
                        <h4 className="font-semibold text-gray-900 dark:text-white mb-2 line-clamp-2 group-hover:text-[#253237] dark:group-hover:text-white transition-colors">
                          {relatedPost.title}
                        </h4>
                        <p className="text-sm text-gray-600 dark:text-gray-300 line-clamp-2">
                          {relatedPost.excerpt}
                        </p>
                        <div className="flex items-center mt-3 text-xs text-gray-500 dark:text-gray-400">
                          <Calendar className="h-3 w-3 mr-1" />
                          {formatDate(relatedPost.publishedDate)}
                        </div>
                      </div>
                    </div>
                  </Link>
                ))}
              </div>
            </div>
          )}

          <div className="bg-white dark:bg-[#0B0C0E] rounded-lg shadow-sm p-6 mt-8  border border-gray-300 dark:border-[#26282E]">
            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-4">
              Comments
            </h3>
            <div className="text-center py-8 text-gray-500 dark:text-gray-400">
              <p className="mb-4">Comments section coming soon!</p>
              <p className="text-sm">
                We&apos;re working on adding a comment system to enhance your
                reading experience.
              </p>
            </div>
          </div>
        </article>
        <Footer />
      </div>
    </>
  );
};

export default BlogPostPage;
