/* eslint-disable @next/next/no-img-element */
/* eslint-disable jsx-a11y/alt-text */
"use client";
import React, { useEffect, useRef, useState } from "react";
import { ArrowRightIcon, Ellipsis, Logs } from "lucide-react";
import { FaArrowRight } from "react-icons/fa";
import Link from "next/link";
import Image from "next/image";
import { footerColumns } from "../constants/footerText";
import { useTheme } from "../atoms/theme";
import SidebarDrawer from "../components/sidebarDrawer";
import ThemeSwitch from "../components/themeSwitch";
import { Button } from "../components/button";
import { apps } from "../constants/products";
import illustration from "../../public/images/new7.png";
import {
  LayoutGrid,
  MessageSquare,
  FileSignature,
  Users,
  Kanban,
  FolderClosed,
  Mail,
  Smartphone,
  Heart,
  Megaphone,
  ContactRound,
  BarChart3,
  Briefcase,
  Server,
  Sparkles,
  DollarSign,
  Newspaper,
  Video,
} from "lucide-react";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import ClikkleLogo from "@/components/ClikkleLogo";
import Footer from "@/components/Footer";
import MainHeader from "@/components/MainHeader";
import PreFooterCTA from "../components/PreFooterCTA";
import SecuritySection from "@/components/SecuritySection";
import user1 from "../../public/images/user1.jpeg";
import user3 from "../../public/images/user3.jpeg";
import user5 from "../../public/images/user5.jpeg";
import user7 from "../../public/images/user7.jpeg";

interface AppCardProps {
  icon: React.ElementType;
  name: string;
  description: string;
  comingSoon?: boolean;
  route: string;
}

const AppCard: React.FC<AppCardProps> = ({
  icon: Icon,
  name,
  description,
  comingSoon = false,
  route,
}) => {
  return (
    <Link href={comingSoon ? "#" : route}>
      <div className="relative group h-full">
        <div
          className={`relative h-full flex flex-col p-6 bg-white/70 dark:bg-white/[0.03] backdrop-blur-sm border border-gray-300/80 dark:border-white/20 rounded-3xl overflow-hidden shadow-md shadow-gray-900/10 dark:shadow-white/5 transition-all duration-500 ${
            comingSoon 
              ? "cursor-not-allowed" 
              : "cursor-pointer hover:bg-white dark:hover:bg-white/10 hover:border-gray-400 dark:hover:border-white/30 hover:shadow-2xl hover:shadow-gray-900/20 dark:hover:shadow-white/10 hover:-translate-y-2"
          }`}
        >
          {/* Gradient background effect */}
          <div className="absolute inset-0 bg-gradient-to-br from-transparent via-transparent to-gray-50/50 dark:to-white/5 opacity-0 group-hover:opacity-100 transition-opacity duration-500" />
          
          {/* Content */}
          <div className={`relative z-10 flex flex-col h-full ${comingSoon ? 'blur-sm' : ''}`}>
            <div className="bg-gray-200 dark:bg-gray-800/80 rounded-2xl p-3 w-fit mb-4 group-hover:scale-110 transition-transform duration-300 shadow-sm">
              <Icon className="w-7 h-7 text-gray-900 dark:text-white" />
            </div>
            
            <h3 className="text-lg font-bold text-gray-900 dark:text-white mb-2 group-hover:text-gray-700 dark:group-hover:text-gray-200 transition-colors">
              {name}
            </h3>
            
            <p className="text-sm text-gray-600 dark:text-gray-300 leading-relaxed flex-grow">
              {description}
            </p>
            
            <div className="mt-4 flex items-center text-sm font-semibold text-gray-900 dark:text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300">
              {!comingSoon && (
                <>
                  Explore
                  <ArrowRightIcon className="w-4 h-4 ml-1 group-hover:translate-x-1 transition-transform" />
                </>
              )}
            </div>
          </div>
        </div>
        
        {comingSoon && (
          <div className="absolute inset-0 flex items-center justify-center bg-white/60 dark:bg-black/60 backdrop-blur-md rounded-3xl">
            <span className="px-5 py-2 bg-gray-900 dark:bg-white text-white dark:text-gray-900 rounded-full text-xs font-bold uppercase tracking-wider shadow-lg">
              Coming Soon
            </span>
          </div>
        )}
      </div>
    </Link>
  );
};

interface SectionProps {
  title: string;
  apps: Array<{
    icon: React.ElementType;
    name: string;
    description: string;
    comingSoon?: boolean;
    route: string;
  }>;
}

const Section: React.FC<SectionProps> = ({ title, apps }) => {
  return (
    <div className="mb-20">
      <div className="mb-8">
        <h2 className="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white mb-2">
          {title}
        </h2>
        <div className="h-1 w-16 bg-gradient-to-r from-gray-900 to-gray-600 dark:from-white dark:to-gray-400 rounded-full" />
      </div>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {apps.map((app, index) => (
          <AppCard key={index} {...app} route={app.route} />
        ))}
      </div>
    </div>
  );
};

function AllProducts() {
  const { theme } = useTheme();

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const sections = [
    {
      title: "Collaboration",
      apps: [
        {
          icon: LayoutGrid,
          name: "Hub",
          description: "All-in-one business suite",
          route: "/hub",
        },
        {
          icon: MessageSquare,
          name: "Chat",
          description: "Engage with customers",
          route: "/chat",
        },
        {
          icon: Video,
          name: "Meet",
          description: "Video conferencing made simple",
          route: "/meet",
        },
        {
          icon: FolderClosed,
          name: "Files",
          description: "Simple cloud storage",
          route: "/files",
        },
        {
          icon: FileSignature,
          name: "eSign",
          description: "Sign documents with ease",
          route: "/esign",
        },
      ],
    },
    {
      title: "Human Resources",
      apps: [
        {
          icon: Users,
          name: "HR",
          description: "Tailored for contemporary business",
          route: "/hr",
        },
        {
          icon: Briefcase,
          name: "Crew",
          description: "Team and workforce management",
          comingSoon: true,
          route: "/crew",
        },
      ],
    },
    {
      title: "Projects",
      apps: [
        {
          icon: Kanban,
          name: "Projects",
          description: "Collaborate and manage tasks",
          route: "/projects",
        },
      ],
    },
    {
      title: "Marketing & Sales",
      apps: [
        {
          icon: Megaphone,
          name: "Campaigns",
          description: "Contextually driven marketing",
          route: "/campaigns",
        },
        {
          icon: ContactRound,
          name: "CRM",
          description: "Lead and contact management",
          route: "/crm",
        },
        {
          icon: Mail,
          name: "Cmail",
          description: "Email marketing & communication",
          comingSoon: true,
          route: "/cmail",
        },
        {
          icon: Smartphone,
          name: "SMS",
          description: "Bulk SMS & notifications",
          comingSoon: true,
          route: "/sms",
        },
        {
          icon: Heart,
          name: "Social",
          description: "Social media marketing & management",
          comingSoon: true,
          route: "/social",
        },
        {
          icon: BarChart3,
          name: "Ads",
          description: "Ads management and analytics",
          comingSoon: true,
          route: "/ads",
        },
      ],
    },
    {
      title: "Finance",
      apps: [
        {
          icon: DollarSign,
          name: "Tax",
          comingSoon: true,
          description: "Simple tax management",
          route: "/tax",
        },
      ],
    },
    {
      title: "Media & Outreach",
      apps: [
        {
          icon: Sparkles,
          name: "Creator AI",
          description: "Create any type of content with AI",
          route: "/creator",
        },
        {
          icon: Newspaper,
          name: "News",
          description: "Publish and share news",
          comingSoon: true,
          route: "/news",
        },
        {
          icon: Sparkles,
          name: "Pitch",
          description: "Create and share pitch decks",
          comingSoon: true,
          route: "/pitch",
        },
        {
          icon: Sparkles,
          name: "Launch",
          description: "Promote new product launches",
          comingSoon: true,
          route: "/launch",
        },
        {
          icon: Sparkles,
          name: "KeptUp",
          description: "Stay updated with trending topics",
          comingSoon: true,
          route: "/kept-up",
        },
      ],
    },
    {
      title: "Web Services",
      apps: [
        {
          icon: Server,
          name: "Host",
          description: "Web hosting solutions",
          route: "/host",
        },
        {
          icon: Sparkles,
          name: "Swiprr",
          description: "Discover & swipe through content",
          comingSoon: true,
          route: "/swiprr",
        },
      ],
    },
  ];

  const [productsOpen, setProductsOpen] = useState(false);
  const [dotsOpen, setDotsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();
  }, []);
  return (
    <div className="min-h-screen bg-white dark:bg-[#0B0C0E] transition-colors duration-300">
      <section className="w-full">
        <section className="relative w-full  overflow-hidden">
          <div
            className={`fixed top-0 inset-x-0 z-50 ${
              scrolled
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                : productsOpen || dotsOpen
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1925]/90"
                : ""
            }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <MainHeader/>
          </div>
        </section>
      </section>
      <div
        className={`max-w-7xl mx-auto px-6 ${
          announcementOpen ? "pt-20" : "pt-16"
        }`}
      >
        <div className="text-start my-20">
          <h1 className="text-[2rem] font-eina md:text-[2.5rem] font-bold text-[#253237] dark:text-white">
            <span>One App for Every Need</span>.
          </h1>
        </div>

        {sections.map((section, index) => (
          <Section key={index} title={section.title} apps={section.apps} />
        ))}

        <SecuritySection />
        <PreFooterCTA
          badge="ALL PRODUCTS"
          mobileHeadline="Streamline Operations & Maximize Efficiency"
          desktopHeadline={`Streamline <span class="relative inline-block after:content-[''] after:absolute after:bottom-0 after:left-0 after:right-0 after:h-3 after:bg-gray-300 dark:after:bg-gray-600 after:-z-10 after:rounded-sm">Operations</span> & Maximize Efficiency`}
          description="Organize your business effectively with robust tools and collaborate effortlessly, from any location, at any time."
          buttonText="Start Free Today"
          buttonUrl={`https://hub.clikkle.com/signup?theme=${theme}`}
          userImages={[user1, user3, user5, user7]}
          userCount="50,000+ businesses"
          rating="4.9/5"
          theme={theme}
        />
      </div>

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
}

export default AllProducts;
