"use client";
import React from "react";
import {
  Button,
  Divider,
  IconButton,
  TextField,
  Typography,
} from "@mui/material";
import Link from "next/link";
import Image from "next/image";
import {
  Facebook,
  QuestionMarkRounded,
  Twitter,
  YouTube,
} from "@mui/icons-material";

import { appList } from "../components/appList";
import { Instagram } from "@mui/icons-material";
import AdsHomeFeature, {
  adsFeatures,
} from "../components/features/adsFeatures";

const AdsHome: React.FC = () => {
  return (
    <div className="px-2 py-8 sm:px-6 sm:py-6">
      <div
        id="home-section"
        className="p-4 flex flex-col sm:flex-row mt-0 sm:items-center justify-center sm:justify-start h-[calc(68vh-65px)] ml-2 gap-10"
      >
        <div className="max-w-[600px] px-4 sm:px-8 pb-12 sm:mr-10 gap-6 text-center text-sm">
          <Typography
            variant="h3"
            className="hidden mt-4 font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300 pr-32"
          >
            Revolutionize Your Ads with Clikkle Ads
          </Typography>

          <Typography
            variant="h5"
            className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0 pr-4"
          >
            Revolutionize Your Ads with Clikkle Ads
          </Typography>

          <br className="hidden sm:block" />

          <Typography
            className="hidden font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300"
            style={{ fontSize: "1.1rem" }}
          >
            Revolutionize your advertising with Clikkle&apos;s data-driven
            platform. Get programmatic buying, retargeting, and real-time
            optimization for maximum ROI. Join now.
          </Typography>
          <Typography
            className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0"
            style={{ fontSize: "0.8rem" }}
          >
            Revolutionize your advertising with Clikkle&apos;s data-driven
            platform. Get programmatic buying, retargeting, and real-time
            optimization for maximum ROI. Join now.
          </Typography>

          <br className="hidden sm:block" />

          <div className="flex flex-col items-center gap-2 mt-2 sm:flex-row sm:gap-4">
            <TextField
              size="small"
              placeholder="Enter email"
              className="w-full sm:w-auto sm:mb-0 sm:pl-2"
              style={{ marginTop: 12 }}
            />
            <Button
              size="large"
              variant="contained"
              className="w-full -mt-12 sm:w-auto sm:mb-0 sm:pl-2"
            >
              <Link
                href={
                  "https://hub.clikkle.com/signup?referralApp=Clikkle%20Website&&?redirectto=https%3A%2F%2Fads.clikkle.com%2F&&referrer=https://www.clikkle.com/ads"
                }
              >
                Try Ads for Free
              </Link>
            </Button>
          </div>

          <div className="flex flex-col items-center mt-6 sm:flex-row sm:justify-start sm:gap-0">
            <p className="text-sm dark:text-white sm:mr-2">
              Don&apos;t have an account?
            </p>
            <Link
              href={
                "https://hub.clikkle.com/signup?referralApp=Clikkle%20Website&&?redirectto=https%3A%2F%2Fads.clikkle.com%2F&&referrer=https://www.clikkle.com/ads"
              }
              className="flex-grow text-sm text-blue-500 sm:flex-grow-0"
            >
              Sign up at no cost
            </Link>
          </div>
        </div>

        <div className="items-center justify-center hidden ml-16 sm:flex ">
          <Image
            src="https://cdn.clikkle.com/images/ads/illustration/ads1.png"
            className="h-72 w-auto lg:h-[calc(105vh-300px)] sm:h-[calc(60vh-300px)]"
            alt="Banner"
            width={600}
            height={400}
          />
        </div>
      </div>

      <br className="hidden sm:block" />

      <div className="flex flex-col items-center justify-center gap-5 sm:mt-7">
        {adsFeatures.map((feature, index) => (
          <AdsHomeFeature
            key={feature.name}
            {...{ adsFeatures: feature, left: index % 2 === 0 }}
          />
        ))}
      </div>
      <div
        id="pricing"
        className="h-[calc(100vh-100px)] flex flex-col items-center justify-center gap-10 mt-12 pt-10"
      >
        <Typography
          variant="h4"
          className="text-2xl  [text-stroke:1px_#000] font-boldtext-center text-gray-800 sm:text-left dark:text-gray-300"
        >
          Discover the perfect app for you
        </Typography>

        <div className="flex gap-8 items-center justify-center flex-wrap max-w-[1000px]">
          {appList.map((app) => (
            <div
              key={app.name}
              className="flex flex-col items-center justify-center gap-2"
            >
              <Link href={app.link}>
                <Image
                  src={app.logo}
                  alt={app.name}
                  className="w-[20px] h-[20px]"
                  width={20}
                  height={20}
                />
              </Link>
              <Link href={app.link}>
                <Typography className="text-xs">{app.name}</Typography>
              </Link>
            </div>
          ))}
        </div>
      </div>

      <div
        id="overview"
        className="h-[calc(100vh-100px)] flex flex-col items-center justify-center gap-8 mt-10 pt-10"
      >
        <Typography
          variant="h4"
          className="text-2xl text-center text-gray-800 sm:text-left dark:text-gray-300"
        >
          Robust Platform Maximizes Ads Results
        </Typography>

        <br className="hidden sm:block" />

        <Image
          src="https://cdn.clikkle.com/images/ads/logo/2023/ads.png"
          className="h-[80px] w-[80px]"
          alt="Ads logo"
          width={80}
          height={80}
        />

        <br className="hidden sm:block" />

        <div className="max-w-[600px] flex flex-col items-center justify-center">
          <Typography className="text-center">
            Maximize your ad ROI with Clikkle&apos;s AI-powered platform.
            Real-time programmatic buying, dynamic retargeting, and
            hyper-targeted geofencing. Join now for data-driven success.
          </Typography>

          <br className="hidden sm:block" />

          <Link
            href="https://clikkle.com/learnmore"
            className="font-bold text-blue-400"
          >
            Learn more about Clikkle Ads
          </Link>
        </div>
      </div>

      <div id="getStarted" className="h-[calc(100vh-65px)] flex flex-col">
        <div className="flex flex-col items-center justify-center flex-grow gap-8">
          <Typography
            variant="h4"
            className="text-2xl text-center text-gray-800 sm:text-left dark:text-gray-300"
          >
            Ready to get Started?
          </Typography>

          <div className="flex items-center justify-center gap-4">
            <Button variant="contained" size="small">
              <Link href="https://hub.clikkle.com/signup?referralApp=Clikkle%20Website&&?redirectto=https%3A%2F%2Fads.clikkle.com%2F&&referrer=https://www.clikkle.com/ads">
                Try Clikkle Ads for Free
              </Link>
            </Button>
            <Button variant="outlined" size="small">
              <Link href="https://hub.clikkle.com/login?referralApp=Clikkle%20Website&&?redirectto=https://ads.clikkle.com&&referrer=https://www.clikkle.com/ads">
                Go to Clikkle Ads
              </Link>
            </Button>
          </div>
        </div>

        <div className="flex items-center gap-4 p-4">
          <Typography className="text-gray-700 dark:text-gray-200">
            Follow our blog
          </Typography>
          <IconButton>
            <Link href="https://www.youtube.com/clikkle">
              <YouTube />
            </Link>
          </IconButton>

          <IconButton>
            <Link href="https://twitter.com/myclikkle">
              <Twitter />
            </Link>
          </IconButton>

          <IconButton>
            <Link href="https://facebook.com/clikkle">
              <Facebook />
            </Link>
          </IconButton>
          <IconButton>
            <Link href="https://www.instagram.com/myclikkle">
              <Instagram />
            </Link>
          </IconButton>
        </div>
      </div>

      <Divider />

      <div className="flex flex-col items-center justify-between gap-4 p-4 py-4 sm:py-4 sm:flex-row sm:gap-8">
        <div className="flex items-center gap-2 sm:gap-4">
          <Link href={"https://clikkle.com"}>
            <Typography className="text-gray-600 dark:text-gray-300">
              Clikkle
            </Typography>
          </Link>
          <Link href={"https://clikkle.com/about"}>
            <Typography className="text-gray-600 dark:text-gray-300">
              About
            </Typography>
          </Link>
          <Link href={"https://clikkle.com/products"}>
            <Typography className="text-gray-600 dark:text-gray-300">
              Products
            </Typography>
          </Link>
          <Link href={"https://careers.clikkle.com"}>
            <Typography className="text-gray-600 dark:text-gray-300">
              Careers
            </Typography>
          </Link>
          <Link href={"/privacy-policy"}>
            <Typography className="text-gray-600 dark:text-gray-300">
              Privacy
            </Typography>
          </Link>
          <Link href={"/terms-of-service"}>
            <Typography className="text-gray-600 dark:text-gray-300">
              Terms
            </Typography>
          </Link>
        </div>

        <div className="flex items-center gap-2 sm:gap-4">
          <IconButton>
            <Link href="https://support.clikkle.com">
              <QuestionMarkRounded className="text-gray-600 dark:text-gray-300" />
            </Link>
          </IconButton>

          <Typography className="text-gray-600 dark:text-gray-300">
            <Link href="https://support.clikkle.com">Help</Link>
          </Typography>
          <div className="border-gray-300 dark:border-gray-600 border-[1px] rounded-md px-6 py-[6px]">
            <Typography className="text-gray-600 dark:text-gray-300">
              English
            </Typography>
          </div>
        </div>
      </div>
    </div>
  );
};

export default AdsHome;
