"use client";
import { Button } from "../components/button";
import SidebarDrawer from "../components/sidebarDrawer";
import { FaArrowRight } from "react-icons/fa";
import { ArrowRightIcon, Ellipsis, Logs, CheckCircle2, Users, Zap, Shield } from "lucide-react";
import ThemeSwitch from "../components/themeSwitch";
import { useTheme } from "../atoms/theme";
import { useEffect, useRef, useState } from "react";
import { apps } from "../constants/products";
import Link from "next/link";
import { footerColumns } from "../constants/footerText";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import ClikkleLogo from "../components/ClikkleLogo";
import Footer from "@/components/Footer";
import { iconMap } from "../utils/iconMap";
import HeroSection from "@/components/HeroSection";
import MainHeader from "@/components/MainHeader";

/* eslint-disable @next/next/no-img-element */

export default function AboutPage() {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);
  const [productsOpen, setProductsOpen] = useState(false);

  const productsRef = useRef<HTMLDivElement>(null);

  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (!el) return;
      if (el.offsetHeight === 0) {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);

  // Values data
  const values = [
    {
      icon: Users,
      title: "People First",
      description: "We build for humans, not corporations. Every feature starts with understanding the real needs of independent workers and small teams."
    },
    {
      icon: Zap,
      title: "Simple by Design",
      description: "Complexity is easy. Simplicity is hard. We obsess over making powerful tools feel effortless to use."
    },
    {
      icon: Shield,
      title: "Trust & Transparency",
      description: "Your data is yours. We don't sell it, we don't exploit it. We earn revenue by serving your growth, not by surveillance."
    },
    {
      icon: CheckCircle2,
      title: "Quality Over Hype",
      description: "We ship features that work, not promises that don't. Our reputation is built on reliability and real value."
    }
  ];

  const stats = [
    { number: "100K+", label: "Active Users" },
    { number: "15+", label: "Integrated Apps" },
    { number: "99.9%", label: "Uptime" },
    { number: "$0", label: "To Start" }
  ];

  return (
    <div className="min-h-screen bg-white dark:bg-[#0B0C0E]">
      <section className="w-full">
        <section className="relative w-full overflow-hidden">
          <div
            className={`fixed top-0 inset-x-0 z-50 ${
              scrolled
                ? "backdrop-blur-md bg-white/90 dark:bg-[#0B0C0E]/90"
                : productsOpen || dotsOpen
                ? "backdrop-blur-md bg-white/90 dark:bg-[#0B0C0E]/90"
                : ""
            }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <MainHeader/>
          </div>
        </section>
      </section>

      {/* Hero Section */}
      <HeroSection
        announcementOpen={announcementOpen}
        badge={{
          text: "Built by creators, for creators",
          showPulse: true,
        }}
        title={{
          beforeHighlight: "Why pay more when you can",
          highlight: "pay less",
          afterHighlight: "for the same power?",
        }}
        description={{
          desktop: (
            <>
              Wurknest gives you enterprise-grade tools at a price that makes sense for your business. 
              Instead of juggling <span className="font-semibold text-gray-900 dark:text-white">5+ expensive subscriptions</span>, 
              get everything in one place with <span className="font-semibold text-gray-900 dark:text-white">transparent, pay-as-you-grow pricing</span> that scales with your success—not against it.
            </>
          ),
          mobile: (
            <>
              Get enterprise tools without juggling <span className="font-semibold text-gray-900 dark:text-white">5+ expensive subscriptions</span>. <span className="font-semibold text-gray-900 dark:text-white">Pay as you grow</span>
            </>
          ),
        }}
        cta={{
          primary: {
            text: "Start Today →",
            onClick: () => {
              window.location.replace(
                "https://hub.clikkle.com/signup?theme=" + theme
              );
            },
          },
          secondary: {
            text: "See Pricing",
            href: "#pricing",
          },
        }}
        trustIndicators={[
          { text: "Start free" },
          { text: "Pay as you use" },
          { text: "Cancel anytime" },
        ]}
      />

      {/* Mission Section with Image */}
      <section id="mission" className="px-4 md:px-6 pb-12 md:pb-20 max-w-7xl mx-auto container">
        <div className="grid md:grid-cols-2 gap-8 md:gap-12 items-center">
          <div>
            <p className="text-xs md:text-sm text-[#253237] dark:text-white mb-3 md:mb-4 font-bold uppercase tracking-wide">
              Our Mission
            </p>
            <h2 className="text-[24px] md:text-[3rem] font-extrabold text-gray-900 dark:text-white leading-tight mb-4 md:mb-6">
              Built for the <span className="text-[#253237] dark:text-white">hustle</span>
            </h2>
            <div className="space-y-3 md:space-y-4 text-sm md:text-base text-gray-700 dark:text-gray-300 leading-relaxed">
              <p>
                We started Wurknest because we were frustrated<span className="hidden md:inline">. Frustrated watching talented freelancers and small teams juggle 5+ expensive subscriptions just to run their business</span><span className="md:hidden"> watching teams juggle 5+ subscriptions</span>.
              </p>
              <p className="hidden md:block">
                Big tech builds for corporate boardrooms. We build for the creators, the dreamers, the independent workers who need professional tools without the corporate tax.
              </p>
              <p className="font-semibold text-gray-900 dark:text-white">
                Great tools shouldn&apos;t cost a fortune.
              </p>
            </div>
          </div>
          <div className="relative h-[300px] md:h-[400px] lg:h-[500px]">
            <img
              src="https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=800&h=600&fit=crop"
              alt="Team collaboration"
              className="w-full h-full object-cover rounded-2xl shadow-2xl"
            />
          </div>
        </div>
      </section>

      {/* Values Section */}
      <section className="px-4 md:px-6 pb-12 md:pb-20 max-w-7xl mx-auto container">
        <div className="text-center mb-12 md:mb-16">
          <div className="inline-flex items-center gap-2 bg-gray-100 dark:bg-[#16171B] border border-gray-200 dark:border-[#26282E] rounded-full px-3 md:px-4 py-1.5 md:py-2 mb-4 md:mb-6">
            <Shield className="w-3 md:w-4 h-3 md:h-4 text-[#253237] dark:text-white" />
            <span className="text-xs md:text-sm font-semibold text-[#253237] dark:text-white">
              Our Core Values
            </span>
          </div>
          <h2 className="text-[24px] md:text-[3.5rem] font-extrabold text-gray-900 dark:text-white mb-4 md:mb-6 leading-tight px-2">
            Built on{" "}
            <span className="text-[#253237] dark:text-white">Principles</span>
            {" "}That Matter
          </h2>
          <p className="text-sm md:text-lg lg:text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto leading-relaxed px-2">
            <span className="hidden md:inline">These aren&apos;t just words on a wall. They&apos;re the foundation of every feature we build, 
            every decision we make, and every interaction we have with our community.</span>
            <span className="md:hidden">The foundation of everything we build.</span>
          </p>
        </div>

        <div className="grid md:grid-cols-2 gap-4 md:gap-6 lg:gap-8">
          {values.map((value, index) => {
            const IconComponent = value.icon;
            return (
              <div
                key={index}
                className="group relative p-6 md:p-8 lg:p-10 rounded-2xl bg-gradient-to-br from-white to-gray-50 dark:from-[#16171B] dark:to-[#0B0C0E] border border-gray-200 dark:border-[#26282E] hover:border-[#253237] dark:hover:border-white transition-all duration-300 hover:shadow-2xl hover:-translate-y-1"
              >
                {/* Decorative corner accent */}
                <div className="absolute top-0 right-0 w-20 h-20 bg-[radial-gradient(circle,_rgba(37,50,55,0.1)_0%,transparent_70%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.05)_0%,transparent_70%)] rounded-2xl" />
                
                <div className="relative">
                  {/* Icon with animated background */}
                  <div className="relative inline-flex mb-4 md:mb-6">
                    <div className="absolute inset-0 bg-[#253237] dark:bg-white rounded-2xl opacity-10 group-hover:opacity-20 transition-opacity" />
                    <div className="relative w-12 md:w-14 h-12 md:h-14 rounded-2xl bg-[#253237] dark:bg-white flex items-center justify-center group-hover:scale-110 transition-transform duration-300 shadow-lg">
                      <IconComponent className="w-6 md:w-7 h-6 md:h-7 text-white dark:text-[#253237]" />
                    </div>
                  </div>

                  {/* Number badge */}
                  <div className="absolute top-0 right-0 w-7 md:w-8 h-7 md:h-8 rounded-full bg-gray-100 dark:bg-[#253237] border-2 border-white dark:border-[#16171B] flex items-center justify-center">
                    <span className="text-[10px] md:text-xs font-bold text-[#253237] dark:text-white">
                      {String(index + 1).padStart(2, '0')}
                    </span>
                  </div>

                  <h3 className="text-lg md:text-2xl font-extrabold text-gray-900 dark:text-white mb-2 md:mb-3 group-hover:text-[#253237] dark:group-hover:text-white transition-colors">
                    {value.title}
                  </h3>
                  
                  <p className="text-sm md:text-base text-gray-600 dark:text-gray-400 leading-relaxed">
                    {value.description}
                  </p>

                  {/* Bottom accent line */}
                  <div className="mt-4 md:mt-6 h-1 w-12 md:w-16 bg-gradient-to-r from-[#253237] to-transparent dark:from-white group-hover:w-20 md:group-hover:w-24 transition-all duration-300 rounded-full" />
                </div>
              </div>
            );
          })}
        </div>

        {/* Bottom CTA */}
        <div className="mt-16 text-center">
          <div className="inline-flex flex-col sm:flex-row items-center gap-4 bg-gray-100 dark:bg-[#16171B] border border-gray-200 dark:border-[#26282E] rounded-2xl p-6 md:p-8">
            <div className="flex-1 text-left">
              <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-2">
                See Our Values in Action
              </h3>
              <p className="text-sm text-gray-600 dark:text-gray-400">
                Experience how our principles translate into powerful, user-friendly tools.
              </p>
            </div>
            <Link
              href="/products"
              className="whitespace-nowrap bg-[#253237] dark:bg-white text-white dark:text-[#253237] px-6 py-3 rounded-xl font-semibold hover:bg-[#1a2428] dark:hover:bg-gray-100 transition-all duration-300 shadow-lg hover:shadow-xl hover:scale-105 flex items-center gap-2"
            >
              Explore Products
              <ArrowRightIcon className="w-4 h-4" />
            </Link>
          </div>
        </div>
      </section>

      {/* Why Optimal Pricing Section */}
      <section id="pricing" className="px-4 md:px-6 pb-12 md:pb-20 max-w-7xl mx-auto container">
        <div className="relative overflow-hidden bg-gradient-to-br from-[#253237] via-[#1a2428] to-[#253237] dark:from-[#16171B] dark:via-[#0B0C0E] dark:to-[#16171B] rounded-2xl md:rounded-3xl p-6 md:p-10 lg:p-12 border border-[#ffffff1a] shadow-2xl">
          {/* Animated background effects */}
          <div className="absolute inset-0">
            <div className="absolute top-0 right-0 w-[500px] h-[500px] bg-[radial-gradient(circle,_rgba(255,255,255,0.1)_0%,transparent_70%)] animate-pulse" />
            <div className="absolute bottom-0 left-0 w-[500px] h-[500px] bg-[radial-gradient(circle,_rgba(255,255,255,0.05)_0%,transparent_70%)]" />
          </div>

          <div className="relative z-10 grid md:grid-cols-2 gap-8 md:gap-10 lg:gap-12 items-center">
            {/* Left Content */}
            <div>
              <div className="inline-flex items-center gap-2 bg-white/10 backdrop-blur-sm border border-white/20 rounded-full px-3 md:px-4 py-1.5 md:py-2 mb-4 md:mb-6">
                <CheckCircle2 className="w-3 md:w-4 h-3 md:h-4 text-white" />
                <span className="text-xs md:text-sm font-semibold text-white">
                  Transparent Pricing Model
                </span>
              </div>

              <h2 className="text-[24px] md:text-[2.5rem] lg:text-[3rem] font-extrabold mb-4 md:mb-5 text-white leading-tight">
                Pricing That{" "}
                <span className="relative inline-block">
                  <span className="relative z-10">Grows</span>
                  <span className="absolute bottom-1 md:bottom-2 left-0 w-full h-2 md:h-3 bg-white/20 -rotate-1"></span>
                </span>
                <br />
                With You
              </h2>

              {/* Feature List */}
              <div className="space-y-3 md:space-y-4 mb-6 md:mb-7">
                {[
                  {
                    title: "Fair & Transparent",
                    desc: "Start with generous free tiers, pay only for advanced features as you grow."
                  },
                  {
                    title: "No Hidden Fees",
                    desc: "No surprise charges. No paying for seats you don't use. What you see is what you pay."
                  },
                  {
                    title: "Mix & Match",
                    desc: "Use 2 apps or 15—you're only charged for what adds value to your workflow."
                  },
                  {
                    title: "Profit-Focused",
                    desc: "Pricing designed to make your business more profitable, not drain your budget."
                  }
                ].map((item, idx) => (
                  <div key={idx} className="flex gap-3 group">
                    <div className="flex-shrink-0 w-7 md:w-8 h-7 md:h-8 rounded-lg bg-white/10 backdrop-blur-sm flex items-center justify-center group-hover:bg-white/20 transition-colors">
                      <CheckCircle2 className="w-4 md:w-5 h-4 md:h-5 text-white" />
                    </div>
                    <div>
                      <h4 className="font-bold text-white mb-0.5 md:mb-1 text-sm md:text-base">{item.title}</h4>
                      <p className="text-white/80 text-xs md:text-sm leading-relaxed">{item.desc}</p>
                    </div>
                  </div>
                ))}
              </div>

              <div className="flex flex-col sm:flex-row gap-3 md:gap-4">
                <button
                  onClick={() => {
                    window.location.replace(
                      "https://hub.clikkle.com/signup?theme=" + theme
                    );
                  }}
                  className="w-full sm:w-auto bg-white text-[#253237] px-6 md:px-8 py-3 md:py-4 rounded-xl font-bold hover:bg-gray-100 transition-all duration-300 shadow-xl hover:shadow-2xl hover:scale-105 text-sm md:text-base"
                >
                  Start Free Today
                </button>
                <Link
                  href="/products"
                  className="w-full sm:w-auto bg-white/10 backdrop-blur-sm text-white border-2 border-white/30 px-6 md:px-8 py-3 md:py-4 rounded-xl font-bold hover:bg-white/20 transition-all duration-300 text-center text-sm md:text-base"
                >
                  View Pricing
                </Link>
              </div>
            </div>

            {/* Right Visual */}
            <div className="relative hidden md:block">
              {/* Pricing Cards Stack */}
              <div className="relative h-[380px] lg:h-[420px]">
                {/* Card 3 - Background */}
                <div className="absolute top-6 lg:top-8 right-0 w-full h-[160px] lg:h-[180px] bg-white/5 backdrop-blur-sm rounded-2xl border border-white/10 transform rotate-3 shadow-xl" />
                
                {/* Card 2 - Middle */}
                <div className="absolute top-3 lg:top-4 right-0 w-full h-[180px] lg:h-[200px] bg-white/10 backdrop-blur-sm rounded-2xl border border-white/20 transform rotate-1 shadow-xl" />
                
                {/* Card 1 - Front (Main) */}
                <div className="absolute top-0 right-0 w-full bg-white/20 backdrop-blur-md rounded-2xl border border-white/30 p-6 lg:p-7 shadow-2xl transform hover:scale-105 transition-transform duration-300">
                  <div className="flex items-center justify-between mb-4 lg:mb-5">
                    <div className="inline-flex items-center gap-1.5 bg-white/20 rounded-full px-2.5 py-0.5 lg:px-3 lg:py-1">
                      <span className="text-[10px] lg:text-xs font-bold text-white">FLEXIBLE</span>
                    </div>
                    <Zap className="w-5 h-5 lg:w-6 lg:h-6 text-white" />
                  </div>
                  
                  <div className="mb-3 lg:mb-4">
                    <div className="text-4xl lg:text-5xl font-extrabold text-white mb-1.5 lg:mb-2">$0</div>
                    <div className="text-white/80 text-xs lg:text-sm">to start • Pay as you grow</div>
                  </div>

                  <div className="space-y-2 lg:space-y-2.5 mb-4 lg:mb-5">
                    {["Free tier on all apps", "15+ integrated tools", "No credit card needed", "Upgrade anytime"].map((feature, i) => (
                      <div key={i} className="flex items-center gap-2">
                        <div className="w-4 lg:w-5 h-4 lg:h-5 rounded-full bg-white/20 flex items-center justify-center flex-shrink-0">
                          <CheckCircle2 className="w-2.5 lg:w-3 h-2.5 lg:h-3 text-white" />
                        </div>
                        <span className="text-white/90 text-xs lg:text-sm">{feature}</span>
                      </div>
                    ))}
                  </div>

                  <div className="pt-3 lg:pt-4 border-t border-white/20">
                    <div className="text-white/60 text-[10px] lg:text-xs uppercase tracking-wider mb-1.5 lg:mb-2">Trusted by</div>
                    <div className="flex items-center gap-2">
                      <div className="flex -space-x-1.5 lg:-space-x-2">
                        <img 
                          src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=100&h=100&fit=crop&crop=faces" 
                          alt="User" 
                          className="w-5 lg:w-6 h-5 lg:h-6 rounded-full border-2 border-white/50 object-cover"
                        />
                        <img 
                          src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=100&h=100&fit=crop&crop=faces" 
                          alt="User" 
                          className="w-5 lg:w-6 h-5 lg:h-6 rounded-full border-2 border-white/50 object-cover"
                        />
                        <img 
                          src="https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=100&h=100&fit=crop&crop=faces" 
                          alt="User" 
                          className="w-5 lg:w-6 h-5 lg:h-6 rounded-full border-2 border-white/50 object-cover"
                        />
                      </div>
                      <span className="text-white/90 text-xs lg:text-sm font-semibold">100K+ Users</span>
                    </div>
                  </div>
                </div>

                <div className="absolute bottom-8 lg:bottom-12 -left-6 lg:-left-8 bg-white rounded-xl px-3 lg:px-4 py-1.5 lg:py-2 shadow-xl border border-gray-200">
                  <div className="text-[10px] lg:text-xs text-gray-600 mb-0.5 lg:mb-1">Save up to</div>
                  <div className="text-xl lg:text-2xl font-bold text-[#253237]">70%</div>
                </div>
              </div>
            </div>
          </div>

          {/* Bottom Stats Bar */}
          <div className="relative z-10 mt-8 md:mt-10 lg:mt-12 pt-6 md:pt-7 lg:pt-8 border-t border-white/10">
            <div className="grid grid-cols-2 md:grid-cols-4 gap-4 md:gap-5 lg:gap-6">
              {[
                { label: "Average Savings", value: "$400/mo" },
                { label: "Apps Included", value: "15+" },
                { label: "Free Forever", value: "Core Tier" },
                { label: "Support", value: "24/7" }
              ].map((stat, i) => (
                <div key={i} className="text-center">
                  <div className="text-xl md:text-2xl lg:text-3xl font-extrabold text-white mb-0.5 md:mb-1">{stat.value}</div>
                  <div className="text-white/60 text-[10px] md:text-xs lg:text-sm">{stat.label}</div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="px-4 md:px-6 pb-12 md:pb-20 max-w-7xl mx-auto container">
        <div className="relative overflow-hidden bg-gradient-to-br from-gray-50 to-gray-100 dark:from-[#16171B] dark:to-[#0B0C0E] rounded-2xl md:rounded-3xl p-6 md:p-16 border border-gray-200 dark:border-[#26282E] shadow-2xl">
          {/* Background decorative elements */}
          <div className="absolute top-0 right-0 w-96 h-96 bg-[radial-gradient(circle,_rgba(37,50,55,0.1)_0%,transparent_70%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.05)_0%,transparent_70%)]" />
          <div className="absolute bottom-0 left-0 w-96 h-96 bg-[radial-gradient(circle,_rgba(37,50,55,0.08)_0%,transparent_70%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.03)_0%,transparent_70%)]" />
          
          <div className="relative z-10 text-center max-w-4xl mx-auto">
            {/* Badge */}
            <div className="inline-flex items-center gap-2 bg-white dark:bg-[#253237] border border-gray-300 dark:border-[#ffffff3a] rounded-full px-4 py-2 mb-6 shadow-lg">
              <Zap className="w-4 h-4 text-[#253237] dark:text-white" />
              <span className="text-sm font-semibold text-[#253237] dark:text-white">
                Ready to Transform?
              </span>
            </div>

            {/* Mobile headline */}
            <h2 className="md:hidden text-[32px] font-extrabold text-gray-900 dark:text-white mb-4 leading-tight">
              Start Building Better Today
            </h2>
            
            {/* Desktop headline */}
            <div className="hidden md:block mb-6">
              <h2 className="text-[40px] md:text-[56px] leading-none font-extrabold text-gray-900 dark:text-white mb-2">
                Transform Your{" "}
                <span className="text-[#253237] dark:text-white relative">
                  Workflow
                </span>
              </h2>
              <h3 className="text-[40px] md:text-[56px] font-extrabold text-gray-900 dark:text-white leading-tight">
                Scale Your Business
              </h3>
            </div>

            <p className="text-gray-600 dark:text-gray-400 text-base md:text-lg font-medium max-w-2xl mx-auto mb-8">
              Join thousands of teams streamlining operations and driving growth with our all-in-one platform. Start free, scale fast.
            </p>

            {/* Email Form */}
            <div className="w-full max-w-2xl mx-auto flex flex-col items-center gap-4 mb-8">
              <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                <input
                  type="email"
                  placeholder="Enter Your Email"
                  className="flex-1 px-5 py-4 rounded-xl bg-white/80 dark:bg-black/40 backdrop-blur-sm text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#253237] dark:focus:ring-white/20 w-full border border-gray-300 dark:border-white/10 shadow-lg transition-all duration-300 hover:bg-white dark:hover:bg-black/60"
                />
                <button
                  onClick={() => {
                    window.location.replace(
                      "https://hub.clikkle.com/signup?theme=" + theme
                    );
                  }}
                  className="cursor-pointer px-8 py-4 bg-[#253237] dark:bg-white text-white dark:text-[#253237] font-bold rounded-xl transition-all duration-300 w-full sm:w-auto shadow-xl hover:shadow-2xl hover:scale-105 hover:bg-[#1a2329] dark:hover:bg-gray-100"
                >
                  Get Started Free
                </button>
              </div>

              {/* Terms Checkbox */}
              <div className="flex items-start gap-3 text-xs md:text-sm text-gray-600 dark:text-gray-400">
                <label className="relative flex items-center h-full cursor-pointer mt-0.5">
                  <input
                    type="checkbox"
                    id="terms"
                    aria-label="Agree to terms and conditions"
                    defaultChecked
                    className="peer appearance-none h-5 w-5 border-2 border-gray-300 dark:border-gray-600 rounded-md bg-white/50 dark:bg-black/50 backdrop-blur-sm checked:bg-[#253237] dark:checked:bg-white checked:border-[#253237] dark:checked:border-white transition duration-200"
                  />
                  <span className="absolute left-0 top-0 h-5 w-5 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white dark:peer-checked:before:text-[#253237] peer-checked:before:text-xs peer-checked:before:font-bold"></span>
                </label>

                <span className="leading-5 font-medium">
                  I agree with the{" "}
                  <Link
                    href="/terms-of-service"
                    className="underline text-gray-900 dark:text-white hover:text-[#253237] dark:hover:text-gray-300 transition-colors font-semibold"
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    Terms and Conditions
                  </Link>
                </span>
              </div>
            </div>

            {/* Trust Indicators */}
            <div className="flex items-center gap-6 flex-wrap justify-center">
              <div className="flex items-center gap-2">
                <div className="flex -space-x-2">
                  <img src="https://i.pravatar.cc/150?img=12" alt="User" className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover" />
                  <img src="https://i.pravatar.cc/150?img=26" alt="User" className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover" />
                  <img src="https://i.pravatar.cc/150?img=47" alt="User" className="w-8 h-8 rounded-full border-2 border-white dark:border-black object-cover" />
                </div>
                <span className="text-xs font-semibold text-gray-900 dark:text-white">100,000+ users</span>
              </div>
              <div className="flex items-center gap-1">
                {[...Array(5)].map((_, i) => (
                  <svg key={i} className="w-4 h-4 text-[#253237] dark:text-white" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                ))}
                <span className="text-xs font-semibold text-gray-900 dark:text-white ml-1">4.9/5</span>
              </div>
            </div>
          </div>
        </div>
      </section>

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
}
