import { Metadata } from "next";
import TermOfServiceComponent from "../../clikklepages/termOfService";

export const metadata: Metadata = {
  title: "Terms of Service | Wurknest Business Suite - Legal Terms",
  description: "Review Wurknest's terms of service for using our business suite. Understand your rights, responsibilities, and the legal terms governing our CRM, HR, project management, and other business tools.",
  keywords: "terms of service, legal terms, business software terms, clikkle terms, service agreement, user agreement, business suite terms, legal agreement",
  openGraph: {
    title: "Terms of Service | Wurknest Business Suite - Legal Terms",
    description: "Review Wurknest's terms of service for using our business suite. Understand your rights and responsibilities.",
    url: "https://clikkle.com/terms-of-service",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Terms of Service",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Terms of Service | Wurknest Business Suite - Legal Terms",
    description: "Review Wurknest's terms of service for using our business suite.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/terms-of-service",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function TermsOfServiceHome() {
  return <TermOfServiceComponent />;
}