import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Wurknest | Customer Support Software | Help Desk System",
  description: "Deliver exceptional customer support with Wurknest's support software. Ticket management, help desk system, customer service tools, and comprehensive support analytics to improve customer satisfaction.",
  keywords: "customer support software, help desk system, ticket management, customer service, support tools, help desk software, customer support platform, support analytics",
  openGraph: {
    title: "Wurknest | Customer Support Software | Help Desk System",
    description: "Deliver exceptional customer support with Wurknest's support software. Ticket management and help desk system.",
    url: "https://clikkle.com/support",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Customer Support Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest | Customer Support Software | Help Desk System",
    description: "Deliver exceptional customer support with Wurknest's support platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/support",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function SupportHome() {
      return (
        <ComingSoon/>
    )
}