import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Wurknest Social | Social Media Management Software | Social Media Tools",
  description: "Manage social media efficiently with Wurknest's social media management software. Schedule posts, track engagement, analyze performance, and manage multiple social accounts from one platform.",
  keywords: "social media management, social media tools, social media scheduling, content management, social media analytics, social media platform, social media automation",
  openGraph: {
    title: "Wurknest Social | Social Media Management Software | Social Media Tools",
    description: "Manage social media efficiently with Wurknest's social media management platform. Schedule posts and track engagement.",
    url: "https://clikkle.com/social",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Social Media Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest Social | Social Media Management Software | Social Media Tools",
    description: "Manage social media efficiently with Wurknest's social media management platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/social",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function SocialHome() {
    return (
        <ComingSoon/>
    )
}