import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Wurknest SMS | SMS Marketing Software | Business Text Messaging",
  description: "Reach customers instantly with Wurknest's SMS marketing software. Send bulk text messages, automate SMS campaigns, track delivery rates, and engage customers with our powerful business texting platform.",
  keywords: "SMS marketing, text messaging software, bulk SMS, business texting, SMS campaigns, text message marketing, SMS automation, business SMS",
  openGraph: {
    title: "Wurknest SMS | SMS Marketing Software | Business Text Messaging",
    description: "Reach customers instantly with Wurknest's SMS marketing software. Send bulk text messages and automate SMS campaigns.",
    url: "https://clikkle.com/sms",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest SMS Marketing Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest SMS | SMS Marketing Software | Business Text Messaging",
    description: "Reach customers instantly with Wurknest's SMS marketing platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/sms",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function SMSHome() {
     return (
        <ComingSoon/>
    )
}