import { Metadata } from "next";
import ProjectsHomePage from "../../clikklepages/projectsHome";

export const metadata: Metadata = {
  title: "Wurknest Projects | Project Management Software | Team Collaboration",
  description: "Manage projects efficiently with Wurknest's project management software. Track tasks, collaborate with teams, set deadlines, monitor progress, and deliver projects on time with our comprehensive project management platform.",
  keywords: "project management software, task management, team collaboration, project tracking, deadline management, project planning, team productivity, project dashboard",
  openGraph: {
    title: "Wurknest Projects | Project Management Software | Team Collaboration",
    description: "Manage projects efficiently with Wurknest's project management platform. Track tasks, collaborate with teams, and deliver on time.",
    url: "https://clikkle.com/projects",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Project Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest Projects | Project Management Software | Team Collaboration",
    description: "Manage projects efficiently with Wurknest's project management platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/projects",
  },
    icons: {
    icon: "/icon.png?v=2",
    apple:
      "/icon.png?v=2",
  },
};

export default function ProjectsHome() {
  return <ProjectsHomePage />;
}