import AllProducts from "@/clikklepages/allProducts";
import { Metadata } from "next";
export const metadata: Metadata = {
  title: "All Products | Wurknest Business Suite",
  description:
    "Explore all products offered by Wurknest Business Suite. Discover our comprehensive range of business solutions designed to streamline your operations.",
  keywords:
    "clikkle products, business solutions, clikkle business suite, business tools, productivity software",
  openGraph: {
    title: "All Products | Wurknest Business Suite",
    description: "Explore all products offered by Wurknest Business Suite.",
    url: "https://clikkle.com/products",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest All Products",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "All Products | Wurknest Business Suite",
    description: "Explore all products offered by Wurknest Business Suite.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/products",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function Products() {
  return <AllProducts />;
}
