import { Metadata } from "next";
import PrivacyPolicyComponent from "../../clikklepages/privacyPolicy";

export const metadata: Metadata = {
  title: "Privacy Policy | Wurknest Business Suite - Data Protection",
  description: "Read Wurknest's privacy policy to understand how we protect your business data. Learn about our data collection, usage, storage practices, and your privacy rights when using our business suite.",
  keywords: "privacy policy, data protection, business data privacy, clikkle privacy, data security, privacy rights, GDPR compliance, business privacy",
  openGraph: {
    title: "Privacy Policy | Wurknest Business Suite - Data Protection",
    description: "Read Wurknest's privacy policy to understand how we protect your business data and your privacy rights.",
    url: "https://clikkle.com/privacy-policy",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Privacy Policy",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Privacy Policy | Wurknest Business Suite - Data Protection",
    description: "Read Wurknest's privacy policy to understand how we protect your business data.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/privacy-policy",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function PrivacyPolicyHome() {
  return <PrivacyPolicyComponent />;
}