import { Metadata } from "next";
import WurknestHome from "@/clikklepages/clikkleHome";

export const metadata: Metadata = {
  title: "Wurknest | Business Apps And Collaboration Tools",
  description:
    "Transform your business with Wurknest's comprehensive suite. CRM, HR management, project tracking, file sharing, e-signature, team chat, and collaboration tools all in one powerful platform. Start your free trial today!",
  keywords:
    "business suite, all-in-one software, CRM, HR management, project management, file sharing, e-signature, team collaboration, business tools, productivity software, business automation",
  openGraph: {
    title: "Wurknest | Business Apps And Collaboration Tools",
    description:
      "Transform your business with Wurknest's comprehensive suite. CRM, HR, project management, and collaboration tools all in one platform.",
    url: "https://clikkle.com",
    siteName: "Wurknest",
    images: [
      {
        url: "https://cdn.clikkle.com/images/clikkle/logo/2025/clikkle.png",
        width: 1200,
        height: 1200,
        alt: "Wurknest Business Suite Platform - All Your Business Tools in One Place",
      },
    ],
    locale: "en_US",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest | Business Apps And Collaboration Tools",
    description:
      "Transform your business with Wurknest's comprehensive suite. All your business tools in one powerful platform.",
    images: ["https://cdn.clikkle.com/images/clikkle/logo/2025/clikkle.png"],
  },
  alternates: {
    canonical: "https://clikkle.com",
  },
  icons: {
    icon: [
      { url: "/icon.png?v=2", sizes: "any", type: "image/png" },
    ],
    apple: [
      { url: "/apple-icon.png?v=2", sizes: "any", type: "image/png" },
    ],
    shortcut: ["/icon.png?v=2"],
    other: [
      { rel: "icon", url: "/favicon.ico?v=2" },
    ],
  },
};

export default function Home() {
  return <WurknestHome isHub={false} />;
}
