"use client";
import React from "react";
import Link from "next/link";
import { FaExclamationTriangle } from "react-icons/fa";

const NotFound = () => {
  return (
    <div className="min-h-screen h-screen bg-white dark:bg-[#0a0a0a] text-gray-900 dark:text-white overflow-hidden flex items-center justify-center">
      {/* Hero Section */}
      <section className="relative w-full h-full flex items-center justify-center px-4">
        {/* Decorative Background Elements */}
        <div className="absolute inset-0 overflow-hidden">
          <div className="absolute top-20 left-10 w-72 h-72 bg-gray-900/5 dark:bg-white/5 rounded-full blur-3xl" />
          <div className="absolute bottom-20 right-10 w-96 h-96 bg-gray-900/5 dark:bg-white/5 rounded-full blur-3xl" />
          <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[800px] h-[800px] bg-gray-900/3 dark:bg-white/3 rounded-full blur-3xl" />
        </div>

        <div className="container mx-auto max-w-5xl relative z-10">
          <div className="text-center space-y-8">
            {/* Badge */}
            <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 mb-4">
              <FaExclamationTriangle className="text-gray-900 dark:text-white" />
              <span className="text-sm font-semibold text-gray-900 dark:text-white tracking-wider uppercase">
                404 Error
              </span>
            </div>

            {/* Main Heading */}
            <h1 className="text-8xl md:text-9xl font-extrabold text-gray-900 dark:text-white leading-tight">
              404
            </h1>

            <h2 className="text-4xl md:text-5xl lg:text-6xl font-bold text-gray-900 dark:text-white leading-tight">
              Page Not Found
            </h2>

            {/* Description */}
            <p className="text-lg md:text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto leading-relaxed">
              Sorry, the page you&apos;re looking for doesn&apos;t exist or has been moved.
              Let&apos;s get you back on track.
            </p>

            {/* CTA Buttons */}
            <div className="flex flex-wrap items-center justify-center gap-4 pt-6">
              <Link href="/">
                <button className="px-8 py-4 bg-gray-900 dark:bg-white text-white dark:text-black rounded-2xl font-semibold hover:scale-105 transition-all duration-300 shadow-lg">
                  Go Back Home
                </button>
              </Link>
              <Link href="/products">
                <button className="px-8 py-4 bg-white/50 dark:bg-black/50 backdrop-blur-sm border border-gray-900/10 dark:border-white/10 text-gray-900 dark:text-white rounded-2xl font-semibold hover:scale-105 transition-all duration-300">
                  Browse Products
                </button>
              </Link>
            </div>

            {/* Helpful Links */}
            <div className="pt-12">
              <div className="flex flex-wrap items-center justify-center gap-4">
                <Link href="/about" className="text-sm text-gray-900 dark:text-white hover:underline">
                  About Us
                </Link>
                <span className="text-gray-400">•</span>
                <Link href="/contact" className="text-sm text-gray-900 dark:text-white hover:underline">
                  Contact
                </Link>
                <span className="text-gray-400">•</span>
                <Link href="/support" className="text-sm text-gray-900 dark:text-white hover:underline">
                  Support
                </Link>
                <span className="text-gray-400">•</span>
                <Link href="/blogs" className="text-sm text-gray-900 dark:text-white hover:underline">
                  Blog
                </Link>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
};

export default NotFound;
