import { Metadata } from "next";
import HrHomePage from "../../clikklepages/hrHome";

export const metadata: Metadata = {
  title: "Wurknest HR | HR Management Software | Human Resources System",
  description:
    "Transform your HR operations with Wurknest's comprehensive HR management software. Streamline employee onboarding, track performance, manage payroll, and automate HR processes with our powerful human resources platform.",
  keywords:
    "HR software, human resources management, employee onboarding, payroll management, performance tracking, HR automation, workforce management, employee database",
  openGraph: {
    title: "Wurknest HR | HR Management Software | Human Resources System",
    description:
      "Streamline HR operations with Wurknest's HR management software. Employee onboarding, payroll, and performance tracking.",
    url: "https://clikkle.com/hr",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest HR Management Dashboard",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest HR | HR Management Software | Human Resources System",
    description:
      "Streamline HR operations with Wurknest's comprehensive HR management platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/hr",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function HrHome() {
  return <HrHomePage />;
}
