import { Metadata } from "next";
import FilesHomePage from "../../clikklepages/filesHome";

export const metadata: Metadata = {
  title: "Wurknest Files | File Management & Cloud Storage | Secure File Sharing",
  description:
    "Store, organize, and share files securely with Wurknest's file management system. Cloud storage, file sharing, document collaboration, and secure access controls for your business files.",
  keywords:
    "file management, cloud storage, file sharing, document collaboration, secure file storage, business file management, document organization, file access control",
  openGraph: {
    title: "Wurknest Files | File Management & Cloud Storage | Secure File Sharing",
    description:
      "Store and share files securely with Wurknest's file management system. Cloud storage and document collaboration for teams.",
    url: "https://clikkle.com/files",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest File Management Dashboard",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest Files | File Management & Cloud Storage | Secure File Sharing",
    description:
      "Store and share files securely with Wurknest's file management platform.",
    images: [
      "/icon.png?v=2",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com/files",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function FilesHome() {
  return <FilesHomePage />;
}
