import { Metadata } from "next";
import EsignHomePage from "../../clikklepages/esignHome";

export const metadata: Metadata = {
  title: "Wurknest eSign | Digital Document Signing",
  description: "Sign documents digitally with Wurknest's e-signature software. Secure electronic signatures, document workflows, legally binding signatures, and streamlined approval processes for your business documents.",
  keywords: "e-signature software, digital signatures, electronic signature, document signing, digital document workflow, legally binding signatures, e-signature platform, document approval",
  openGraph: {
    title: "Wurknest eSign | Digital Document Signing",
    description: "Sign documents digitally with Wurknest's secure e-signature software. Streamline your document approval processes.",
    url: "https://clikkle.com/esign",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest eSignature Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest eSign | Digital Document Signing",
    description: "Sign documents digitally with Wurknest's secure e-signature platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/esign",
  },
    icons: {
    icon: "/icon.png?v=2",
    apple:
      "/icon.png?v=2",
  },
};

export default function EsignHome() {
  return <EsignHomePage />;
}