import { Metadata } from "next";
import CrmHomePage from "../../clikklepages/crmHome";

export const metadata: Metadata = {
  title: "Wurknest CRM | Customer Relationship Management",
  description:
    "Streamline your customer relationships with Wurknest's powerful CRM software. Track leads, manage contacts, automate sales processes, and grow your business with our intuitive customer relationship management platform.",
  keywords:
    "CRM software, customer relationship management, sales automation, lead tracking, contact management, sales pipeline, customer management, business CRM",
  openGraph: {
    title: "Wurknest CRM | Customer Relationship Management",
    description:
      "Manage your customer relationships effectively with Wurknest's CRM. Track leads, automate sales, and grow your business.",
    url: "https://clikkle.com/crm",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest CRM Dashboard Interface",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest CRM | Customer Relationship Management",
    description:
      "Manage your customer relationships effectively with Wurknest's CRM platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/crm",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function CrmHome() {
  return <CrmHomePage />;
}