import { Metadata } from "next";
import CreatorAIHome from "@/clikklepages/creatorAi";

export const metadata: Metadata = {
  title: "Wurknest Creator AI | AI-Powered Content Creation Suite",
  description: "Transform your content creation with Wurknest Creator AI. Generate SEO-optimized articles, create stunning visuals, remove backgrounds, and produce professional content 10x faster with AI-powered tools.",
  keywords: "AI content creation, AI writing tool, AI image generator, background remover, content creator tools, AI article writer, text to image AI, content automation, AI content suite",
  openGraph: {
    title: "Wurknest Creator AI | AI-Powered Content Creation Suite",
    description: "Transform your content creation with AI. Generate articles, create visuals, remove backgrounds, and produce professional content 10x faster.",
    url: "https://clikkle.com/creator",
    siteName: "Wurknest",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Creator AI - AI-Powered Content Creation Suite",
      }
    ],
    locale: "en_US",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest Creator AI | AI-Powered Content Creation Suite",
    description: "Transform your content creation with AI. Generate articles, create visuals, and produce professional content 10x faster.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/creator",
  },
    icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function CreatorHome() {
 return <CreatorAIHome />;
}
