import { Metadata } from "next";
import ContactComponent from "../../clikklepages/contact";

export const metadata: Metadata = {
  title: "Contact Wurknest | Business Suite Support & Sales",
  description: "Get in touch with Wurknest for sales inquiries, customer support, or general questions about our all-in-one business suite. Contact our team for demos, pricing, and assistance.",
  keywords: "contact clikkle, business suite support, sales inquiry, customer support, contact us, get in touch, clikkle help, business software support",
  openGraph: {
    title: "Contact Wurknest | Business Suite Support & Sales",
    description: "Get in touch with Wurknest for sales inquiries, customer support, or general questions about our all-in-one business suite.",
    url: "https://clikkle.com/contact",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Contact Wurknest - Support & Sales",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Contact Wurknest | Business Suite Support & Sales",
    description: "Get in touch with Wurknest for sales inquiries and customer support.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/contact",
  },
    icons: {
    icon: "/icon.png?v=2",
    apple:
      "/icon.png?v=2",
  },
};

export default function ContactHome() {
  return <ContactComponent />;
}