import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Wurknest Cmail | Business Email Management | Email Marketing Software",
  description: "Manage business emails effectively with Wurknest's email management software. Email marketing campaigns, newsletter creation, email automation, and comprehensive email analytics for better customer engagement.",
  keywords: "business email, email management, email marketing, newsletter software, email automation, email campaigns, email analytics, business email platform",
  openGraph: {
    title: "Wurknest Cmail | Business Email Management | Email Marketing Software",
    description: "Manage business emails effectively with Wurknest's email management software. Email marketing and newsletter creation.",
    url: "https://clikkle.com/cmail",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Email Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest Cmail | Business Email Management | Email Marketing Software",
    description: "Manage business emails effectively with Wurknest's email management platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/cmail",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function CmailHome() {
      return (
        <ComingSoon/>
    )
}