import { Metadata } from "next";
import ChatHomePage from "../../clikklepages/chatHome";

export const metadata: Metadata = {
  title:
    "Wurknest Chat | Team Chat & Communication Software | Business Messaging",
  description:
    "Enhance team communication with Wurknest's business chat software. Real-time messaging, team collaboration, file sharing, video calls, and secure business communication tools for modern teams.",
  keywords:
    "team chat software, business messaging, team communication, real-time chat, business collaboration, video calls, secure messaging, team messaging app",
  openGraph: {
    title:
      "Wurknest Chat | Team Chat & Communication Software | Business Messaging",
    description:
      "Enhance team communication with Wurknest's business chat software. Real-time messaging and collaboration tools.",
    url: "https://clikkle.com/chat",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Team Chat Interface",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title:
      "Wurknest Chat | Team Chat & Communication Software | Business Messaging",
    description:
      "Enhance team communication with Wurknest's business chat platform.",
    images: [
      "/icon.png?v=2",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com/chat",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function ChatHome() {
  return <ChatHomePage />;
}
