import { Metadata } from "next";
import CampaignsHomeComponent from "../../clikklepages/campaignsHome";

export const metadata: Metadata = {
  title:
    "Wurknest Campaigns | Marketing Campaign Management Software | Campaign Tracking",
  description:
    "Manage marketing campaigns effectively with Wurknest's campaign management software. Track campaign performance, manage budgets, analyze ROI, and optimize your marketing efforts with comprehensive campaign tools.",
  keywords:
    "campaign management, marketing campaigns, campaign tracking, marketing automation, campaign analytics, ROI tracking, marketing tools, campaign optimization",
  openGraph: {
    title:
      "Wurknest Campaigns | Marketing Campaign Management Software | Campaign Tracking",
    description:
      "Manage marketing campaigns effectively with Wurknest's campaign management tools. Track performance and optimize ROI.",
    url: "https://clikkle.com/campaigns",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Campaign Management Dashboard",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title:
      "Wurknest Campaigns | Marketing Campaign Management Software | Campaign Tracking",
    description:
      "Manage marketing campaigns effectively with Wurknest's campaign management tools.",
    images: [
      "/icon.png?v=2",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com/campaigns",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple:
      "/icon.png?v=2",
  },
};

export default function CampaignsHome() {
  return <CampaignsHomeComponent />;
}
