import ComingSoon from "@/clikklepages/comingSoon";
import { Metadata } from "next";

export const metadata: Metadata = {
  title: "Wurknest Calendar | Business Calendar & Scheduling Software | Team Calendar",
  description: "Organize your business schedule with Wurknest's calendar software. Team scheduling, appointment booking, meeting management, and integrated calendar tools for better time management.",
  keywords: "business calendar, scheduling software, team calendar, appointment booking, meeting management, time management, calendar integration, scheduling tools",
  openGraph: {
    title: "Wurknest Calendar | Business Calendar & Scheduling Software | Team Calendar",
    description: "Organize your business schedule with Wurknest's calendar software. Team scheduling and appointment booking.",
    url: "https://clikkle.com/calendar",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Business Calendar Interface",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest Calendar | Business Calendar & Scheduling Software | Team Calendar",
    description: "Organize your business schedule with Wurknest's calendar platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/calendar",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function CalendarHome() {
    return (
        <ComingSoon/>
    )
}