import PartnersPage from "@/clikklepages/partnersPage";
import { Metadata } from "next";

export const metadata: Metadata = {
  title: "Affiliate Program | Earn with Wurknest Business Suite",
  description:
    "Join Wurknest's affiliate program and earn commissions by promoting our all-in-one business suite. Get marketing materials, tracking tools, and competitive commission rates for referring customers.",
  keywords:
    "affiliate program, business software affiliate, earn commissions, referral program, affiliate marketing, business suite affiliate, partner program, earn money online",
  openGraph: {
    title: "Affiliate Program | Earn with Wurknest Business Suite",
    description:
      "Join Wurknest's affiliate program and earn commissions by promoting our all-in-one business suite. Get marketing materials and tracking tools.",
    url: "https://clikkle.com/affiliate-program",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Affiliate Program - Earn Commissions",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Affiliate Program | Earn with Wurknest Business Suite",
    description:
      "Join Wurknest's affiliate program and earn commissions by promoting our business suite.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/affiliate-program",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function AffiliateProgram() {
  return <PartnersPage />;
}
