import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Wurknest Ads | Digital Advertising Management | Ad Campaign Software",
  description: "Optimize your digital advertising with Wurknest's ad management software. Create, manage, and track ad campaigns across multiple platforms. Monitor ROI, analyze performance, and maximize your advertising budget.",
  keywords: "digital advertising, ad management, advertising campaigns, ad campaign software, digital ads, advertising platform, ad tracking, advertising ROI, campaign optimization",
  openGraph: {
    title: "Wurknest Ads | Digital Advertising Management | Ad Campaign Software",
    description: "Optimize your digital advertising with Wurknest's ad management software. Create and manage ad campaigns across multiple platforms.",
    url: "https://clikkle.com/ads",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "Wurknest Ad Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Wurknest Ads | Digital Advertising Management | Ad Campaign Software",
    description: "Optimize your digital advertising with Wurknest's ad management platform.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/ads",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function AdsHome() {
      return (
        <ComingSoon/>
    )
}