import { Metadata } from "next";
import AboutUsComponent from "../../clikklepages/aboutUs";

export const metadata: Metadata = {
  title: "About Wurknest | All-in-One Business Suite Company",
  description: "Learn about Wurknest's mission to provide comprehensive business solutions. Discover our story, values, and commitment to helping businesses streamline operations with our all-in-one platform.",
  keywords: "about clikkle, company story, business suite company, our mission, company values, business software company, clikkle team",
  openGraph: {
    title: "About Wurknest | All-in-One Business Suite Company",
    description: "Learn about Wurknest's mission to provide comprehensive business solutions. Discover our story and values.",
    url: "https://clikkle.com/about",
    images: [
      {
        url: "/icon.png?v=2",
        width: 1200,
        height: 1200,
        alt: "About Wurknest - Company Information",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "About Wurknest | All-in-One Business Suite Company",
    description: "Learn about Wurknest's mission to provide comprehensive business solutions.",
    images: ["/icon.png?v=2"],
  },
  alternates: {
    canonical: "https://clikkle.com/about",
  },
  icons: {
    icon: "/icon.png?v=2",
    apple: "/icon.png?v=2",
  },
};

export default function AboutHome() {
  return <AboutUsComponent />;
}